<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Product;
use App\Models\Tax;

class FixProductTax extends Command
{
    protected $signature = 'product:fix-tax {product_id} {--zero-rated} {--exempt}';
    protected $description = 'Fix tax settings for a specific product';

    public function handle()
    {
        $productId = $this->argument('product_id');
        $product = Product::find($productId);
        
        if (!$product) {
            $this->error("Product ID {$productId} not found!");
            return;
        }
        
        $this->info("Product: {$product->sku} - {$product->name}");
        $this->info("Current: has_vat = {$product->has_vat}, tax_id = {$product->tax_id}");
        
        if ($this->option('zero-rated')) {
            $tax = Tax::where('rate', 0)->first();
            if ($tax) {
                $product->update([
                    'has_vat' => 1,
                    'tax_id' => $tax->id
                ]);
                $this->info("✅ Set to zero-rated VAT (tax: {$tax->name})");
            }
        } elseif ($this->option('exempt')) {
            $product->update([
                'has_vat' => 0,
                'tax_id' => null
            ]);
            $this->info("✅ Set to VAT-exempt");
        } else {
            $this->error("Please specify --zero-rated or --exempt option");
        }
    }
}