<div class="modal fade" id="barcodeModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white">
                <h5 class="modal-title">
                    <i class="bx bx-barcode me-2"></i>Barcode Scanner
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body">
                <!-- Scanner Preview -->
                <div class="scanner-preview mb-3">
                    <div id="scanner-container" class="scanner-container">
                        <video id="scanner-video" class="scanner-video" autoplay playsinline></video>
                        <div id="scanner-overlay" class="scanner-overlay"></div>
                    </div>
                    <div class="scanner-status text-center mt-2">
                        <small id="scannerStatus" class="text-muted">Initializing scanner...</small>
                    </div>
                </div>
                
                <!-- Manual Barcode Input -->
                <div class="manual-input mb-3">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bx bx-barcode"></i>
                        </span>
                        <input type="text" 
                               class="form-control" 
                               id="manualBarcodeInput" 
                               placeholder="Enter barcode manually"
                               autocomplete="off">
                        <button class="btn btn-primary" id="scanBarcodeBtn">
                            <i class="bx bx-search"></i> Search
                        </button>
                    </div>
                </div>
                
                <!-- Product Preview -->
                <div class="product-preview" id="productPreview" style="display: none;">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-start gap-3">
                                <div class="product-image-placeholder">
                                    <i class="bx bx-package fs-1 text-muted"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6 id="productName" class="mb-1"></h6>
                                    <div class="row g-2 small">
                                        <div class="col-6">
                                            <div>Price: <span id="productPrice" class="fw-bold"></span></div>
                                        </div>
                                        <div class="col-6">
                                            <div>Stock: <span id="productStock" class="fw-bold"></span></div>
                                        </div>
                                        <div class="col-6">
                                            <div>SKU: <span id="productSku" class="text-muted"></span></div>
                                        </div>
                                        <div class="col-6">
                                            <div>Barcode: <span id="productBarcode" class="text-muted"></span></div>
                                        </div>
                                    </div>
                                    <div class="mt-3">
                                        <button class="btn btn-sm btn-success" id="addScannedProduct">
                                            <i class="bx bx-cart-add me-1"></i> Add to Cart
                                        </button>
                                        <button class="btn btn-sm btn-outline-secondary" id="scanAnother">
                                            <i class="bx bx-redo me-1"></i> Scan Another
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Scans -->
                <div class="recent-scans mt-3" id="recentScans" style="display: none;">
                    <h6 class="mb-2">Recent Scans</h6>
                    <div class="list-group" id="recentScansList">
                        <!-- Recent scans will be added here -->
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <div class="w-100 d-flex justify-content-between align-items-center">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="autoAddToCart" checked>
                        <label class="form-check-label small" for="autoAddToCart">
                            Auto-add to cart
                        </label>
                    </div>
                    <div>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .scanner-container {
        position: relative;
        width: 100%;
        height: 250px;
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        overflow: hidden;
        background: #f8f9fa;
    }
    
    .scanner-video {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .scanner-overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 200px;
        height: 100px;
        border: 2px solid rgba(0, 255, 0, 0.5);
        box-shadow: 0 0 0 1000px rgba(0, 0, 0, 0.7);
    }
    
    .product-image-placeholder {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .recent-scans .list-group-item {
        padding: 8px 12px;
        font-size: 13px;
        cursor: pointer;
    }
    
    .recent-scans .list-group-item:hover {
        background-color: #f8f9fa;
    }
</style>

<!-- NO JAVASCRIPT HERE - All JavaScript is in scanner.js module --><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/pos-barcode-modal.blade.php ENDPATH**/ ?>