<div class="sidebar-wrapper" data-simplebar="true">
    <div class="sidebar-header">
        <div>
            <img src="<?php echo e(asset('assets/images/autopos.png')); ?>" class="logo-icon" alt="logo icon">
        </div>
        <div>
            <h4 class="logo-text"><?php echo e(config('app.name', 'AutoPOS')); ?></h4>
        </div>
        <div class="toggle-icon ms-auto"><i class='bx bx-arrow-to-left'></i></div>
    </div>
    
    <!--navigation-->
    <ul class="metismenu" id="menu">
        <!-- Dashboard -->
        <li>
            <a href="<?php echo e(route('dashboard')); ?>">
                <div class="parent-icon"><i class='bx bx-home'></i></div>
                <div class="menu-title">Dashboard</div>
            </a>
        </li>

        <!-- POS -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'cashier|manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('pos.index')); ?>">
                <div class="parent-icon"><i class='bx bx-cart-alt'></i></div>
                <div class="menu-title">POS</div>
            </a>
        </li>
        <?php endif; ?>

        <li class="menu-label">Products & Inventory</li>

        <!-- Products Management -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-package'></i></div>
                <div class="menu-title">Products</div>
            </a>
            <ul>
                <!-- Product Listing -->
                <li>
                    <a href="<?php echo e(route('products.index')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>All Products
                    </a>
                </li>
                
                <!-- Add New Product -->
                <li>
                    <a href="<?php echo e(route('products.create')); ?>">
                        <i class="bx bx-plus-circle"></i>Add New Product
                    </a>
                </li>
                
                <!-- Categories -->
                <li>
                    <a href="<?php echo e(route('categories.index')); ?>">
                        <i class="bx bx-category"></i>Categories
                    </a>
                </li>
                
                <!-- Product Batches -->
                <li>
                    <a href="<?php echo e(route('batches.index')); ?>">
                        <i class="bx bx-layer"></i>Product Batches
                    </a>
                </li>
                
                <!-- Brands -->
                <li>
                    <a href="<?php echo e(route('brands.index')); ?>">
                        <i class="bx bx-tag"></i>Brands
                    </a>
                </li>
                
                <!-- Units -->
                <li>
                    <a href="<?php echo e(route('units.index')); ?>">
                        <i class="bx bx-ruler"></i>Units
                    </a>
                </li>
                
                <!-- Pricing Management -->
                <li>
                    <a href="<?php echo e(route('products.pricing.index')); ?>">
                        <i class="bx bx-dollar-circle"></i>Pricing Management
                    </a>
                </li>
                
                <!-- Import/Export -->
                <li>
                    <a href="javascript:;" class="has-arrow">
                        <i class="bx bx-right-arrow-alt"></i>Import/Export
                    </a>
                    <ul>
                        <li>
                            <a href="<?php echo e(route('products.import')); ?>">
                                <i class="bx bx-import"></i>Import Products
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('products.export')); ?>">
                                <i class="bx bx-export"></i>Export Products
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('products.template.download')); ?>">
                                <i class="bx bx-download"></i>Download Template
                            </a>
                        </li>
                    </ul>
                </li>
                
                <!-- Product Reports -->
                <li>
                    <a href="javascript:;" class="has-arrow">
                        <i class="bx bx-right-arrow-alt"></i>Reports
                    </a>
                    <ul>
                        <li>
                            <a href="<?php echo e(route('products.statistics')); ?>">
                                <i class="bx bx-bar-chart"></i>Product Statistics
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('products.expiry-report')); ?>">
                                <i class="bx bx-calendar-exclamation"></i>Expiry Report
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.inventory')); ?>">
                                <i class="bx bx-archive"></i>Inventory Report
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Inventory Management -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-archive'></i></div>
                <div class="menu-title">Inventory</div>
            </a>
            <ul>
                <li>
                    <a href="<?php echo e(route('batches.expiry-alerts')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>Expiry Alerts
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('products.index')); ?>?stock_status=low_stock">
                        <i class="bx bx-right-arrow-alt"></i>Low Stock Items
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('products.index')); ?>?stock_status=out_of_stock">
                        <i class="bx bx-right-arrow-alt"></i>Out of Stock Items
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <li class="menu-label">Sales & Purchases</li>

        <!-- Sales -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'cashier|manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('pos.index')); ?>">
                <div class="parent-icon"><i class='bx bx-money'></i></div>
                <div class="menu-title">Sales</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Customers -->
        <li>
            <a href="<?php echo e(route('customers.index')); ?>">
                <div class="parent-icon"><i class='bx bx-user'></i></div>
                <div class="menu-title">Customers</div>
            </a>
        </li>

        <!-- Purchases -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'purchaser|manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('purchases.index')); ?>">
                <div class="parent-icon"><i class='bx bx-purchase-tag'></i></div>
                <div class="menu-title">Purchases</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Suppliers -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'purchaser|manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('suppliers.index')); ?>">
                <div class="parent-icon"><i class='bx bx-store'></i></div>
                <div class="menu-title">Suppliers</div>
            </a>
        </li>
        <?php endif; ?>

        <li class="menu-label">Analytics & Reports</li>

        <!-- Reports Dashboard -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('reports.index')); ?>">
                <div class="parent-icon"><i class='bx bx-bar-chart-alt'></i></div>
                <div class="menu-title">Reports Dashboard</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Analytics -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-line-chart'></i></div>
                <div class="menu-title">Analytics</div>
            </a>
            <ul>
                <li>
                    <a href="<?php echo e(route('reports.sales')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>Sales Analytics
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('reports.customers')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>Customer Analytics
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('reports.suppliers')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>Supplier Analytics
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('price-histories.analytics')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>Price Analytics
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <li class="menu-label">System Management</li>

        <!-- Users Management -->
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-user-circle'></i></div>
                <div class="menu-title">Users</div>
            </a>
            <ul>
                <li>
                    <a href="<?php echo e(route('users.index')); ?>">
                        <i class="bx bx-right-arrow-alt"></i>All Users
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('users.create')); ?>">
                        <i class="bx bx-user-plus"></i>Add New User
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('users.statistics')); ?>">
                        <i class="bx bx-bar-chart"></i>User Statistics
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('users.import')); ?>">
                        <i class="bx bx-import"></i>Import Users
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Settings -->
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
        <li>
            <a href="<?php echo e(route('settings.index')); ?>">
                <div class="parent-icon"><i class='bx bx-cog'></i></div>
                <div class="menu-title">Settings</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Taxes -->
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
        <li>
            <a href="<?php echo e(route('taxes.index')); ?>">
                <div class="parent-icon"><i class='bx bx-receipt'></i></div>
                <div class="menu-title">Tax Settings</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Activity Logs -->
        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
        <li>
            <a href="<?php echo e(route('activities.index')); ?>">
                <div class="parent-icon"><i class='bx bx-history'></i></div>
                <div class="menu-title">Activity Logs</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- Printers -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('printers.index')); ?>">
                <div class="parent-icon"><i class='bx bx-printer'></i></div>
                <div class="menu-title">Printers</div>
            </a>
        </li>
        <?php endif; ?>

        <!-- M-Pesa -->
        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', 'manager|admin')): ?>
        <li>
            <a href="<?php echo e(route('mpesa.index')); ?>">
                <div class="parent-icon"><i class='bx bx-mobile-alt'></i></div>
                <div class="menu-title">M-Pesa</div>
            </a>
        </li>
        <?php endif; ?>

        <li class="menu-label">Personal</li>

        <!-- Profile -->
        <li>
            <a href="<?php echo e(route('profile.edit')); ?>">
                <div class="parent-icon"><i class='bx bx-user'></i></div>
                <div class="menu-title">My Profile</div>
            </a>
        </li>



        <!-- Quick Search -->
        <li>
            <a href="javascript:;" onclick="toggleQuickSearch()">
                <div class="parent-icon"><i class='bx bx-search'></i></div>
                <div class="menu-title">Quick Search</div>
            </a>
        </li>

        <!-- Help & Support -->
        <li>
            <a href="#">
                <div class="parent-icon"><i class='bx bx-help-circle'></i></div>
                <div class="menu-title">Help & Support</div>
            </a>
        </li>
    </ul>
    <!--end navigation-->
</div>

<!-- Quick Search Modal -->
<div class="modal fade" id="quickSearchModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick Search</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="input-group mb-3">
                    <input type="text" class="form-control" id="globalSearch" placeholder="Search products, customers, sales...">
                    <button class="btn btn-primary" type="button">
                        <i class='bx bx-search'></i>
                    </button>
                </div>
                <div id="searchResults" class="mt-3">
                    <!-- Search results will appear here -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleQuickSearch() {
    $('#quickSearchModal').modal('show');
    $('#globalSearch').focus();
}

$(document).ready(function() {
    $('#globalSearch').on('keyup', function() {
        const query = $(this).val();
        if (query.length > 2) {
            $.ajax({
                url: '<?php echo e(route("ajax.products")); ?>',
                method: 'GET',
                data: { search: query },
                success: function(response) {
                    let html = '';
                    if (response.length > 0) {
                        html += '<h6>Products:</h6>';
                        response.forEach(product => {
                            html += `<a href="<?php echo e(route('products.index')); ?>/${product.id}" class="d-block text-decoration-none py-1">
                                <i class="bx bx-package me-2"></i>${product.name}
                                <span class="float-end text-muted">${product.code || ''}</span>
                            </a>`;
                        });
                    } else {
                        html = '<p class="text-muted">No results found</p>';
                    }
                    $('#searchResults').html(html);
                }
            });
        }
    });
});
</script><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/layouts/nav.blade.php ENDPATH**/ ?>