

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/sweetalert/sweetalert2.min.css')); ?>" rel="stylesheet" />
    <style>
        .customer-card {
            transition: transform 0.2s;
        }
        .customer-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .customer-type-badge {
            font-size: 0.7rem;
            padding: 0.2rem 0.5rem;
        }
        .customer-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            margin-right: 10px;
        }
        .balance-positive { color: #198754; }
        .balance-negative { color: #dc3545; }
        .balance-zero { color: #6c757d; }
        .vat-badge {
            font-size: 0.65rem;
            padding: 0.15rem 0.4rem;
        }
        .loyalty-badge {
            background: linear-gradient(45deg, #FFD700, #FFA500);
            color: #000;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Customers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Customers</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                        <i class="bx bx-plus"></i> Add New Customer
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="<?php echo e(route('customers.export')); ?>">
                            <i class="bx bx-download"></i> Export to CSV
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('customers.export.vat')); ?>">
                            <i class="bx bx-receipt"></i> Export VAT Report
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('customers.vat-report')); ?>">
                            <i class="bx bx-file"></i> VAT Report
                        </a>
                        <a class="dropdown-item" href="#" id="bulkDeleteBtn">
                            <i class="bx bx-trash"></i> Bulk Delete
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" onclick="window.print()">
                            <i class="bx bx-printer"></i> Print List
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Customers</p>
                                <h4 class="my-1 text-info"><?php echo e(number_format($stats['total'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
                                <i class='bx bxs-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Regular Customers</p>
                                <h4 class="my-1 text-success"><?php echo e(number_format($stats['regular'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                <i class='bx bxs-user-check'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Walk-in Customers</p>
                                <h4 class="my-1 text-warning"><?php echo e(number_format($stats['walk_in'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                <i class='bx bxs-user'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-danger">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Revenue</p>
                                <h4 class="my-1 text-danger">KES<?php echo e(number_format($stats['total_revenue'] ?? 0, 2)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-bloody text-white ms-auto">
                                <i class='bx bxs-dollar-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Statistics -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Business Customers</p>
                                <h4 class="my-1 text-primary"><?php echo e(number_format($stats['business'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white ms-auto">
                                <i class='bx bx-building'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-purple">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">VAT Registered</p>
                                <h4 class="my-1 text-purple"><?php echo e(number_format($stats['vat_registered'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-purple text-white ms-auto">
                                <i class='bx bx-receipt'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-orange">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total VAT Collected</p>
                                <h4 class="my-1 text-orange">KES<?php echo e(number_format($stats['total_vat_collected'] ?? 0, 2)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto">
                                <i class='bx bx-money'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-teal">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Loyalty Points</p>
                                <h4 class="my-1 text-teal"><?php echo e(number_format($stats['total_loyalty_points'] ?? 0)); ?></h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-teal text-white ms-auto">
                                <i class='bx bx-gift'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filter -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('customers.index')); ?>" id="searchForm">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="input-group">
                                <input type="text" class="form-control" name="search" 
                                       placeholder="Search by name, email, phone, VAT..." 
                                       value="<?php echo e(request('search')); ?>">
                                <button class="btn btn-outline-secondary" type="submit">
                                    <i class="bx bx-search"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="type" onchange="document.getElementById('searchForm').submit()">
                                <option value="">All Customers</option>
                                <option value="walk-in" <?php echo e(request('type') == 'walk-in' ? 'selected' : ''); ?>>
                                    Walk-in Customers
                                </option>
                                <option value="regular" <?php echo e(request('type') == 'regular' ? 'selected' : ''); ?>>
                                    Regular Customers
                                </option>
                                <option value="business" <?php echo e(request('type') == 'business' ? 'selected' : ''); ?>>
                                    Business Customers
                                </option>
                                <option value="active" <?php echo e(request('type') == 'active' ? 'selected' : ''); ?>>
                                    Active Customers
                                </option>
                                <option value="with-balance" <?php echo e(request('type') == 'with-balance' ? 'selected' : ''); ?>>
                                    With Balance
                                </option>
                                <option value="vat-registered" <?php echo e(request('type') == 'vat-registered' ? 'selected' : ''); ?>>
                                    VAT Registered
                                </option>
                                <option value="non-vat" <?php echo e(request('type') == 'non-vat' ? 'selected' : ''); ?>>
                                    Non-VAT
                                </option>
                                <option value="has-credit" <?php echo e(request('type') == 'has-credit' ? 'selected' : ''); ?>>
                                    Has Credit Limit
                                </option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="sort_by" onchange="document.getElementById('searchForm').submit()">
                                <option value="created_at" <?php echo e(request('sort_by') == 'created_at' ? 'selected' : ''); ?>>
                                    Sort by Date
                                </option>
                                <option value="name" <?php echo e(request('sort_by') == 'name' ? 'selected' : ''); ?>>
                                    Sort by Name
                                </option>
                                <option value="total_spent" <?php echo e(request('sort_by') == 'total_spent' ? 'selected' : ''); ?>>
                                    Sort by Total Spent
                                </option>
                                <option value="vat_collected" <?php echo e(request('sort_by') == 'vat_collected' ? 'selected' : ''); ?>>
                                    Sort by VAT Collected
                                </option>
                                <option value="last_purchase_date" <?php echo e(request('sort_by') == 'last_purchase_date' ? 'selected' : ''); ?>>
                                    Sort by Last Purchase
                                </option>
                                <option value="credit_balance" <?php echo e(request('sort_by') == 'credit_balance' ? 'selected' : ''); ?>>
                                    Sort by Credit Balance
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-outline-secondary w-100">
                                <i class="bx bx-refresh"></i> Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="card">
            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-check-circle"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Success</h6>
                                <div class="text-white"><?php echo e(session('success')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-message-square-x"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Error</h6>
                                <div class="text-white"><?php echo e(session('error')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-error"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Validation Errors</h6>
                                <ul class="text-white mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if($customers->count() > 0): ?>
                    <div class="table-responsive">
                        <table id="customersTable" class="table table-striped table-bordered" style="width:100%">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th>Customer</th>
                                    <th>Contact</th>
                                    <th>Type/Status</th>
                                    <th>Sales Statistics</th>
                                    <th>Credit/Balance</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input select-item" type="checkbox" 
                                                   value="<?php echo e($customer->id); ?>">
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="customer-avatar" 
                                                 style="background: <?php echo e($customer->customer_type == 'walk-in' ? '#ffc107' : ($customer->customer_type == 'business' ? '#0d6efd' : '#198754')); ?>">
                                                <?php echo e(strtoupper(substr($customer->name, 0, 1))); ?>

                                            </div>
                                            <div>
                                                <h6 class="mb-1 font-14"><?php echo e($customer->name); ?></h6>
                                                <p class="mb-0 font-12 text-muted">
                                                    <?php if($customer->company_name): ?>
                                                        <i class="bx bx-building"></i> <?php echo e($customer->company_name); ?>

                                                    <?php else: ?>
                                                        <i class="bx bx-id-card"></i> <?php echo e($customer->customer_code); ?>

                                                    <?php endif; ?>
                                                </p>
                                                <p class="mb-0 font-11 text-muted">
                                                    <?php if($customer->email): ?>
                                                        <i class="bx bx-envelope"></i> <?php echo e($customer->email); ?>

                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <?php if($customer->phone): ?>
                                                <div class="mb-1">
                                                    <i class="bx bx-phone"></i> <?php echo e($customer->phone); ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php if($customer->vat_number): ?>
                                                <div class="font-12 text-muted">
                                                    <i class="bx bx-receipt"></i> VAT: <?php echo e($customer->vat_number); ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php if($customer->contact_person): ?>
                                                <div class="font-12 text-muted">
                                                    <i class="bx bx-user"></i> <?php echo e($customer->contact_person); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="mb-1">
                                            <?php if($customer->customer_type == 'walk-in'): ?>
                                                <span class="badge bg-warning text-dark customer-type-badge">
                                                    <i class="bx bx-walk"></i> Walk-in
                                                </span>
                                            <?php elseif($customer->customer_type == 'regular'): ?>
                                                <span class="badge bg-success customer-type-badge">
                                                    <i class="bx bx-user"></i> Regular
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-primary customer-type-badge">
                                                    <i class="bx bx-building"></i> Business
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="mb-1">
                                            <?php if($customer->status == 'active'): ?>
                                                <span class="badge bg-light-success text-success status-badge">
                                                    <i class="bx bx-check-circle"></i> Active
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-light-secondary text-secondary status-badge">
                                                    <i class="bx bx-time"></i> Inactive
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div>
                                            <?php if($customer->is_vat_registered): ?>
                                                <span class="badge bg-purple vat-badge">
                                                    <i class="bx bx-check"></i> VAT Registered
                                                </span>
                                            <?php endif; ?>
                                            <?php if($customer->loyalty_points > 0): ?>
                                                <span class="badge loyalty-badge vat-badge">
                                                    <i class="bx bx-gift"></i> <?php echo e($customer->loyalty_points); ?> pts
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <div class="mb-1">
                                                <strong>KES<?php echo e(number_format($customer->total_spent, 2)); ?></strong>
                                                <small class="text-muted">total spent</small>
                                            </div>
                                            <div class="mb-1">
                                                <small class="text-muted">
                                                    <i class="bx bx-shopping-bag"></i> <?php echo e($customer->total_orders); ?> orders
                                                    <?php if($customer->total_orders > 0): ?>
                                                        (KES<?php echo e(number_format($customer->average_order_value, 2)); ?> avg)
                                                    <?php endif; ?>
                                                </small>
                                            </div>
                                            <div class="mb-1">
                                                <small class="text-muted">
                                                    <i class="bx bx-calendar"></i> 
                                                    <?php if($customer->last_purchase_date): ?>
                                                        Last: <?php echo e($customer->last_purchase_date->format('M d, Y')); ?>

                                                    <?php else: ?>
                                                        Never purchased
                                                    <?php endif; ?>
                                                </small>
                                            </div>
                                            <?php if($customer->taxable_sales > 0): ?>
                                            <div>
                                                <small class="text-muted">
                                                    <i class="bx bx-receipt"></i> 
                                                    VAT: KES<?php echo e(number_format($customer->vat_collected, 2)); ?>

                                                    (<?php echo e(number_format($customer->vat_rate_effective, 1)); ?>%)
                                                </small>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <?php if($customer->credit_limit > 0): ?>
                                                <div class="mb-1">
                                                    <strong class="<?php echo e($customer->balance > 0 ? 'balance-negative' : 'balance-zero'); ?>">
                                                        <i class="bx bx-credit-card"></i> KES<?php echo e(number_format($customer->balance, 2)); ?>

                                                    </strong>
                                                    <small class="text-muted d-block">Balance</small>
                                                </div>
                                                <div class="mb-1">
                                                    <small class="text-muted">
                                                        Limit: KES<?php echo e(number_format($customer->credit_limit, 2)); ?>

                                                    </small>
                                                </div>
                                                <div>
                                                    <small class="text-muted">
                                                        Available: <span class="text-success">KES<?php echo e(number_format($customer->available_credit, 2)); ?></span>
                                                    </small>
                                                </div>
                                            <?php else: ?>
                                                <div class="mb-1">
                                                    <span class="balance-zero">
                                                        <i class="bx bx-check"></i> KES 0.00
                                                    </span>
                                                    <small class="text-muted d-block">No Credit</small>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($customer->discount_percent > 0): ?>
                                                <div class="mt-1">
                                                    <small class="text-success">
                                                        <i class="bx bx-discount"></i> <?php echo e($customer->discount_percent); ?>% Discount
                                                    </small>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="<?php echo e(route('customers.show', $customer)); ?>" 
                                               class="btn btn-sm btn-outline-info" 
                                               data-bs-toggle="tooltip" 
                                               title="View Details">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            <a href="<?php echo e(route('customers.edit', $customer)); ?>" 
                                               class="btn btn-sm btn-outline-primary ms-2"
                                               data-bs-toggle="tooltip"
                                               title="Edit">
                                                <i class="bx bx-edit"></i>
                                            </a>
                                            <a href="<?php echo e(route('pos.index')); ?>?customer_id=<?php echo e($customer->id); ?>" 
                                               class="btn btn-sm btn-outline-success ms-2"
                                               data-bs-toggle="tooltip"
                                               title="New Sale">
                                                <i class="bx bx-cart-add"></i>
                                            </a>
                                            <form action="<?php echo e(route('customers.destroy', $customer)); ?>" 
                                                  method="POST" 
                                                  class="ms-2 delete-form">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger delete-btn"
                                                        data-bs-toggle="tooltip"
                                                        title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing <?php echo e($customers->firstItem()); ?> to <?php echo e($customers->lastItem()); ?> 
                            of <?php echo e($customers->total()); ?> entries
                        </div>
                        <div>
                            <?php echo e($customers->links()); ?>

                        </div>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <div class="mb-3">
                            <i class="bx bx-user bx-lg text-muted"></i>
                        </div>
                        <h5 class="text-muted">No customers found</h5>
                        <p class="text-muted mb-4">
                            <?php if(request()->has('search') || request()->has('type')): ?>
                                Try changing your search criteria
                            <?php else: ?>
                                Get started by adding your first customer
                            <?php endif; ?>
                        </p>
                        <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add New Customer
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/sweetalert/sweetalert2.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#customersTable').DataTable({
                paging: false, // We use Laravel pagination
                searching: false, // We use custom search
                info: false,
                order: [],
                columnDefs: [
                    { orderable: false, targets: [0, 6] }
                ],
                language: {
                    emptyTable: "No customers found"
                }
            });

            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Select all functionality
            $('#selectAll').change(function() {
                $('.select-item').prop('checked', this.checked);
            });

            // Delete confirmation
            $('.delete-btn').click(function(e) {
                e.preventDefault();
                var form = $(this).closest('form');
                
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This customer will be permanently deleted!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // First check if customer has sales
                        var customerId = form.find('input[name="_method"]').siblings('input[type="hidden"]').val() || 
                                       form.attr('action').split('/').pop();
                        
                        $.ajax({
                            url: '/api/customers/' + customerId + '/has-sales',
                            type: 'GET',
                            success: function(response) {
                                if (response.success && response.has_sales) {
                                    Swal.fire({
                                        title: 'Cannot Delete',
                                        text: 'This customer has ' + response.sales_count + ' sales records. Please delete or reassign sales first.',
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                } else {
                                    form.submit();
                                }
                            },
                            error: function() {
                                form.submit();
                            }
                        });
                    }
                });
            });

            // Bulk delete
            $('#bulkDeleteBtn').click(function(e) {
                e.preventDefault();
                var selectedIds = [];
                $('.select-item:checked').each(function() {
                    selectedIds.push($(this).val());
                });
                
                if (selectedIds.length === 0) {
                    Swal.fire({
                        title: 'No Selection',
                        text: 'Please select at least one customer to delete.',
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                    });
                    return;
                }
                
                Swal.fire({
                    title: 'Delete Selected Customers?',
                    text: "You are about to delete " + selectedIds.length + " customer(s). This action cannot be undone!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete them!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '<?php echo e(route("customers.bulk-delete")); ?>',
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                ids: selectedIds
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        title: 'Deleted!',
                                        text: response.message,
                                        icon: 'success',
                                        confirmButtonColor: '#3085d6',
                                    }).then(() => {
                                        location.reload();
                                    });
                                } else {
                                    Swal.fire({
                                        title: 'Error!',
                                        text: response.message,
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                }
                            },
                            error: function() {
                                Swal.fire({
                                    title: 'Error!',
                                    text: 'An error occurred while deleting customers.',
                                    icon: 'error',
                                    confirmButtonColor: '#3085d6',
                                });
                            }
                        });
                    }
                });
            });

            // Quick search with debounce
            var searchTimer;
            $('input[name="search"]').on('keyup', function() {
                clearTimeout(searchTimer);
                searchTimer = setTimeout(function() {
                    $('#searchForm').submit();
                }, 500);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/customers/index.blade.php ENDPATH**/ ?>