<!-- resources/views/pos/components/pos-cart.blade.php -->
<div class="card h-100">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><i class="bx bx-cart me-2"></i>Cart</h5>
        <div>
            <span class="badge bg-light text-dark" id="cartCount">0</span>
            <button class="btn btn-sm btn-light ms-2" onclick="POSCart.clear()">
                <i class="bx bx-trash"></i>
            </button>
        </div>
    </div>
    <div class="card-body p-0 d-flex flex-column" style="overflow: hidden;">
        <!-- Cart Items -->
        <div class="flex-grow-1" style="overflow-y: auto;">
            <div id="emptyCartState" class="text-center py-5">
                <i class="bx bx-cart fs-1 text-muted mb-3"></i>
                <p class="text-muted">Cart is empty</p>
                <p class="small text-muted">Add products from the grid</p>
            </div>
            <div id="cartItemsList" class="d-none"></div>
        </div>
        
        <!-- Cart Summary -->
        <div class="border-top">
            <div class="p-3">
                <div class="d-flex justify-content-between mb-2">
                    <span>Subtotal:</span>
                    <span id="cartSubtotal" class="fw-bold">KES 0.00</span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span>VAT:</span>
                    <span id="cartVat" class="fw-bold">KES 0.00</span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span>Discount:</span>
                    <span id="cartDiscount" class="fw-bold text-danger">-KES 0.00</span>
                </div>
                <hr>
                <div class="d-flex justify-content-between mb-3">
                    <span class="h5 mb-0">TOTAL:</span>
                    <span id="cartTotal" class="h5 mb-0 text-primary">KES 0.00</span>
                </div>
                <button id="checkoutBtn" class="btn btn-primary w-100 py-3" 
                        onclick="POSPayments.showModal()" disabled>
                    <i class="bx bx-credit-card me-2"></i>CHECKOUT
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Cart Item Template -->
<template id="cartItemTemplate">
    <div class="cart-item p-3 border-bottom">
        <div class="d-flex justify-content-between align-items-start mb-2">
            <div class="flex-grow-1">
                <h6 class="cart-item-name mb-1 fw-bold"></h6>
                <div class="small text-muted">
                    <span class="cart-item-price me-3"></span>
                    <span class="cart-item-sku">SKU: </span>
                </div>
                <div class="cart-item-vat-info small"></div>

            </div>
            <div class="text-end">
                <div class="cart-item-total fw-bold"></div>
                <button class="btn btn-sm btn-link text-danger" onclick="removeFromCart(this)">
                    <i class="bx bx-trash"></i>
                </button>
            </div>
        </div>
        <div class="d-flex align-items-center">
            <div class="btn-group btn-group-sm">
                <button class="btn btn-outline-secondary" onclick="decreaseQuantity(this)">
                    <i class="bx bx-minus"></i>
                </button>
                <input type="number" class="quantity-input text-center" 
                       min="1" value="1" style="width: 50px;">
                <button class="btn btn-outline-secondary" onclick="increaseQuantity(this)">
                    <i class="bx bx-plus"></i>
                </button>
            </div>
        </div>
    </div>
</template>

<style>
    .cart-wrapper {
        min-height: 600px;
    }
    
    .cart-item {
        padding: 12px;
        border-bottom: 1px solid #f1f5f9;
        transition: background-color 0.2s;
    }
    
    .cart-item:hover {
        background-color: #f8fafc;
    }
    
    .cart-item:last-child {
        border-bottom: none;
    }
    
    .cart-item-name {
        font-size: 14px;
        color: #1e293b;
    }
    
    .cart-item-price {
        font-size: 12px;
    }
    
    .cart-item-total {
        font-size: 15px;
        color: #2a4365;
        min-width: 80px;
    }
    
    .cart-item-meta .badge {
        font-size: 10px;
        padding: 2px 6px;
    }
    
    .quantity-control {
        display: flex;
        align-items: center;
        gap: 5px;
    }
    
    .quantity-input {
        width: 60px;
        text-align: center;
        border-color: #cbd5e1;
    }
    
    .quantity-control .btn {
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0;
    }
    
    .empty-cart-state {
        opacity: 0.7;
    }
    
    .empty-icon {
        font-size: 48px;
        color: #cbd5e1;
    }
    
    @media (max-width: 768px) {
        .cart-item-controls {
            flex-wrap: wrap;
        }
        
        .quantity-control {
            order: 1;
        }
        
        .cart-item-controls .ms-auto {
            order: 2;
            width: 100%;
            margin-top: 10px;
            display: flex;
            justify-content: flex-end;
        }
    }
</style><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/pos-cart.blade.php ENDPATH**/ ?>