<template id="bankFormTemplate">
    <div class="payment-form bank-form">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i>
            <strong>Bank Transfer:</strong> Record bank payment details
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="bankType" class="form-label">Transfer Type *</label>
                <select class="form-select" id="bankType" required>
                    <option value="">Select Type</option>
                    <option value="eft">EFT (Electronic Funds Transfer)</option>
                    <option value="rtgs">RTGS (Real Time Gross Settlement)</option>
                    <option value="cheque">Cheque</option>
                    <option value="bank_deposit">Bank Deposit</option>
                    <option value="pesalink">PesaLink</option>
                    <option value="other">Other</option>
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control" id="bankAmount" readonly>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="bankReference" class="form-label">Reference Number *</label>
                <input type="text" class="form-control" id="bankReference" 
                       placeholder="e.g., TRX123456789" required>
                <div class="form-text">Bank transaction reference</div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="bankDate" class="form-label">Transaction Date *</label>
                <input type="date" class="form-control" id="bankDate" required 
                       value="<?php echo e(date('Y-m-d')); ?>">
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="bankName" class="form-label">Bank Name</label>
                <input type="text" class="form-control" id="bankName" 
                       placeholder="e.g., Equity Bank">
            </div>
            <div class="col-md-6 mb-3">
                <label for="bankAccount" class="form-label">Account Number</label>
                <input type="text" class="form-control" id="bankAccount" 
                       placeholder="Customer account number">
            </div>
        </div>
        
        <div class="mb-3">
            <label for="bankNotes" class="form-label">Additional Details</label>
            <textarea class="form-control" id="bankNotes" rows="3" 
                      placeholder="Add any additional bank transfer details..."></textarea>
        </div>
        
        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" id="bankConfirmed" required>
            <label class="form-check-label" for="bankConfirmed">
                <i class="bx bx-check-shield me-1"></i>
                I confirm that the funds have been received in our bank account
            </label>
        </div>
        
        <div class="alert alert-warning">
            <i class="bx bx-error-circle me-2"></i>
            <strong>Important:</strong> Only confirm payment after verifying funds in your bank account.
        </div>
    </div>
</template><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/payment-forms/bank.blade.php ENDPATH**/ ?>