<template id="cashFormTemplate">
    <div class="payment-form cash-form">
        <div class="alert alert-success">
            <i class="bx bx-info-circle me-2"></i>
            <strong>Cash Payment:</strong> Enter amount received from customer
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Sale Total</label>
                <div class="input-group">
                    <span class="input-group-text bg-light">KES</span>
                    <input type="text" class="form-control form-control-lg fw-bold text-success" 
                           id="cashTotalAmount" readonly style="font-size: 1.2rem;">
                </div>
                <div class="form-text">Total amount including VAT</div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="cashReceived" class="form-label">Cash Received *</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text bg-success text-white">KES</span>
                    <input type="number" class="form-control form-control-lg" id="cashReceived" 
                           placeholder="0.00" step="0.01" min="0" required autofocus
                           autocomplete="off" inputmode="decimal">
                </div>
                <div class="form-text">Amount given by customer</div>
            </div>
        </div>
        
        <!-- Quick Amount Buttons -->
        <div class="mb-3">
            <label class="form-label">Quick Amounts:</label>
            <div class="quick-amounts d-flex flex-wrap gap-2">
                <button type="button" class="btn btn-outline-primary quick-amount-btn" data-amount="500">
                    KES 500
                </button>
                <button type="button" class="btn btn-outline-primary quick-amount-btn" data-amount="1000">
                    KES 1,000
                </button>
                <button type="button" class="btn btn-outline-primary quick-amount-btn" data-amount="2000">
                    KES 2,000
                </button>
                <button type="button" class="btn btn-outline-primary quick-amount-btn" data-amount="5000">
                    KES 5,000
                </button>
                <button type="button" class="btn btn-outline-success" id="exactChangeBtn">
                    <i class="bx bx-calculator me-1"></i>Exact Change
                </button>
                <button type="button" class="btn btn-outline-info" id="noChangeBtn">
                    <i class="bx bx-check-circle me-1"></i>Exact Amount
                </button>
            </div>
        </div>
        
        <!-- Change Display -->
        <div id="cashChangeDisplay" class="alert alert-success mt-3" style="display: none;">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="text-muted small">Change to Return</div>
                    <div id="changeAmount" class="fs-4 fw-bold">KES 0.00</div>
                    <div class="small text-muted">Give this amount to customer</div>
                </div>
                <i class="bx bx-money fs-1 text-success"></i>
            </div>
        </div>
        
        <!-- Insufficient Amount Warning -->
        <div id="cashWarningDisplay" class="alert alert-danger mt-3" style="display: none;">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="text-muted small">Additional Amount Needed</div>
                    <div id="insufficientAmount" class="fs-4 fw-bold">KES 0.00</div>
                    <div class="small text-muted">Ask customer for this amount</div>
                </div>
                <i class="bx bx-error-circle fs-1 text-danger"></i>
            </div>
        </div>
        
        <!-- Cash Payment Notes -->
        <div class="mb-3">
            <label for="cashNotes" class="form-label">Notes (Optional)</label>
            <textarea class="form-control" id="cashNotes" rows="2" 
                      placeholder="Add any notes about this cash payment..."></textarea>
        </div>
    </div>
</template><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/payment-forms/cash.blade.php ENDPATH**/ ?>