

<?php $__env->startSection('style'); ?>
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/sweetalert/sweetalert2.min.css')); ?>" rel="stylesheet" />
    <style>
        .category-card {
            transition: transform 0.2s;
        }
        .category-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .category-icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            margin-right: 15px;
        }
        .category-badge {
            font-size: 0.7rem;
            padding: 0.2rem 0.5rem;
        }
        .category-tree {
            margin-left: 20px;
            border-left: 2px solid #dee2e6;
            padding-left: 20px;
        }
        .subcategory-item {
            padding: 8px 12px;
            margin: 5px 0;
            background: #f8f9fa;
            border-radius: 5px;
            border-left: 3px solid #dee2e6;
        }
        .no-data-icon {
            font-size: 4rem;
            color: #dee2e6;
        }
        .category-color-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 8px;
            border: 1px solid #dee2e6;
        }
        .action-buttons {
            min-width: 160px;
        }
        .stats-card {
            transition: all 0.3s;
            cursor: pointer;
        }
        .stats-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        .filter-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        .bulk-actions-bar {
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 5px;
            border: 1px solid #dee2e6;
            margin-bottom: 15px;
        }
        .page-size-selector {
            width: 80px;
        }
        .status-badge {
            min-width: 80px;
            display: inline-block;
            text-align: center;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Categories</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">All Categories</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary">
                        <i class="bx bx-plus"></i> Add New Category
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="<?php echo e(route('categories.tree')); ?>">
                            <i class="bx bx-sitemap"></i> Tree View
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('categories.export')); ?>">
                            <i class="bx bx-download"></i> Export to CSV
                        </a>
                        <a class="dropdown-item" href="#" id="bulkDeleteBtn">
                            <i class="bx bx-trash"></i> Bulk Delete
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="<?php echo e(route('categories.index', ['filter' => 'archived'])); ?>">
                            <i class="bx bx-archive"></i> View Archived
                        </a>
                        <a class="dropdown-item" href="#" onclick="window.print()">
                            <i class="bx bx-printer"></i> Print List
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info stats-card" 
                     onclick="window.location.href='<?php echo e(route('categories.index')); ?>'">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Categories</p>
                                <h4 class="my-1 text-info"><?php echo e($stats['total'] ?? 0); ?></h4>
                                <p class="mb-0 font-13 text-muted">
                                    <i class="bx bx-up-arrow-alt text-success"></i> 
                                    <?php echo e($stats['parent_categories'] ?? 0); ?> parents
                                </p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
                                <i class='bx bxs-category'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success stats-card"
                     onclick="window.location.href='<?php echo e(route('categories.index', ['filter' => 'with-products'])); ?>'">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">With Products</p>
                                <h4 class="my-1 text-success"><?php echo e($stats['with_products'] ?? 0); ?></h4>
                                <p class="mb-0 font-13 text-muted">
                                    <i class="bx bx-package text-primary"></i> 
                                    <?php echo e($stats['total_products'] ?? 0); ?> total products
                                </p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                <i class='bx bxs-package'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-primary stats-card"
                     onclick="window.location.href='<?php echo e(route('categories.index', ['filter' => 'active'])); ?>'">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active Categories</p>
                                <h4 class="my-1 text-primary"><?php echo e($stats['active'] ?? 0); ?></h4>
                                <p class="mb-0 font-13 text-muted">
                                    <i class="bx bx-check-circle text-success"></i> 
                                    <?php echo e($stats['inactive'] ?? 0); ?> inactive
                                </p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-bloody text-white ms-auto">
                                <i class='bx bxs-check-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning stats-card"
                     onclick="window.location.href='<?php echo e(route('categories.index', ['filter' => 'archived'])); ?>'">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Archived</p>
                                <h4 class="my-1 text-warning"><?php echo e($stats['archived'] ?? 0); ?></h4>
                                <p class="mb-0 font-13 text-muted">
                                    <i class="bx bx-archive-in text-warning"></i> 
                                    Soft deleted
                                </p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                <i class='bx bxs-archive'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filter -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('categories.index')); ?>" id="searchForm">
                    <div class="row g-3">
                        <div class="col-md-5">
                            <div class="input-group">
                                <span class="input-group-text"><i class="bx bx-search"></i></span>
                                <input type="text" class="form-control" name="search" 
                                       placeholder="Search by name, description..." 
                                       value="<?php echo e(request('search')); ?>"
                                       id="searchInput">
                                <?php if(request()->has('search')): ?>
                                    <a href="<?php echo e(route('categories.index', request()->except('search', 'page'))); ?>" 
                                       class="btn btn-outline-secondary" type="button">
                                        <i class="bx bx-x"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="filter" id="filterSelect">
                                <option value="">All Categories</option>
                                <option value="active" <?php echo e(request('filter') == 'active' ? 'selected' : ''); ?>>
                                    Active Only
                                </option>
                                <option value="inactive" <?php echo e(request('filter') == 'inactive' ? 'selected' : ''); ?>>
                                    Inactive Only
                                </option>
                                <option value="with-products" <?php echo e(request('filter') == 'with-products' ? 'selected' : ''); ?>>
                                    With Products
                                </option>
                                <option value="without-products" <?php echo e(request('filter') == 'without-products' ? 'selected' : ''); ?>>
                                    Without Products
                                </option>
                                <option value="parent" <?php echo e(request('filter') == 'parent' ? 'selected' : ''); ?>>
                                    Parent Categories
                                </option>
                                <option value="child" <?php echo e(request('filter') == 'child' ? 'selected' : ''); ?>>
                                    Child Categories
                                </option>
                                <option value="archived" <?php echo e(request('filter') == 'archived' ? 'selected' : ''); ?>>
                                    Archived
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" name="sort_by" id="sortSelect">
                                <option value="sort_order" <?php echo e(request('sort_by') == 'sort_order' ? 'selected' : ''); ?>>
                                    Sort Order
                                </option>
                                <option value="name" <?php echo e(request('sort_by') == 'name' ? 'selected' : ''); ?>>
                                    Name A-Z
                                </option>
                                <option value="products_count" <?php echo e(request('sort_by') == 'products_count' ? 'selected' : ''); ?>>
                                    Most Products
                                </option>
                                <option value="created_at" <?php echo e(request('sort_by') == 'created_at' ? 'selected' : ''); ?>>
                                    Newest First
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex gap-2">
                                <select class="form-select page-size-selector" name="per_page" id="perPageSelect">
                                    <option value="10" <?php echo e(request('per_page', 20) == 10 ? 'selected' : ''); ?>>10</option>
                                    <option value="20" <?php echo e(request('per_page', 20) == 20 ? 'selected' : ''); ?>>20</option>
                                    <option value="50" <?php echo e(request('per_page', 20) == 50 ? 'selected' : ''); ?>>50</option>
                                    <option value="100" <?php echo e(request('per_page', 20) == 100 ? 'selected' : ''); ?>>100</option>
                                </select>
                                <a href="<?php echo e(route('categories.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="bx bx-refresh"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Active Filters Badges -->
                    <?php if(request()->anyFilled(['search', 'filter', 'sort_by'])): ?>
                    <div class="mt-3">
                        <div class="d-flex flex-wrap gap-2">
                            <?php if(request()->has('search')): ?>
                                <span class="badge bg-info bg-opacity-10 text-info filter-badge">
                                    Search: "<?php echo e(request('search')); ?>"
                                    <a href="<?php echo e(route('categories.index', array_merge(request()->except('search'), ['page' => 1]))); ?>" 
                                       class="text-info ms-1">
                                        <i class="bx bx-x"></i>
                                    </a>
                                </span>
                            <?php endif; ?>
                            <?php if(request()->has('filter') && request('filter') != ''): ?>
                                <span class="badge bg-primary bg-opacity-10 text-primary filter-badge">
                                    Filter: <?php echo e(ucfirst(str_replace('-', ' ', request('filter')))); ?>

                                    <a href="<?php echo e(route('categories.index', array_merge(request()->except('filter'), ['page' => 1]))); ?>" 
                                       class="text-primary ms-1">
                                        <i class="bx bx-x"></i>
                                    </a>
                                </span>
                            <?php endif; ?>
                            <?php if(request()->has('sort_by') && request('sort_by') != ''): ?>
                                <span class="badge bg-success bg-opacity-10 text-success filter-badge">
                                    Sorted by: <?php echo e(ucfirst(str_replace('_', ' ', request('sort_by')))); ?>

                                    <a href="<?php echo e(route('categories.index', array_merge(request()->except('sort_by'), ['page' => 1]))); ?>" 
                                       class="text-success ms-1">
                                        <i class="bx bx-x"></i>
                                    </a>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <!-- Bulk Actions Bar -->
        <div class="bulk-actions-bar" id="bulkActionsBar" style="display: none;">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <span class="me-3" id="selectedCount">0 items selected</span>
                    <div class="btn-group">
                        <button type="button" class="btn btn-outline-primary btn-sm" id="bulkActivateBtn">
                            <i class="bx bx-check-circle"></i> Activate
                        </button>
                        <button type="button" class="btn btn-outline-warning btn-sm" id="bulkDeactivateBtn">
                            <i class="bx bx-time"></i> Deactivate
                        </button>
                        <button type="button" class="btn btn-outline-danger btn-sm" id="bulkDeleteSelectedBtn">
                            <i class="bx bx-trash"></i> Delete
                        </button>
                    </div>
                </div>
                <button type="button" class="btn btn-outline-secondary btn-sm" id="clearSelectionBtn">
                    <i class="bx bx-x"></i> Clear Selection
                </button>
            </div>
        </div>

        <!-- Main Content -->
        <div class="card">
            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-check-circle"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Success</h6>
                                <div class="text-white"><?php echo e(session('success')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-message-square-x"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Error</h6>
                                <div class="text-white"><?php echo e(session('error')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-error"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Validation Errors</h6>
                                <ul class="text-white mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if($categories->count() > 0): ?>
                    <div class="table-responsive">
                        <table id="categoriesTable" class="table table-striped table-bordered" style="width:100%">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th>Category</th>
                                    <th>Description</th>
                                    <th width="120">Products</th>
                                    <th width="100">Status</th>
                                    <th width="150" class="action-buttons">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="category-card">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input select-item" type="checkbox" 
                                                   value="<?php echo e($category->id); ?>"
                                                   data-name="<?php echo e($category->name); ?>"
                                                   <?php echo e($category->deleted_at ? 'disabled' : ''); ?>>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="category-icon" style="background: <?php echo e($category->color ?? '#667eea'); ?>">
                                                <i class="bx bxs-category"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="d-flex align-items-center">
                                                    <h6 class="mb-1 font-14">
                                                        <span class="category-color-dot" style="background: <?php echo e($category->color ?? '#667eea'); ?>"></span>
                                                        <?php echo e($category->name); ?>

                                                        <?php if(!$category->is_active): ?>
                                                            <span class="badge bg-light-warning text-warning ms-2">Inactive</span>
                                                        <?php endif; ?>
                                                    </h6>
                                                </div>
                                                <?php if($category->parent): ?>
                                                    <p class="mb-0 font-12 text-muted">
                                                        <i class="bx bx-subdirectory-right"></i> 
                                                        Parent: 
                                                        <a href="<?php echo e(route('categories.show', $category->parent)); ?>" 
                                                           class="text-decoration-none">
                                                            <?php echo e($category->parent->name); ?>

                                                        </a>
                                                    </p>
                                                <?php else: ?>
                                                    <p class="mb-0 font-12 text-success">
                                                        <i class="bx bx-category"></i> Main Category
                                                    </p>
                                                <?php endif; ?>
                                                
                                                <!-- Subcategories -->
                                                <?php if(($category->children?->count() ?? 0) > 0): ?>
                                                <div class="category-tree mt-2">
                                                    <small class="text-muted d-block mb-1">
                                                        <i class="bx bx-category-alt"></i> 
                                                        <?php echo e($category->children->count()); ?> subcategories:
                                                    </small>
                                                    <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="subcategory-item d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center">
                                                            <span class="category-color-dot" style="background: <?php echo e($subcategory->color ?? '#667eea'); ?>"></span>
                                                            <span><?php echo e($subcategory->name); ?></span>
                                                            <?php if(($subcategory->products_count ?? 0) > 0): ?>
                                                                <span class="badge bg-light-info text-info ms-2">
                                                                    <?php echo e($subcategory->products_count); ?> products
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="d-flex gap-1">
                                                            <a href="<?php echo e(route('categories.show', $subcategory)); ?>" 
                                                               class="btn btn-xs btn-outline-info px-2 py-1"
                                                               data-bs-toggle="tooltip" 
                                                               title="View">
                                                                <i class="bx bx-show fs-11"></i>
                                                            </a>
                                                            <a href="<?php echo e(route('categories.edit', $subcategory)); ?>" 
                                                               class="btn btn-xs btn-outline-primary px-2 py-1"
                                                               data-bs-toggle="tooltip"
                                                               title="Edit">
                                                                <i class="bx bx-edit fs-11"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($category->description): ?>
                                            <p class="mb-0 text-truncate" style="max-width: 200px;" 
                                               data-bs-toggle="tooltip" title="<?php echo e($category->description); ?>">
                                                <?php echo e($category->description); ?>

                                            </p>
                                        <?php else: ?>
                                            <span class="text-muted font-12">No description</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column align-items-center">
                                            <?php if(($category->products_count ?? 0) > 0): ?>
                                                <span class="badge bg-primary rounded-pill mb-1 status-badge">
                                                    <?php echo e($category->products_count); ?> products
                                                </span>
                                                <a href="<?php echo e(route('products.index', ['category' => $category->id])); ?>" 
                                                   class="btn btn-sm btn-link p-0 text-decoration-none">
                                                    <small><i class="bx bx-link-external"></i> View Products</small>
                                                </a>
                                            <?php else: ?>
                                                <span class="badge bg-light text-muted rounded-pill status-badge">
                                                    0 products
                                                </span>
                                                <small class="text-muted">No products</small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($category->deleted_at): ?>
                                            <span class="badge bg-secondary rounded-pill status-badge">
                                                <i class="bx bxs-archive"></i> Archived
                                                <br>
                                                <small><?php echo e($category->deleted_at->format('M d, Y')); ?></small>
                                            </span>
                                        <?php elseif($category->is_active): ?>
                                            <span class="badge bg-success rounded-pill status-badge">
                                                <i class="bx bx-check-circle"></i> Active
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-warning rounded-pill status-badge">
                                                <i class="bx bx-time"></i> Inactive
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex order-actions gap-1">
                                            <a href="<?php echo e(route('categories.show', $category)); ?>" 
                                               class="btn btn-sm btn-outline-info" 
                                               data-bs-toggle="tooltip" 
                                               title="View Details">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            <a href="<?php echo e(route('categories.edit', $category)); ?>" 
                                               class="btn btn-sm btn-outline-primary"
                                               data-bs-toggle="tooltip"
                                               title="Edit">
                                                <i class="bx bx-edit"></i>
                                            </a>
                                            <?php if($category->deleted_at): ?>
                                                <form action="<?php echo e(route('categories.restore', $category->id)); ?>" 
                                                      method="POST" 
                                                      class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('POST'); ?>
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-outline-success"
                                                            data-bs-toggle="tooltip"
                                                            title="Restore"
                                                            onclick="return confirm('Restore this category?')">
                                                        <i class="bx bx-undo"></i>
                                                    </button>
                                                </form>
                                                <form action="<?php echo e(route('categories.force-delete', $category->id)); ?>" 
                                                      method="POST" 
                                                      class="d-inline delete-form">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            data-bs-toggle="tooltip"
                                                            title="Permanently Delete">
                                                        <i class="bx bx-trash"></i>
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <?php if($category->is_active): ?>
                                                    <form action="<?php echo e(route('categories.update', $category)); ?>" 
                                                          method="POST" 
                                                          class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <input type="hidden" name="is_active" value="0">
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-warning"
                                                                data-bs-toggle="tooltip"
                                                                title="Deactivate"
                                                                onclick="return confirm('Deactivate this category?')">
                                                            <i class="bx bx-power-off"></i>
                                                        </button>
                                                    </form>
                                                <?php else: ?>
                                                    <form action="<?php echo e(route('categories.update', $category)); ?>" 
                                                          method="POST" 
                                                          class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <input type="hidden" name="is_active" value="1">
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-success"
                                                                data-bs-toggle="tooltip"
                                                                title="Activate"
                                                                onclick="return confirm('Activate this category?')">
                                                            <i class="bx bx-check-circle"></i>
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                                
                                                <form action="<?php echo e(route('categories.archive', $category)); ?>" 
                                                      method="POST" 
                                                      class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('POST'); ?>
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-outline-secondary"
                                                            data-bs-toggle="tooltip"
                                                            title="Archive"
                                                            onclick="return confirm('Archive this category?')">
                                                        <i class="bx bx-archive"></i>
                                                    </button>
                                                </form>
                                                <form action="<?php echo e(route('categories.destroy', $category)); ?>" 
                                                      method="POST" 
                                                      class="d-inline delete-form">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            data-bs-toggle="tooltip"
                                                            title="Delete">
                                                        <i class="bx bx-trash"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <div class="text-muted">
                            Showing <strong><?php echo e($categories->firstItem()); ?></strong> to 
                            <strong><?php echo e($categories->lastItem()); ?></strong> of 
                            <strong><?php echo e($categories->total()); ?></strong> categories
                            <?php if(request()->has('filter') && request('filter') == 'archived'): ?>
                                <span class="badge bg-warning ms-2">Archived View</span>
                            <?php endif; ?>
                        </div>
                        <nav aria-label="Page navigation">
                            <?php echo e($categories->links()); ?>

                        </nav>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <div class="mb-3">
                            <i class="bx bx-category no-data-icon"></i>
                        </div>
                        <h5 class="text-muted">No categories found</h5>
                        <p class="text-muted mb-4">
                            <?php if(request()->has('search') || request()->has('filter')): ?>
                                Try changing your search criteria or 
                                <a href="<?php echo e(route('categories.index')); ?>" class="text-decoration-none">clear filters</a>
                            <?php else: ?>
                                Get started by creating your first category
                            <?php endif; ?>
                        </p>
                        <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary px-4">
                            <i class="bx bx-plus"></i> Add New Category
                        </a>
                        <?php if(request()->has('filter') && request('filter') == 'archived'): ?>
                            <a href="<?php echo e(route('categories.index')); ?>" class="btn btn-outline-secondary px-4 ms-2">
                                <i class="bx bx-list-ul"></i> View Active Categories
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/sweetalert/sweetalert2.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            console.log('Categories page loaded - debugging navigation');
            
            // Initialize DataTable
            $('#categoriesTable').DataTable({
                paging: false, // We use Laravel pagination
                searching: false, // We use custom search
                info: false,
                order: [],
                columnDefs: [
                    { orderable: false, targets: [0, 5] }
                ],
                language: {
                    emptyTable: "No categories found"
                }
            });

            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Select all functionality
            $('#selectAll').change(function() {
                var isChecked = this.checked;
                $('.select-item:not(:disabled)').prop('checked', isChecked);
                updateBulkActionsBar();
            });

            // Update bulk actions bar when selection changes
            $('.select-item').change(function() {
                updateBulkActionsBar();
            });

            function updateBulkActionsBar() {
                var selectedCount = $('.select-item:checked').length;
                if (selectedCount > 0) {
                    $('#bulkActionsBar').show();
                    $('#selectedCount').text(selectedCount + ' item' + (selectedCount > 1 ? 's' : '') + ' selected');
                } else {
                    $('#bulkActionsBar').hide();
                }
            }

            // Clear selection
            $('#clearSelectionBtn').click(function() {
                $('.select-item').prop('checked', false);
                $('#selectAll').prop('checked', false);
                updateBulkActionsBar();
            });

            // Delete confirmation
            $('.delete-btn').click(function(e) {
                e.preventDefault();
                var form = $(this).closest('form');
                var isForceDelete = form.attr('action').includes('force');
                var categoryName = form.closest('tr').find('.font-14').text().trim();
                
                Swal.fire({
                    title: isForceDelete ? 'Permanently Delete Category?' : 'Delete Category?',
                    text: isForceDelete 
                        ? `Category "${categoryName}" will be permanently deleted and cannot be recovered!` 
                        : `Are you sure you want to delete "${categoryName}"?`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: isForceDelete ? 'Yes, delete permanently!' : 'Yes, delete it!',
                    cancelButtonText: 'Cancel',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });

            // Bulk delete selected
            $('#bulkDeleteSelectedBtn').click(function(e) {
                e.preventDefault();
                var selectedIds = [];
                var selectedNames = [];
                $('.select-item:checked').each(function() {
                    selectedIds.push($(this).val());
                    selectedNames.push($(this).data('name'));
                });
                
                if (selectedIds.length === 0) {
                    Swal.fire({
                        title: 'No Selection',
                        text: 'Please select at least one category to delete.',
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                    });
                    return;
                }
                
                Swal.fire({
                    title: 'Delete Selected Categories?',
                    html: `<p>You are about to delete <strong>${selectedIds.length}</strong> category(es):</p>
                          <ul class="text-start">
                            ${selectedNames.map(name => `<li>${name}</li>`).join('')}
                          </ul>
                          <p class="text-danger">This action cannot be undone!</p>`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete them!',
                    cancelButtonText: 'Cancel',
                    reverseButtons: true,
                    width: '500px'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '<?php echo e(route("categories.bulk-delete")); ?>',
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                ids: selectedIds
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        title: 'Success!',
                                        text: response.message,
                                        icon: 'success',
                                        confirmButtonColor: '#3085d6',
                                        timer: 2000
                                    }).then(() => {
                                        location.reload();
                                    });
                                } else {
                                    Swal.fire({
                                        title: 'Error!',
                                        html: response.errors ? 
                                            response.errors.join('<br>') : 
                                            response.message,
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                }
                            },
                            error: function(xhr) {
                                var message = 'An error occurred while deleting categories.';
                                if (xhr.responseJSON && xhr.responseJSON.message) {
                                    message = xhr.responseJSON.message;
                                }
                                Swal.fire({
                                    title: 'Error!',
                                    text: message,
                                    icon: 'error',
                                    confirmButtonColor: '#3085d6',
                                });
                            }
                        });
                    }
                });
            });

            // Bulk activate/deactivate
            $('#bulkActivateBtn').click(function() {
                bulkUpdateStatus(1);
            });

            $('#bulkDeactivateBtn').click(function() {
                bulkUpdateStatus(0);
            });

            function bulkUpdateStatus(status) {
                var selectedIds = [];
                var action = status ? 'activate' : 'deactivate';
                
                $('.select-item:checked').each(function() {
                    selectedIds.push($(this).val());
                });
                
                if (selectedIds.length === 0) {
                    Swal.fire({
                        title: 'No Selection',
                        text: `Please select at least one category to ${action}.`,
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                    });
                    return;
                }
                
                Swal.fire({
                    title: `${action.charAt(0).toUpperCase() + action.slice(1)} Categories?`,
                    text: `You are about to ${action} ${selectedIds.length} category(es).`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: `Yes, ${action} them!`,
                    cancelButtonText: 'Cancel',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '<?php echo e(route("categories.bulk-update")); ?>',
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                ids: selectedIds,
                                data: { is_active: status }
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        title: 'Success!',
                                        text: response.message,
                                        icon: 'success',
                                        confirmButtonColor: '#3085d6',
                                        timer: 1500
                                    }).then(() => {
                                        location.reload();
                                    });
                                }
                            },
                            error: function(xhr) {
                                var message = `Failed to ${action} categories.`;
                                if (xhr.responseJSON && xhr.responseJSON.message) {
                                    message = xhr.responseJSON.message;
                                }
                                Swal.fire({
                                    title: 'Error!',
                                    text: message,
                                    icon: 'error',
                                    confirmButtonColor: '#3085d6',
                                });
                            }
                        });
                    }
                });
            }

            // Quick search with debounce
            var searchTimer;
            $('#searchInput').on('keyup', function() {
                clearTimeout(searchTimer);
                searchTimer = setTimeout(function() {
                    $('#searchForm').submit();
                }, 500);
            });

            // Auto-submit filter, sort, and per page selects
            $('#filterSelect, #sortSelect, #perPageSelect').change(function() {
                $('#searchForm').submit();
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut('slow');
            }, 5000);
            
            // Debug: Log navigation clicks
            $(document).on('click', 'a[href*="categories"]', function(e) {
                console.log('Categories link clicked:', {
                    href: $(this).attr('href'),
                    currentUrl: window.location.href,
                    isSamePage: $(this).attr('href') === window.location.href
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/categories/index.blade.php ENDPATH**/ ?>