

<?php $__env->startSection('style'); ?>
    <style>
        .form-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border-left: 4px solid #667eea;
        }
        .form-section h5 {
            color: #495057;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .required-field::after {
            content: " *";
            color: #dc3545;
        }
        .switch-label {
            cursor: pointer;
        }
        .price-input-group {
            position: relative;
        }
        .price-input-group .input-group-text {
            min-width: 100px;
        }
        .expiry-fields {
            background: #fff3cd;
            border-radius: 8px;
            padding: 15px;
            border: 1px solid #ffeaa7;
        }
        .image-upload-container {
            border: 2px dashed #dee2e6;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .image-upload-container:hover {
            border-color: #667eea;
            background: #f8f9fa;
        }
        .image-preview {
            max-width: 200px;
            max-height: 200px;
            border-radius: 10px;
            display: none;
        }
        .form-check-input:checked {
            background-color: #667eea;
            border-color: #667eea;
        }
        .tax-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        .btn-group-tax .btn {
            flex: 1;
        }
        .tax-status-card {
            border-left: 4px solid;
        }
        .tax-status-vat {
            border-left-color: #667eea;
        }
        .tax-status-zero {
            border-left-color: #38a169;
        }
        .tax-status-exempt {
            border-left-color: #718096;
        }
        .tax-preview-card {
            background: linear-gradient(135deg, #667eea0d 0%, #764ba20d 100%);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Products</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('products.index')); ?>">Products</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Add New Product</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bx bx-arrow-back"></i> Back to List
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Add New Product</h4>
                        
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <h6 class="alert-heading mb-2"><i class="bx bx-error-circle"></i> Validation Errors</h6>
                                <ul class="mb-0 ps-3">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="bx bx-error-circle"></i> <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('products.store')); ?>" enctype="multipart/form-data" id="productForm" novalidate>
                            <?php echo csrf_field(); ?>
                            
                            <!-- Basic Information -->
                            <div class="form-section">
                                <h5><i class="bx bx-info-circle"></i> Basic Information</h5>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">Product Name</label>
                                        <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('name')); ?>" required 
                                               placeholder="Enter product name">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">SKU</label>
                                        <input type="text" name="sku" class="form-control <?php $__errorArgs = ['sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('sku')); ?>" required 
                                               placeholder="Enter SKU (must be unique)">
                                        <?php $__errorArgs = ['sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="form-text">Stock Keeping Unit - must be unique</div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Barcode</label>
                                        <input type="text" name="barcode" class="form-control <?php $__errorArgs = ['barcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('barcode')); ?>" 
                                               placeholder="Enter barcode (optional)">
                                        <?php $__errorArgs = ['barcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Reference Number</label>
                                        <input type="text" name="ref_number" class="form-control <?php $__errorArgs = ['ref_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('ref_number')); ?>" 
                                               placeholder="Your internal reference number">
                                        <?php $__errorArgs = ['ref_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">Category</label>
                                        <select name="category_id" class="form-select <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Select Category</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" 
                                                        <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                                    <?php echo e($category->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Brand</label>
                                        <select name="brand_id" class="form-select <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Select Brand</option>
                                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($brand->id); ?>" 
                                                        <?php echo e(old('brand_id') == $brand->id ? 'selected' : ''); ?>>
                                                    <?php echo e($brand->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Supplier</label>
                                        <select name="supplier_id" class="form-select <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Select Supplier</option>
                                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($supplier->id); ?>" 
                                                        <?php echo e(old('supplier_id') == $supplier->id ? 'selected' : ''); ?>>
                                                    <?php echo e($supplier->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Unit</label>
                                        <select name="unit_id" class="form-select <?php $__errorArgs = ['unit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Select Unit</option>
                                            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($unit->id); ?>" 
                                                        <?php echo e(old('unit_id') == $unit->id ? 'selected' : ''); ?>>
                                                    <?php echo e($unit->name); ?> (<?php echo e($unit->abbreviation); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['unit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3" 
                                              placeholder="Product description"><?php echo e(old('description')); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Short Description</label>
                                    <textarea name="short_description" class="form-control <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="2" 
                                              placeholder="Brief description for listings"><?php echo e(old('short_description')); ?></textarea>
                                    <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Pricing -->
                            <div class="form-section">
                                <h5><i class="bx bx-dollar-circle"></i> Pricing</h5>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">Cost Price</label>
                                        <div class="input-group price-input-group">
                                            <span class="input-group-text">KES</span>
                                            <input type="number" name="cost_price" class="form-control <?php $__errorArgs = ['cost_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   step="0.01" min="0" value="<?php echo e(old('cost_price', 0)); ?>" required 
                                                   placeholder="0.00" id="costPrice">
                                        </div>
                                        <?php $__errorArgs = ['cost_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">Sale Price</label>
                                        <div class="input-group price-input-group">
                                            <span class="input-group-text">KES</span>
                                            <input type="number" name="sale_price" class="form-control <?php $__errorArgs = ['sale_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   step="0.01" min="0" value="<?php echo e(old('sale_price', 0)); ?>" required 
                                                   placeholder="0.00" id="salePrice">
                                        </div>
                                        <?php $__errorArgs = ['sale_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Wholesale Price</label>
                                        <div class="input-group price-input-group">
                                            <span class="input-group-text">KES</span>
                                            <input type="number" name="wholesale_price" class="form-control <?php $__errorArgs = ['wholesale_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   step="0.01" min="0" value="<?php echo e(old('wholesale_price')); ?>" 
                                                   placeholder="Optional">
                                        </div>
                                        <?php $__errorArgs = ['wholesale_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="row">
                                            <div class="col-6">
                                                <label class="form-label">Discount Price</label>
                                                <div class="input-group price-input-group">
                                                    <span class="input-group-text">KES</span>
                                                    <input type="number" name="discount_price" class="form-control <?php $__errorArgs = ['discount_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           step="0.01" min="0" value="<?php echo e(old('discount_price')); ?>" 
                                                           placeholder="0.00" id="discountPrice">
                                                </div>
                                                <?php $__errorArgs = ['discount_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-6">
                                                <label class="form-label">Discount %</label>
                                                <div class="input-group price-input-group">
                                                    <input type="number" name="discount_percent" class="form-control <?php $__errorArgs = ['discount_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           min="0" max="100" value="<?php echo e(old('discount_percent')); ?>" 
                                                           placeholder="0" id="discountPercent">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <?php $__errorArgs = ['discount_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="form-text">Enter either discount price or percentage (not both)</div>
                                    </div>
                                </div>
                                
                                <!-- Enhanced Tax Configuration -->
                                <div class="card tax-status-card <?php if(old('tax_status', 'vat') == 'vat'): ?> tax-status-vat <?php elseif(old('tax_status') == 'zero'): ?> tax-status-zero <?php else: ?> tax-status-exempt <?php endif; ?> mb-3">
                                    <div class="card-header">
                                        <h6 class="mb-0"><i class="bx bx-receipt"></i> Tax Configuration</h6>
                                    </div>
                                    <div class="card-body">
                                        <!-- Tax Status Selection -->
                                        <div class="row mb-3">
                                            <div class="col-md-12">
                                                <label class="form-label required-field">Tax Status</label>
                                                <div class="btn-group btn-group-tax w-100" role="group">
                                                    <input type="radio" class="btn-check" name="tax_status" id="taxStatusVat" 
                                                           value="vat" <?php echo e(old('tax_status', 'vat') == 'vat' ? 'checked' : ''); ?>>
                                                    <label class="btn btn-outline-primary" for="taxStatusVat">
                                                        <i class="bx bx-check-shield"></i> VAT Taxable
                                                    </label>
                                                    
                                                    <input type="radio" class="btn-check" name="tax_status" id="taxStatusZero" 
                                                           value="zero" <?php echo e(old('tax_status') == 'zero' ? 'checked' : ''); ?>>
                                                    <label class="btn btn-outline-success" for="taxStatusZero">
                                                        <i class="bx bx-shield-x"></i> Zero-Rated
                                                    </label>
                                                    
                                                    <input type="radio" class="btn-check" name="tax_status" id="taxStatusExempt" 
                                                           value="exempt" <?php echo e(old('tax_status') == 'exempt' ? 'checked' : ''); ?>>
                                                    <label class="btn btn-outline-secondary" for="taxStatusExempt">
                                                        <i class="bx bx-shield"></i> VAT Exempt
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Tax Rate Selection (only for VAT Taxable) -->
                                        <div class="row mb-3" id="taxRateContainer" style="display: <?php echo e(old('tax_status', 'vat') == 'vat' ? 'block' : 'none'); ?>;">
                                            <div class="col-md-6">
                                                <label class="form-label required-field">Select VAT Rate</label>
                                                <div class="input-group">
                                                    <select name="tax_id" class="form-select <?php $__errorArgs = ['tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="taxSelect">
                                                        <option value="">-- Select VAT Rate --</option>
                                                        <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($tax->rate > 0): ?> 
                                                            <option value="<?php echo e($tax->id); ?>" 
                                                                    data-rate="<?php echo e($tax->rate); ?>"
                                                                    <?php echo e(old('tax_id', $defaultTax->id ?? '') == $tax->id ? 'selected' : ''); ?>>
                                                                <?php echo e($tax->name); ?> (<?php echo e($tax->rate); ?>%)
                                                            </option>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <button type="button" class="btn btn-outline-primary" onclick="manageTaxes()">
                                                        <i class="bx bx-cog"></i>
                                                    </button>
                                                </div>
                                                <?php $__errorArgs = ['tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <div class="form-text">Select applicable VAT rate (16%, 8%, etc.)</div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="selectedTaxInfo" class="mt-4" style="display: <?php echo e(old('tax_id') ? 'block' : 'none'); ?>;">
                                                    <div class="alert alert-info p-2">
                                                        <small>
                                                            <i class="bx bx-info-circle"></i>
                                                            Selected: <strong id="taxName"></strong> (<span id="taxRate"></span>%)
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Tax Explanation -->
                                        <div class="alert alert-info">
                                            <small>
                                                <i class="bx bx-info-circle"></i>
                                                <strong>Understanding Tax Options:</strong>
                                                <ul class="mb-0 mt-2">
                                                    <li><strong>VAT Taxable</strong>: Product is subject to VAT (select a rate above)</li>
                                                    <li><strong>Zero-Rated VAT</strong>: VAT applies at 0% rate (for exports/essentials)</li>
                                                    <li><strong>VAT Exempt</strong>: No VAT applies at all (exempt by law)</li>
                                                </ul>
                                            </small>
                                        </div>
                                        
                                        <!-- Hidden fields for backend processing -->
                                        <input type="hidden" name="has_vat" id="hasVatField" value="<?php echo e(old('tax_status', 'vat') == 'exempt' ? '0' : '1'); ?>">
                                        <input type="hidden" name="tax_id_actual" id="taxIdField" value="<?php echo e(old('tax_id', $defaultTax->id ?? '')); ?>">
                                        
                                        <!-- Zero-rated tax info (hidden field) -->
                                        <?php
                                            $zeroRatedTax = $taxes->where('rate', 0)->first();
                                        ?>
                                        <input type="hidden" id="zeroRatedTaxId" value="<?php echo e($zeroRatedTax->id ?? ''); ?>">
                                    </div>
                                </div>
                                
                                <!-- Tax Preview -->
                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="card tax-preview-card">
                                            <div class="card-body p-3">
                                                <h6 class="mb-2"><i class="bx bx-calculator"></i> Tax & Price Preview</h6>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="mb-2">
                                                            <small class="text-muted">Sale Price</small>
                                                            <div class="h5" id="salePricePreview">KES 0.00</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-2">
                                                            <small class="text-muted">Tax Rate</small>
                                                            <div class="h5" id="taxRatePreview">0%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-2">
                                                            <small class="text-muted">Tax Amount</small>
                                                            <div class="h5 text-danger" id="taxAmountPreview">KES 0.00</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-2">
                                                            <small class="text-muted">Total Price</small>
                                                            <div class="h5 text-success" id="totalPricePreview">KES 0.00</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mt-2">
                                                    <div class="col-12">
                                                        <div class="alert <?php if(old('tax_status', 'vat') == 'vat'): ?> alert-warning <?php elseif(old('tax_status') == 'zero'): ?> alert-success <?php else: ?> alert-info <?php endif; ?> p-2" id="taxStatusPreview">
                                                            <small>
                                                                <i class="bx bx-info-circle"></i>
                                                                <strong>Current Status:</strong> 
                                                                <span id="taxStatusText">
                                                                    <?php if(old('tax_status', 'vat') == 'vat'): ?>
                                                                        VAT Taxable 
                                                                        <?php if(old('tax_id')): ?>
                                                                            (<?php echo e($taxes->where('id', old('tax_id'))->first()->rate ?? '0'); ?>%)
                                                                        <?php endif; ?>
                                                                    <?php elseif(old('tax_status') == 'zero'): ?>
                                                                        Zero-Rated VAT (0%)
                                                                    <?php else: ?>
                                                                        VAT Exempt (No VAT)
                                                                    <?php endif; ?>
                                                                </span>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Inventory -->
                            <div class="form-section">
                                <h5><i class="bx bx-package"></i> Inventory Management</h5>
                                
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label required-field">Initial Stock</label>
                                        <input type="number" name="stock" class="form-control <?php $__errorArgs = ['stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               min="0" value="<?php echo e(old('stock', 0)); ?>" required 
                                               placeholder="0">
                                        <?php $__errorArgs = ['stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label required-field">Reorder Point</label>
                                        <input type="number" name="reorder_point" class="form-control <?php $__errorArgs = ['reorder_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               min="0" value="<?php echo e(old('reorder_point', 10)); ?>" required 
                                               placeholder="10">
                                        <?php $__errorArgs = ['reorder_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="form-text">Alert when stock reaches this level</div>
                                    </div>
                                    
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label required-field">Minimum Stock</label>
                                        <input type="number" name="minimum_stock" class="form-control <?php $__errorArgs = ['minimum_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               min="0" value="<?php echo e(old('minimum_stock', 10)); ?>" required 
                                               placeholder="10">
                                        <?php $__errorArgs = ['minimum_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Maximum Stock</label>
                                        <input type="number" name="maximum_stock" class="form-control <?php $__errorArgs = ['maximum_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               min="0" value="<?php echo e(old('maximum_stock')); ?>" 
                                               placeholder="Optional">
                                        <?php $__errorArgs = ['maximum_stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="form-text">Maximum stock capacity (optional)</div>
                                    </div>
                                </div>
                                
                                <!-- Expiry & Batch Tracking -->
                                <div class="expiry-fields mt-3">
                                    <h6><i class="bx bx-calendar"></i> Expiry & Batch Tracking</h6>
                                    
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" name="has_expiry" 
                                                       id="hasExpiry" value="1" 
                                                       <?php echo e(old('has_expiry') ? 'checked' : ''); ?>>
                                                <label class="form-check-label switch-label" for="hasExpiry">
                                                    Has Expiry Date
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4 mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" name="track_batches" 
                                                       id="trackBatches" value="1" 
                                                       <?php echo e(old('track_batches') ? 'checked' : ''); ?>>
                                                <label class="form-check-label switch-label" for="trackBatches">
                                                    Track by Batches
                                                </label>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Expiry Warning (Days)</label>
                                            <input type="number" name="expiry_warning_days" class="form-control <?php $__errorArgs = ['expiry_warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   min="1" max="365" value="<?php echo e(old('expiry_warning_days', 30)); ?>" 
                                                   placeholder="30">
                                            <?php $__errorArgs = ['expiry_warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <div class="form-text">Alert before expiry</div>
                                        </div>
                                    </div>
                                    
                                    <div class="alert alert-info mt-2">
                                        <small>
                                            <i class="bx bx-info-circle"></i> 
                                            <strong>Expiry Tracking:</strong> For products with expiry dates (food, medicine, etc.)<br>
                                            <strong>Batch Tracking:</strong> Track stock by batches/lots. Required for expiry tracking.
                                        </small>
                                    </div>
                                </div>
                            </div>

                            <!-- Status & Options -->
                            <div class="form-section">
                                <h5><i class="bx bx-cog"></i> Status & Options</h5>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label required-field">Status</label>
                                        <select name="status" class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="active" <?php echo e(old('status', 'active') == 'active' ? 'selected' : ''); ?>>
                                                Active
                                            </option>
                                            <option value="inactive" <?php echo e(old('status') == 'inactive' ? 'selected' : ''); ?>>
                                                Inactive
                                            </option>
                                            <option value="discontinued" <?php echo e(old('status') == 'discontinued' ? 'selected' : ''); ?>>
                                                Discontinued
                                            </option>
                                        </select>
                                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-switch mt-4">
                                            <input class="form-check-input" type="checkbox" name="is_featured" 
                                                   id="isFeatured" value="1" 
                                                   <?php echo e(old('is_featured') ? 'checked' : ''); ?>>
                                            <label class="form-check-label switch-label" for="isFeatured">
                                                Featured Product
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Form Actions -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <button type="submit" class="btn btn-primary px-5" id="submitBtn">
                                                <i class="bx bx-save"></i> Save Product
                                            </button>
                                            <button type="reset" class="btn btn-outline-secondary px-5">
                                                <i class="bx bx-reset"></i> Reset Form
                                            </button>
                                        </div>
                                        <div>
                                            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-light px-5">
                                                <i class="bx bx-x"></i> Cancel
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<!-- Include jQuery Validation Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/additional-methods.min.js"></script>

<script>
$(document).ready(function() {
    // Toggle expiry fields
    $('#hasExpiry').change(function() {
        if ($(this).is(':checked')) {
            $('#trackBatches').prop('checked', true).prop('disabled', false);
        } else {
            $('#trackBatches').prop('disabled', false);
        }
    });
    
    // Prevent form submission if validation fails
    $('#productForm').on('submit', function(e) {
        // Get the submit button
        var submitBtn = $('#submitBtn');
        
        // Disable button and show loading state
        submitBtn.prop('disabled', true);
        submitBtn.html('<i class="bx bx-loader bx-spin"></i> Saving...');
        
        // Validate tax selection
        const taxStatus = $('input[name="tax_status"]:checked').val();
        const taxSelect = $('#taxSelect');
        
        if (taxStatus === 'vat' && !taxSelect.val()) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Tax Rate Required',
                text: 'Please select a VAT rate for VAT taxable products.',
                confirmButtonColor: '#3085d6',
            });
            submitBtn.prop('disabled', false);
            submitBtn.html('<i class="bx bx-save"></i> Save Product');
            return false;
        }
        
        // Let the form submit normally
        return true;
    });
    
    // Check SKU uniqueness
    $('input[name="sku"]').on('blur', function() {
        var sku = $(this).val();
        if (sku.length > 0) {
            $.ajax({
                url: '<?php echo e(route("products.search")); ?>',
                type: 'GET',
                data: { 
                    q: sku,
                    check_sku: true 
                },
                success: function(response) {
                    if (response.exists) {
                        // Show warning but don't prevent submission
                        Swal.fire({
                            icon: 'warning',
                            title: 'SKU Already Exists',
                            text: 'This SKU is already in use. Please choose a different SKU to avoid conflicts.',
                            confirmButtonColor: '#3085d6',
                        });
                        $('input[name="sku"]').addClass('is-invalid');
                        $('#skuFeedback').remove();
                        $('input[name="sku"]').after('<div class="invalid-feedback" id="skuFeedback">This SKU already exists in the system.</div>');
                    } else {
                        $('input[name="sku"]').removeClass('is-invalid');
                        $('#skuFeedback').remove();
                    }
                }
            });
        }
    });
    
    // Validate discount fields
    $('input[name="discount_price"], input[name="discount_percent"]').on('input', function() {
        var discountPrice = $('input[name="discount_price"]').val();
        var discountPercent = $('input[name="discount_percent"]').val();
        var salePrice = parseFloat($('#salePrice').val()) || 0;
        
        if (discountPrice && discountPercent) {
            Swal.fire({
                icon: 'warning',
                title: 'Discount Conflict',
                text: 'Please enter either discount price OR discount percentage, not both.',
                confirmButtonColor: '#3085d6',
            });
            $(this).val('');
        }
        
        // Validate discount price doesn't exceed sale price
        if (discountPrice && salePrice > 0 && parseFloat(discountPrice) > salePrice) {
            Swal.fire({
                icon: 'warning',
                title: 'Invalid Discount',
                text: 'Discount price cannot be higher than sale price.',
                confirmButtonColor: '#3085d6',
            });
            $('input[name="discount_price"]').val('');
        }
    });
    
    // Auto-calculate markup
    $('input[name="cost_price"], input[name="sale_price"]').on('input', function() {
        var cost = parseFloat($('#costPrice').val()) || 0;
        var sale = parseFloat($('#salePrice').val()) || 0;
        
        if (cost > 0 && sale > 0) {
            var markup = ((sale - cost) / cost) * 100;
            var profit = sale - cost;
            
            // Update tax preview
            updateTaxPreview();
        }
    });
    
    // Form validation for required fields
    $('input[required], select[required]').on('blur', function() {
        if (!$(this).val()) {
            $(this).addClass('is-invalid');
            if (!$(this).next('.invalid-feedback').length) {
                $(this).after('<div class="invalid-feedback">This field is required.</div>');
            }
        } else {
            $(this).removeClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
        }
    });

    // Tax Management Functions
    function manageTaxes() {
        window.location.href = '<?php echo e(route("taxes.index")); ?>';
    }
    
    // Tax status radio buttons handler
    $('input[name="tax_status"]').change(function() {
        const status = $(this).val();
        const taxContainer = $('#taxRateContainer');
        const taxSelect = $('#taxSelect');
        const hasVatField = $('#hasVatField');
        const taxIdField = $('#taxIdField');
        const zeroRatedTaxId = $('#zeroRatedTaxId').val();
        
        // Update UI based on selection
        if (status === 'vat') {
            taxContainer.show();
            hasVatField.val('1');
            // Keep selected tax ID if exists
            updateTaxPreview();
        } else if (status === 'zero') {
            taxContainer.hide();
            hasVatField.val('1');
            taxIdField.val(zeroRatedTaxId);
            updateTaxPreview(0); // 0% tax
        } else if (status === 'exempt') {
            taxContainer.hide();
            hasVatField.val('0');
            taxIdField.val('');
            updateTaxPreview(0, false);
        }
        
        // Update card border color
        const taxCard = $('.tax-status-card');
        taxCard.removeClass('tax-status-vat tax-status-zero tax-status-exempt');
        if (status === 'vat') {
            taxCard.addClass('tax-status-vat');
        } else if (status === 'zero') {
            taxCard.addClass('tax-status-zero');
        } else {
            taxCard.addClass('tax-status-exempt');
        }
    });
    
    // Tax rate selection handler
    $('#taxSelect').change(function() {
        const selectedOption = $(this).find('option:selected');
        const taxIdField = $('#taxIdField');
        taxIdField.val(selectedOption.val());
        
        // Show/hide selected tax info
        if (selectedOption.val()) {
            $('#selectedTaxInfo').show();
            $('#taxName').text(selectedOption.text().split('(')[0].trim());
            $('#taxRate').text(selectedOption.data('rate'));
        } else {
            $('#selectedTaxInfo').hide();
        }
        
        updateTaxPreview();
    });
    
    // Update tax preview
    function updateTaxPreview(customRate = null, hasVat = true) {
        const salePrice = parseFloat($('#salePrice').val()) || 0;
        const discountPrice = parseFloat($('#discountPrice').val()) || 0;
        const discountPercent = parseFloat($('#discountPercent').val()) || 0;
        
        // Calculate final price after discount
        let finalPrice = salePrice;
        if (discountPrice > 0) {
            finalPrice = discountPrice;
        } else if (discountPercent > 0) {
            finalPrice = salePrice * (1 - (discountPercent / 100));
        }
        
        let taxRate = 0;
        let statusText = '';
        
        const taxStatus = $('input[name="tax_status"]:checked').val();
        
        if (taxStatus === 'vat') {
            const selectedOption = $('#taxSelect').find('option:selected');
            taxRate = selectedOption.data('rate') || 0;
            statusText = `VAT Taxable (${taxRate}%)`;
        } else if (taxStatus === 'zero') {
            taxRate = 0;
            statusText = 'Zero-Rated VAT (0%)';
        } else if (taxStatus === 'exempt') {
            taxRate = 0;
            statusText = 'VAT Exempt (No VAT)';
        }
        
        // Use custom values if provided
        if (customRate !== null) taxRate = customRate;
        
        // Calculate tax amount
        let taxAmount = 0;
        if (hasVat && taxRate > 0) {
            taxAmount = finalPrice * (taxRate / 100);
        }
        
        const totalPrice = finalPrice + taxAmount;
        
        // Update displays
        $('#salePricePreview').text('KES ' + finalPrice.toFixed(2));
        $('#taxRatePreview').text(taxRate + '%');
        $('#taxAmountPreview').text('KES ' + taxAmount.toFixed(2));
        $('#totalPricePreview').text('KES ' + totalPrice.toFixed(2));
        $('#taxStatusText').text(statusText);
        
        // Update status color
        const statusPreview = $('#taxStatusPreview');
        statusPreview.removeClass('alert-warning alert-success alert-info');
        if (taxStatus === 'vat') {
            statusPreview.addClass('alert-warning');
        } else if (taxStatus === 'zero') {
            statusPreview.addClass('alert-success');
        } else {
            statusPreview.addClass('alert-info');
        }
    }
    
    // Update tax preview when price fields change
    $('#salePrice, #costPrice, #discountPrice, #discountPercent').on('input', function() {
        updateTaxPreview();
    });
    
    // Initialize tax preview
    updateTaxPreview();
    
    // Enable form submission button when all required fields are filled
    function checkFormValidity() {
        var isValid = true;
        $('input[required], select[required]').each(function() {
            if (!$(this).val()) {
                isValid = false;
                return false; // Break loop
            }
        });
        
        // Check sale price vs cost price
        var cost = parseFloat($('#costPrice').val()) || 0;
        var sale = parseFloat($('#salePrice').val()) || 0;
        if (sale < cost) {
            Swal.fire({
                icon: 'warning',
                title: 'Price Validation',
                text: 'Sale price cannot be less than cost price.',
                confirmButtonColor: '#3085d6',
            });
            isValid = false;
        }
        
        $('#submitBtn').prop('disabled', !isValid);
        return isValid;
    }
    
    // Check form validity on input change
    $('input, select').on('input change', function() {
        checkFormValidity();
    });
    
    // Initialize form validation
    checkFormValidity();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/products/create.blade.php ENDPATH**/ ?>