<template id="cardFormTemplate">
    <div class="payment-form card-form">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i>
            <strong>Card Payment:</strong> Enter card details for processing
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="cardNumber" class="form-label">Card Number *</label>
                <input type="text" class="form-control" id="cardNumber" 
                       placeholder="4242 4242 4242 4242" maxlength="19" required autofocus
                       inputmode="numeric" pattern="[0-9\s]{13,19}">
                <div class="form-text">16-digit card number</div>
            </div>
            <div class="col-md-3 mb-3">
                <label for="cardExpiry" class="form-label">Expiry Date *</label>
                <input type="text" class="form-control" id="cardExpiry" 
                       placeholder="MM/YY" maxlength="5" required
                       pattern="(0[1-9]|1[0-2])\/[0-9]{2}">
                <div class="form-text">MM/YY format</div>
            </div>
            <div class="col-md-3 mb-3">
                <label for="cardCvv" class="form-label">CVV *</label>
                <div class="input-group">
                    <input type="password" class="form-control" id="cardCvv" 
                           placeholder="123" maxlength="4" required
                           pattern="[0-9]{3,4}">
                    <button type="button" class="btn btn-outline-secondary" id="toggleCvvBtn">
                        <i class="bx bx-show"></i>
                    </button>
                </div>
                <div class="form-text">3-4 digit code</div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="cardHolder" class="form-label">Cardholder Name</label>
                <input type="text" class="form-control" id="cardHolder" 
                       placeholder="As shown on card">
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control" id="cardAmount" readonly>
                </div>
            </div>
        </div>
        
        <!-- Card Type Selection -->
        <div class="mb-3">
            <label class="form-label">Card Type</label>
            <div class="d-flex flex-wrap gap-3">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="cardType" id="cardVisa" value="visa" checked>
                    <label class="form-check-label" for="cardVisa">
                        <i class="bx bxl-visa me-1"></i>Visa
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="cardType" id="cardMastercard" value="mastercard">
                    <label class="form-check-label" for="cardMastercard">
                        <i class="bx bxl-mastercard me-1"></i>MasterCard
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="cardType" id="cardAmex" value="amex">
                    <label class="form-check-label" for="cardAmex">
                        <i class="bx bxl-american-express me-1"></i>American Express
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="cardType" id="cardOther" value="other">
                    <label class="form-check-label" for="cardOther">
                        <i class="bx bx-credit-card me-1"></i>Other
                    </label>
                </div>
            </div>
        </div>
        
        <!-- Additional Card Details -->
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="cardTransactionId" class="form-label">Transaction ID (Optional)</label>
                <input type="text" class="form-control" id="cardTransactionId" 
                       placeholder="From terminal">
            </div>
            <div class="col-md-6 mb-3">
                <label for="cardAuthCode" class="form-label">Auth Code (Optional)</label>
                    <input type="text" class="form-control" id="cardAuthCode" 
                           placeholder="Approval code">
            </div>
        </div>
        
        <div class="alert alert-warning">
            <i class="bx bx-shield me-2"></i>
            <strong>Security Note:</strong> We don't store full card numbers. Only last 4 digits are saved for reference.
        </div>
    </div>
</template><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/payment-forms/card.blade.php ENDPATH**/ ?>