

<?php $__env->startSection('title', 'User Details: ' . $user->name); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Start breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Users</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('users.index')); ?>">User Management</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($user->name); ?></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- End breadcrumb -->

        <div class="row">
            <!-- Left Column: User Info -->
            <div class="col-md-4">
                <div class="card radius-10">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <img src="<?php echo e($user->profile_image_url); ?>" 
                                 class="rounded-circle" width="150" height="150"
                                 onerror="this.src='<?php echo e(asset('assets/images/default-avatar.png')); ?>'">
                        </div>
                        <h4 class="mb-1"><?php echo e($user->name); ?></h4>
                        <p class="text-muted"><?php echo e($user->position ?? 'No position specified'); ?></p>
                        
                        <div class="d-flex justify-content-center gap-2 mb-3">
                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge bg-<?php echo e(\App\Helpers\RoleHelper::getColor($role->name)); ?>">
                                <i class="bx bx-<?php echo e(\App\Helpers\RoleHelper::getIcon($role->name)); ?>"></i>
                                <?php echo e(ucfirst($role->name)); ?>

                            </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="row mt-4">
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <h6 class="mb-0"><?php echo e($statistics['total_sales'] ?? 0); ?></h6>
                                    <small>Sales</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <h6 class="mb-0"><?php echo e($statistics['total_purchases'] ?? 0); ?></h6>
                                    <small>Purchases</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Info Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Contact Information</h6>
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-envelope me-2"></i>
                                <span><?php echo e($user->email); ?></span>
                            </div>
                            <?php if($user->phone): ?>
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-phone me-2"></i>
                                <span><?php echo e($user->phone); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($user->address): ?>
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-home me-2"></i>
                                <span><?php echo e($user->address); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- User Actions Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Actions</h6>
                        <div class="d-grid gap-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit users')): ?>
                            <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-primary">
                                <i class="bx bx-edit"></i> Edit User
                            </a>
                            <?php endif; ?>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete users')): ?>
                                <?php if($user->id != auth()->id()): ?>
                                <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" 
                                      onsubmit="return confirm('Are you sure you want to delete this user?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="bx bx-trash"></i> Delete User
                                    </button>
                                </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: User Details -->
            <div class="col-md-8">
                <!-- User Details Card -->
                <div class="card radius-10">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">User Details</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Employee ID</label>
                                <p class="form-control-plaintext"><?php echo e($user->employee_id ?? 'Not assigned'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status</label>
                                <p>
                                    <span class="badge bg-<?php echo e($user->is_active ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Department</label>
                                <p class="form-control-plaintext"><?php echo e($user->department ?? 'Not assigned'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Position</label>
                                <p class="form-control-plaintext"><?php echo e($user->position ?? 'Not assigned'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Gender</label>
                                <p class="form-control-plaintext"><?php echo e(ucfirst($user->gender) ?? 'Not specified'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Date of Birth</label>
                                <p class="form-control-plaintext"><?php echo e($user->date_of_birth ? $user->date_of_birth->format('M d, Y') : 'Not specified'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Hire Date</label>
                                <p class="form-control-plaintext"><?php echo e($user->hire_date ? $user->hire_date->format('M d, Y') : 'Not specified'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Last Login</label>
                                <p class="form-control-plaintext">
                                    <?php if($user->last_login_at): ?>
                                        <?php echo e($user->last_login_at->format('M d, Y h:i A')); ?>

                                        <?php if($user->last_login_ip): ?>
                                            <br><small class="text-muted">IP: <?php echo e($user->last_login_ip); ?></small>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        Never logged in
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label">Notes</label>
                                <p class="form-control-plaintext"><?php echo e($user->notes ?? 'No notes'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Permissions Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Permissions</h6>
                        <div class="row">
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-2">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" checked disabled>
                                    <label class="form-check-label"><?php echo e(ucwords(str_replace(['-', '_'], ' ', $permission->name))); ?></label>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/users/show.blade.php ENDPATH**/ ?>