<template id="creditFormTemplate">
    <div class="payment-form credit-form">
        <div class="alert alert-warning">
            <i class="bx bx-error-circle me-2"></i>
            <strong>Credit Sale:</strong> This sale will be recorded as credit (pay later)
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="creditCustomerSelect" class="form-label">Customer *</label>
                <select class="form-select" id="creditCustomerSelect" required>
                    <option value="">Select Customer</option>
                    <!-- Will be populated dynamically -->
                </select>
                <div class="form-text">Customer must have credit terms enabled</div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="creditTerms" class="form-label">Credit Terms *</label>
                <select class="form-select" id="creditTerms" required>
                    <option value="7">7 Days</option>
                    <option value="15">15 Days</option>
                    <option value="30" selected>30 Days</option>
                    <option value="45">45 Days</option>
                    <option value="60">60 Days</option>
                    <option value="90">90 Days</option>
                </select>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="creditDueDate" class="form-label">Due Date</label>
                <input type="date" class="form-control" id="creditDueDate" readonly>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">Amount Due</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control fw-bold" id="creditAmount" readonly>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="creditLimit" class="form-label">Available Credit</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control" id="creditLimit" readonly>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="creditBalance" class="form-label">Current Balance</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control" id="creditBalance" readonly>
                </div>
            </div>
        </div>
        
        <div class="mb-3">
            <label for="creditNotes" class="form-label">Notes & Terms *</label>
            <textarea class="form-control" id="creditNotes" rows="3" 
                      placeholder="Add payment terms, special instructions..." required></textarea>
        </div>
        
        <div class="mb-3">
            <label class="form-label">Credit Documentation</label>
            <div class="form-check mb-2">
                <input class="form-check-input" type="checkbox" id="creditSignedAgreement" required>
                <label class="form-check-label" for="creditSignedAgreement">
                    Customer has signed credit agreement
                </label>
            </div>
            <div class="form-check mb-2">
                <input class="form-check-input" type="checkbox" id="creditValidID">
                <label class="form-check-label" for="creditValidID">
                    Valid ID checked & verified
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="creditSendReminder" checked>
                <label class="form-check-label" for="creditSendReminder">
                    Send payment reminder 3 days before due date
                </label>
            </div>
        </div>
        
        <div class="alert alert-danger">
            <i class="bx bx-error-circle me-2"></i>
            <strong>Important:</strong> Credit sales require manager approval. Ensure proper documentation is maintained.
        </div>
    </div>
</template><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/payment-forms/credit.blade.php ENDPATH**/ ?>