

<?php $__env->startSection('style'); ?>
    <style>
        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-active {
            background-color: #d1fae5;
            color: #065f46;
        }
        .status-inactive {
            background-color: #fef3c7;
            color: #92400e;
        }
        .status-discontinued {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .stock-badge {
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
        }
        .stock-in_stock {
            background-color: #d1fae5;
            color: #065f46;
        }
        .stock-low_stock {
            background-color: #fef3c7;
            color: #92400e;
        }
        .stock-out_of_stock {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 6px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-2px);
        }
        .product-image {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 8px;
            border: 1px solid #e5e7eb;
        }
        .filter-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border-left: 4px solid #667eea;
        }
        .card-hover:hover {
            transform: translateY(-2px);
            transition: transform 0.2s;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .pagination-info {
            font-size: 14px;
            color: #6c757d;
        }
        .batch-indicator {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 5px;
        }
        .batch-active {
            background-color: #10b981;
        }
        .batch-expired {
            background-color: #ef4444;
        }
        .expiry-badge {
            padding: 3px 8px;
            border-radius: 20px;
            font-size: 10px;
            font-weight: 600;
        }
        .expiry-normal {
            background-color: #d1fae5;
            color: #065f46;
        }
        .expiry-warning {
            background-color: #fef3c7;
            color: #92400e;
        }
        .expiry-critical {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .featured-badge {
            background-color: #fef3c7;
            color: #92400e;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
        }
        .expiry-tracking-badge {
            background-color: #dbeafe;
            color: #1e40af;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
        }
        .batch-tracking-badge {
            background-color: #f3e8ff;
            color: #6b21a8;
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 10px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Products</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">All Products</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                        <i class="bx bx-plus"></i> Add New Product
                    </a>
                    <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.import')); ?>">
                                <i class="bx bx-import"></i> Import Products
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.export')); ?>">
                                <i class="bx bx-export"></i> Export Products
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.expiry-report')); ?>">
                                <i class="bx bx-calendar-exclamation"></i> Expiry Report
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.statistics')); ?>">
                                <i class="bx bx-bar-chart-alt"></i> Product Analytics
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.pricing.index')); ?>">
                                <i class="bx bx-dollar-circle"></i> Pricing Management
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Filters Section -->
        <div class="filter-section">
            <form method="GET" action="<?php echo e(route('products.index')); ?>" id="filterForm">
                <div class="row g-3">
                    <!-- Search Input -->
                    <div class="col-md-3">
                        <label class="form-label">Search</label>
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Name, SKU, Barcode, Ref #" 
                                   value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-outline-secondary" type="submit">
                                <i class="bx bx-search"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Category Filter -->
                    <div class="col-md-2">
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-select">
                            <option value="">All Categories</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" 
                                        <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Status Filter -->
                    <div class="col-md-2">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="">All Status</option>
                            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>
                                Active
                            </option>
                            <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>
                                Inactive
                            </option>
                            <option value="discontinued" <?php echo e(request('status') == 'discontinued' ? 'selected' : ''); ?>>
                                Discontinued
                            </option>
                        </select>
                    </div>

                    <!-- Stock Status Filter -->
                    <div class="col-md-2">
                        <label class="form-label">Stock Status</label>
                        <select name="stock_status" class="form-select">
                            <option value="">All Stock</option>
                            <option value="in_stock" <?php echo e(request('stock_status') == 'in_stock' ? 'selected' : ''); ?>>
                                In Stock
                            </option>
                            <option value="low_stock" <?php echo e(request('stock_status') == 'low_stock' ? 'selected' : ''); ?>>
                                Low Stock
                            </option>
                            <option value="out_of_stock" <?php echo e(request('stock_status') == 'out_of_stock' ? 'selected' : ''); ?>>
                                Out of Stock
                            </option>
                        </select>
                    </div>

                    <!-- Expiry Filter -->
                    <div class="col-md-2">
                        <label class="form-label">Expiry Tracking</label>
                        <select name="has_expiry" class="form-select">
                            <option value="">All Products</option>
                            <option value="1" <?php echo e(request('has_expiry') == '1' ? 'selected' : ''); ?>>
                                With Expiry
                            </option>
                            <option value="0" <?php echo e(request('has_expiry') == '0' ? 'selected' : ''); ?>>
                                Without Expiry
                            </option>
                        </select>
                    </div>

                    <!-- Actions Column -->
                    <div class="col-md-1 d-flex align-items-end">
                        <div class="d-flex gap-2 w-100">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="bx bx-filter"></i>
                            </button>
                            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bx bx-reset"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Advanced Filters (Collapsible) -->
                <div class="row mt-3">
                    <div class="col-12">
                        <a class="btn btn-link text-decoration-none" data-bs-toggle="collapse" href="#advancedFilters" role="button">
                            <i class="bx bx-chevron-down"></i> Advanced Filters
                        </a>
                        <div class="collapse mt-2" id="advancedFilters">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label">Brand</label>
                                    <select name="brand_id" class="form-select">
                                        <option value="">All Brands</option>
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($brand->id); ?>" 
                                                    <?php echo e(request('brand_id') == $brand->id ? 'selected' : ''); ?>>
                                                <?php echo e($brand->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Supplier</label>
                                        <select name="supplier_id" class="form-select">
                                            <option value="">All Suppliers</option>
                                            <?php if(isset($suppliers)): ?>
                                                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($supplier->id); ?>"
                                                            <?php echo e(request('supplier_id') == $supplier->id ? 'selected' : ''); ?>>
                                                        <?php echo e($supplier->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                <div class="col-md-3">
                                    <label class="form-label">Sort By</label>
                                    <select name="sort_by" class="form-select">
                                        <option value="name" <?php echo e(request('sort_by') == 'name' ? 'selected' : ''); ?>>Name</option>
                                        <option value="sku" <?php echo e(request('sort_by') == 'sku' ? 'selected' : ''); ?>>SKU</option>
                                        <option value="stock" <?php echo e(request('sort_by') == 'stock' ? 'selected' : ''); ?>>Stock</option>
                                        <option value="sale_price" <?php echo e(request('sort_by') == 'sale_price' ? 'selected' : ''); ?>>Price</option>
                                        <option value="created_at" <?php echo e(request('sort_by') == 'created_at' ? 'selected' : ''); ?>>Created Date</option>
                                        <option value="updated_at" <?php echo e(request('sort_by') == 'updated_at' ? 'selected' : ''); ?>>Updated Date</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Sort Order</label>
                                    <select name="sort_order" class="form-select">
                                        <option value="asc" <?php echo e(request('sort_order') == 'asc' ? 'selected' : ''); ?>>Ascending</option>
                                        <option value="desc" <?php echo e(request('sort_order') == 'desc' ? 'selected' : ''); ?>>Descending</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="card radius-10 card-hover">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Products</p>
                                <h4 class="my-1"><?php echo e($products->total()); ?></h4>
                            </div>
                            <div class="widgets-icons bg-light-primary text-primary ms-auto">
                                <i class="bx bx-package"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 card-hover">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active Products</p>
                                <h4 class="my-1">
                                    <?php echo e($products->where('status', 'active')->count()); ?>

                                </h4>
                            </div>
                            <div class="widgets-icons bg-light-success text-success ms-auto">
                                <i class="bx bx-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 card-hover">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Low Stock</p>
                                <h4 class="my-1">
                                    <?php echo e($products->where('stock', '<=', \DB::raw('minimum_stock'))->where('stock', '>', 0)->count()); ?>

                                </h4>
                            </div>
                            <div class="widgets-icons bg-light-warning text-warning ms-auto">
                                <i class="bx bx-error"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 card-hover">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Out of Stock</p>
                                <h4 class="my-1">
                                    <?php echo e($products->where('stock', '<=', 0)->count()); ?>

                                </h4>
                            </div>
                            <div class="widgets-icons bg-light-danger text-danger ms-auto">
                                <i class="bx bx-x-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Table -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="card-title mb-0">Product List</h5>
                    <div class="d-flex gap-2">
                        <!-- Bulk Actions -->
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bx bx-cog"></i> Bulk Actions
                            </button>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="#" onclick="bulkAction('status', 'active')">
                                        <i class="bx bx-check-circle"></i> Set as Active
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" onclick="bulkAction('status', 'inactive')">
                                        <i class="bx bx-x-circle"></i> Set as Inactive
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" onclick="bulkAction('status', 'discontinued')">
                                        <i class="bx bx-trash"></i> Set as Discontinued
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <a class="dropdown-item text-danger" href="#" onclick="confirmBulkDelete()">
                                        <i class="bx bx-trash"></i> Delete Selected
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <!-- View Toggle -->
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-outline-secondary active" id="listViewBtn">
                                <i class="bx bx-list-ul"></i>
                            </button>
                            <button type="button" class="btn btn-outline-secondary" id="gridViewBtn">
                                <i class="bx bx-grid"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bx bx-check-circle"></i> <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bx bx-error-circle"></i> <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <!-- Table View -->
                <div id="tableView">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 40px;">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th>Product</th>
                                    <th>SKU/Barcode</th>
                                    <th>Category</th>
                                    <th class="text-center">Stock</th>
                                    <th class="text-end">Price</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-end">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="card-hover">
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input product-check" type="checkbox" 
                                                       value="<?php echo e($product->id); ?>" name="selected_products[]">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="flex-shrink-0">
                                                    <?php if($product->image): ?>
                                                        <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                                                             alt="<?php echo e($product->name); ?>" 
                                                             class="product-image">
                                                    <?php else: ?>
                                                        <div class="product-image bg-light d-flex align-items-center justify-content-center">
                                                            <i class="bx bx-package text-muted"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6 class="mb-0">
                                                        <a href="<?php echo e(route('products.show', $product)); ?>" 
                                                           class="text-dark">
                                                            <?php echo e($product->name); ?>

                                                        </a>
                                                    </h6>
                                                    <small class="text-muted">
                                                        <?php echo e(Str::limit($product->short_description, 40)); ?>

                                                    </small>
                                                    <div class="mt-1">
                                                        <?php if($product->is_featured): ?>
                                                            <span class="featured-badge">
                                                                <i class="bx bx-star"></i> Featured
                                                            </span>
                                                        <?php endif; ?>
                                                        <?php if($product->has_expiry): ?>
                                                            <span class="expiry-tracking-badge">
                                                                <i class="bx bx-calendar"></i> Expiry
                                                            </span>
                                                        <?php endif; ?>
                                                        <?php if($product->track_batches): ?>
                                                            <span class="batch-tracking-badge">
                                                                <i class="bx bx-layer"></i> Batches
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column">
                                                <strong><?php echo e($product->sku); ?></strong>
                                                <?php if($product->barcode): ?>
                                                    <small class="text-muted"><?php echo e($product->barcode); ?></small>
                                                <?php endif; ?>
                                                <?php if($product->ref_number): ?>
                                                    <small class="text-muted">Ref: <?php echo e($product->ref_number); ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($product->category): ?>
                                                <span class="badge bg-light text-dark">
                                                    <?php echo e($product->category->name); ?>

                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                            <?php if($product->brand): ?>
                                                <div class="mt-1">
                                                    <small class="text-muted"><?php echo e($product->brand->name); ?></small>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <div class="d-flex flex-column align-items-center">
                                                <span class="fw-bold"><?php echo e($product->stock); ?></span>
                                                <span class="stock-badge stock-<?php echo e($product->stock_status); ?>">
                                                    <?php echo e(Str::title(str_replace('_', ' ', $product->stock_status))); ?>

                                                </span>
                                                <?php if($product->has_expiry && $product->expiry_summary['has_expiry']): ?>
                                                    <?php
                                                        $expirySummary = $product->expiry_summary;
                                                    ?>
                                                    <?php if($expirySummary['alert_level'] != 'normal'): ?>
                                                        <div class="mt-1">
                                                            <span class="expiry-badge expiry-<?php echo e($expirySummary['alert_level']); ?>">
                                                                <?php if($expirySummary['expired_quantity'] > 0): ?>
                                                                    <i class="bx bx-error-circle"></i> <?php echo e($expirySummary['expired_quantity']); ?> expired
                                                                <?php elseif($expirySummary['expiring_soon_quantity'] > 0): ?>
                                                                    <i class="bx bx-time"></i> <?php echo e($expirySummary['expiring_soon_quantity']); ?> expiring
                                                                <?php endif; ?>
                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <div class="d-flex flex-column">
                                                <strong class="text-success">
                                                    KES<?php echo e(number_format($product->final_price, 2)); ?>

                                                </strong>
                                                <?php if($product->discount_price || $product->discount_percent): ?>
                                                    <small class="text-muted">
                                                        <s>KES<?php echo e(number_format($product->sale_price, 2)); ?></s>
                                                    </small>
                                                <?php endif; ?>
                                                <small class="text-muted">
                                                    Cost: KES<?php echo e(number_format($product->cost_price, 2)); ?>

                                                </small>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="status-badge status-<?php echo e($product->status); ?>">
                                                <?php echo e(Str::title($product->status)); ?>

                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <div class="d-flex justify-content-end gap-1">
                                                <!-- View Button -->
                                                <a href="<?php echo e(route('products.show', $product)); ?>" 
                                                   class="action-btn btn btn-outline-info btn-sm"
                                                   data-bs-toggle="tooltip" title="View Details">
                                                    <i class="bx bx-show"></i>
                                                </a>
                                                
                                                <!-- Edit Button -->
                                                <a href="<?php echo e(route('products.edit', $product)); ?>" 
                                                   class="action-btn btn btn-outline-primary btn-sm"
                                                   data-bs-toggle="tooltip" title="Edit">
                                                    <i class="bx bx-edit"></i>
                                                </a>
                                                
                                                <!-- Quick Actions Dropdown -->
                                                <div class="dropdown">
                                                    <button class="action-btn btn btn-outline-secondary btn-sm" 
                                                            type="button" data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('products.add-stock', $product)); ?>">
                                                                <i class="bx bx-plus"></i> Add Stock
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('products.remove-stock', $product)); ?>">
                                                                <i class="bx bx-minus"></i> Remove Stock
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('products.price-history', $product)); ?>">
                                                                <i class="bx bx-history"></i> Price History
                                                            </a>
                                                        </li>
                                                        <?php if($product->track_batches): ?>
                                                            <li>
                                                                <a class="dropdown-item" href="<?php echo e(route('products.batches', $product)); ?>">
                                                                    <i class="bx bx-layer"></i> View Batches
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <li><hr class="dropdown-divider"></li>
                                                        <li>
                                                            <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="d-inline">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('DELETE'); ?>
                                                                <button type="submit" class="dropdown-item text-danger" 
                                                                        onclick="return confirm('Are you sure you want to delete this product?')">
                                                                    <i class="bx bx-trash"></i> Delete
                                                                </button>
                                                            </form>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center py-5">
                                            <div class="py-5">
                                                <i class="bx bx-package display-4 text-muted mb-3"></i>
                                                <h5 class="text-muted">No products found</h5>
                                                <p class="text-muted mb-4">
                                                    <?php if(request()->hasAny(['search', 'category_id', 'status', 'stock_status', 'has_expiry'])): ?>
                                                        Try changing your filters
                                                    <?php else: ?>
                                                        Get started by creating your first product
                                                    <?php endif; ?>
                                                </p>
                                                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                                                    <i class="bx bx-plus"></i> Add New Product
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Grid View (Hidden by default) -->
                <div id="gridView" class="d-none">
                    <div class="row g-3">
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                                <div class="card card-hover">
                                    <div class="card-body">
                                        <!-- Product Image -->
                                        <div class="text-center mb-3">
                                            <?php if($product->image): ?>
                                                <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                                                     alt="<?php echo e($product->name); ?>" 
                                                     class="product-image" style="width: 100px; height: 100px;">
                                            <?php else: ?>
                                                <div class="product-image mx-auto d-flex align-items-center justify-content-center"
                                                     style="width: 100px; height: 100px;">
                                                    <i class="bx bx-package display-4 text-muted"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Product Info -->
                                        <h6 class="card-title mb-1">
                                            <a href="<?php echo e(route('products.show', $product)); ?>" class="text-dark">
                                                <?php echo e(Str::limit($product->name, 30)); ?>

                                            </a>
                                        </h6>
                                        <p class="text-muted small mb-2"><?php echo e($product->sku); ?></p>
                                        
                                        <!-- Badges -->
                                        <div class="d-flex flex-wrap gap-1 mb-2">
                                            <span class="status-badge status-<?php echo e($product->status); ?>">
                                                <?php echo e(Str::title($product->status)); ?>

                                            </span>
                                            <span class="stock-badge stock-<?php echo e($product->stock_status); ?>">
                                                <?php echo e($product->stock); ?>

                                            </span>
                                            <?php if($product->is_featured): ?>
                                                <span class="featured-badge">
                                                    <i class="bx bx-star"></i>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Price -->
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <strong class="text-success">
                                                    $<?php echo e(number_format($product->final_price, 2)); ?>

                                                </strong>
                                                <?php if($product->discount_price || $product->discount_percent): ?>
                                                    <div>
                                                        <small class="text-muted">
                                                            <s>$<?php echo e(number_format($product->sale_price, 2)); ?></s>
                                                        </small>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <?php if($product->category): ?>
                                                <span class="badge bg-light text-dark">
                                                    <?php echo e(Str::limit($product->category->name, 15)); ?>

                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- Actions -->
                                        <div class="d-flex justify-content-between">
                                            <a href="<?php echo e(route('products.show', $product)); ?>" 
                                               class="btn btn-sm btn-outline-info">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            <a href="<?php echo e(route('products.edit', $product)); ?>" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="bx bx-edit"></i>
                                            </a>
                                            <a href="<?php echo e(route('products.add-stock', $product)); ?>" 
                                               class="btn btn-sm btn-outline-success">
                                                <i class="bx bx-plus"></i>
                                            </a>
                                            <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                        onclick="return confirm('Are you sure?')">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-12 text-center py-5">
                                <i class="bx bx-package display-4 text-muted mb-3"></i>
                                <h5 class="text-muted">No products found</h5>
                                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                                    <i class="bx bx-plus"></i> Add New Product
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="pagination-info">
                        Showing <?php echo e($products->firstItem()); ?> to <?php echo e($products->lastItem()); ?> of <?php echo e($products->total()); ?> entries
                    </div>
                    <nav>
                        <?php echo e($products->withQueryString()->links()); ?>

                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        // Tooltip initialization
        $('[data-bs-toggle="tooltip"]').tooltip();

        // Select All checkbox
        $('#selectAll').change(function() {
            $('.product-check').prop('checked', this.checked);
        });

        // View toggle
        $('#listViewBtn').click(function() {
            $(this).addClass('active');
            $('#gridViewBtn').removeClass('active');
            $('#tableView').removeClass('d-none');
            $('#gridView').addClass('d-none');
        });

        $('#gridViewBtn').click(function() {
            $(this).addClass('active');
            $('#listViewBtn').removeClass('active');
            $('#gridView').removeClass('d-none');
            $('#tableView').addClass('d-none');
        });

        // Auto-submit filters on change
        $('select[name="category_id"], select[name="status"], select[name="stock_status"], select[name="has_expiry"], select[name="brand_id"], select[name="supplier_id"], select[name="sort_by"], select[name="sort_order"]').change(function() {
            $('#filterForm').submit();
        });

        // Bulk actions
        window.bulkAction = function(action, value) {
            const selectedProducts = [];
            $('.product-check:checked').each(function() {
                selectedProducts.push($(this).val());
            });

            if (selectedProducts.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'No products selected',
                    text: 'Please select at least one product to perform this action.',
                });
                return;
            }

            Swal.fire({
                title: 'Confirm Action',
                text: `Are you sure you want to update ${selectedProducts.length} product(s)?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, update them'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(route("products.bulk-update")); ?>',
                        type: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            product_ids: selectedProducts,
                            data: { [action]: value }
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'Failed to update products'
                            });
                        }
                    });
                }
            });
        };

        // Bulk delete
        window.confirmBulkDelete = function() {
            const selectedProducts = [];
            $('.product-check:checked').each(function() {
                selectedProducts.push($(this).val());
            });

            if (selectedProducts.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'No products selected',
                    text: 'Please select at least one product to delete.',
                });
                return;
            }

            Swal.fire({
                title: 'Confirm Delete',
                text: `Are you sure you want to delete ${selectedProducts.length} product(s)? This action cannot be undone.`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete them'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(route("products.bulk-delete")); ?>',
                        type: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            product_ids: selectedProducts
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'Failed to delete products'
                            });
                        }
                    });
                }
            });
        };

        // Keyboard shortcuts
        $(document).keydown(function(e) {
            // Ctrl/Cmd + F for search focus
            if ((e.ctrlKey || e.metaKey) && e.key === 'f') {
                e.preventDefault();
                $('input[name="search"]').focus();
            }
            
            // Ctrl/Cmd + N for new product
            if ((e.ctrlKey || e.metaKey) && e.key === 'n') {
                e.preventDefault();
                window.location.href = '<?php echo e(route("products.create")); ?>';
            }
            
            // Escape to clear search
            if (e.key === 'Escape') {
                $('input[name="search"]').val('');
                $('#filterForm').submit();
            }
        });

        // Search input debounce
        let searchTimer;
        $('input[name="search"]').on('keyup', function() {
            clearTimeout(searchTimer);
            searchTimer = setTimeout(() => {
                if ($(this).val().length >= 2 || $(this).val().length === 0) {
                    $('#filterForm').submit();
                }
            }, 500);
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/products/index.blade.php ENDPATH**/ ?>