<div class="product-grid-wrapper h-100">
    <!-- Search and Filter Bar -->
    <div class="product-toolbar mb-3">
        <div class="row g-2">
            <div class="col-md-6">
                <div class="input-group">
                    <span class="input-group-text bg-light border-end-0">
                        <i class="bx bx-search"></i>
                    </span>
                    <input type="text" class="form-control border-start-0" 
                           id="productSearch" placeholder="Type to search or scan barcode..."
                           autofocus>
                    <button class="btn btn-light border" type="button" onclick="openBarcodeScanner()">
                        <i class="bx bx-barcode"></i>
                    </button>
                </div>
            </div>

            <div class="col-md-3">
                <select class="form-select" id="categoryFilter">
                    <option value="all">All Categories</option>
                    <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <div class="btn-group w-100">
                    <button class="btn btn-outline-secondary" onclick="toggleViewMode()">
                        <i class="bx bx-grid" id="viewModeIcon"></i>
                        <span id="viewModeText">Grid View</span>
                    </button>
                    <button class="btn btn-outline-secondary" onclick="toggleStockFilter()">
                        <i class="bx bx-filter"></i> In Stock
                    </button>
                    <button class="btn btn-outline-secondary" onclick="showLowStock()">
                        <i class="bx bx-alarm"></i> Low Stock
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- View Mode Tabs -->
    <div class="view-mode-tabs mb-3">
        <ul class="nav nav-pills" id="viewModeTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="grid-tab" data-bs-toggle="pill" data-bs-target="#grid-view" type="button" role="tab">
                    <i class="bx bx-grid-alt"></i> Grid View
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="list-tab" data-bs-toggle="pill" data-bs-target="#list-view" type="button" role="tab">
                    <i class="bx bx-list-ul"></i> List View
                </button>
            </li>
        </ul>
    </div>
    
    <!-- Product Grid/Table Container -->
    <div class="product-container" style="height: calc(100% - 160px); overflow-y: auto;">
        <div class="tab-content" id="productViewContent">
            <!-- Grid View -->
            <div class="tab-pane fade show active" id="grid-view" role="tabpanel">
                <div class="product-grid" id="productGrid">
                    <!-- Products will be loaded dynamically -->
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading products...</span>
                        </div>
                        <p class="mt-2 text-muted">Loading products...</p>
                    </div>
                </div>
            </div>
            
            <!-- List/Table View -->
            <div class="tab-pane fade" id="list-view" role="tabpanel">
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="table-light">
                            <tr>
                                <th width="60px">Image</th>
                                <th>Product</th>
                                <th>SKU</th>
                                <th>Barcode</th>
                                <th>Price</th>
                                <th>Stock</th>
                                <th>VAT</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="productTable">
                            <!-- Products will be loaded dynamically -->
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading products...</span>
                                    </div>
                                    <p class="mt-2 text-muted">Loading products...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Product Card Template (Hidden) -->
<template id="productCardTemplate">
    <div class="product-card">
        <div class="product-card-inner">
            <div class="product-image">
                <div class="image-placeholder">
                    <i class="bx bx-package"></i>
                </div>
                <div class="product-badges">
                    <span class="badge bg-success" data-badge-type="stock"></span>
                    <span class="badge bg-info d-none" data-badge-type="vat">VAT</span>
                    <span class="badge bg-warning d-none" data-badge-type="low-stock">Low Stock</span>
                </div>
            </div>
            <div class="product-info">
                <div class="product-name" data-field="name"></div>
                <div class="product-meta">
                    <span class="sku" data-field="sku"></span>
                    <span class="barcode" data-field="barcode"></span>
                </div>
                <div class="product-pricing">
                    <div class="price" data-field="price"></div>
                    <div class="cost text-muted small" data-field="cost"></div>
                </div>
                <div class="product-stock" data-field="stock"></div>
                <div class="product-actions">
                    <button class="btn btn-sm btn-outline-primary add-to-cart-btn">
                        <i class="bx bx-plus"></i> Add
                    </button>
                    <div class="btn-group btn-group-sm">
                        <button class="btn btn-outline-secondary view-details-btn">
                            <i class="bx bx-info-circle"></i>
                        </button>
                        <button class="btn btn-outline-secondary add-to-favorites-btn">
                            <i class="bx bx-star"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>

<!-- Product Row Template (Hidden) -->
<template id="productRowTemplate">
    <tr class="product-row">
        <td>
            <div class="product-image-small">
                <i class="bx bx-package"></i>
            </div>
        </td>
        <td>
            <div class="product-name" data-field="name"></div>
        </td>
        <td>
            <div class="product-sku" data-field="sku"></div>
        </td>
        <td>
            <div class="product-barcode" data-field="barcode"></div>
        </td>
        <td>
            <div class="product-price" data-field="price"></div>
        </td>
        <td>
            <div class="product-stock">
                <span class="stock-badge" data-badge-type="stock"></span>
                <span class="stock-quantity" data-field="stock"></span>
            </div>
        </td>
        <td>
            <span class="badge bg-info bg-opacity-10 text-info vat-badge d-none">VAT</span>
        </td>
        <td>
            <div class="btn-group btn-group-sm">
                <button class="btn btn-outline-primary add-to-cart-table-btn">
                    <i class="bx bx-plus"></i> Add
                </button>
                <button class="btn btn-outline-secondary view-details-table-btn">
                    <i class="bx bx-info-circle"></i>
                </button>
            </div>
        </td>
    </tr>
</template>

<style>
    /* Product Grid Styles */
    .product-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 15px;
        padding: 5px;
    }
    
    .product-card {
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        padding: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        background: #fff;
        position: relative;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }
    
    .product-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
        border-color: #2a4365;
    }
    
    .product-card-inner {
        display: flex;
        gap: 12px;
        height: 100%;
    }
    
    .product-image {
        flex-shrink: 0;
        width: 80px;
        height: 80px;
        position: relative;
    }
    
    .image-placeholder {
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: #94a3b8;
    }
    
    .product-badges {
        position: absolute;
        top: 5px;
        right: 5px;
        display: flex;
        flex-direction: column;
        gap: 3px;
    }
    
    .product-badges .badge {
        font-size: 9px;
        padding: 2px 5px;
    }
    
    .product-info {
        flex: 1;
        display: flex;
        flex-direction: column;
    }
    
    .product-name {
        font-weight: 600;
        font-size: 14px;
        color: #1e293b;
        margin-bottom: 5px;
        line-height: 1.3;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    
    .product-meta {
        font-size: 11px;
        color: #64748b;
        margin-bottom: 8px;
        display: flex;
        flex-direction: column;
        gap: 2px;
    }
    
    .product-pricing {
        margin-bottom: 8px;
    }
    
    .product-pricing .price {
        color: #2a4365;
        font-weight: 700;
        font-size: 16px;
    }
    
    .product-pricing .cost {
        font-size: 11px;
    }
    
    .product-stock {
        font-size: 11px;
        background: #f1f5f9;
        padding: 2px 8px;
        border-radius: 10px;
        display: inline-block;
        align-self: flex-start;
        color: #475569;
        margin-bottom: 8px;
    }
    
    .product-actions {
        display: flex;
        justify-content: space-between;
        margin-top: auto;
    }
    
    .product-actions .btn-group {
        flex-shrink: 0;
    }
    
    /* Table View Styles */
    .product-row {
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .product-row:hover {
        background-color: #f8fafc;
    }
    
    .product-image-small {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        color: #94a3b8;
    }
    
    .stock-badge {
        font-size: 10px;
        padding: 2px 6px;
        border-radius: 4px;
        margin-right: 5px;
    }
    
    .vat-badge {
        font-size: 10px;
        padding: 2px 6px;
    }
    
    /* View Mode Tabs */
    .view-mode-tabs .nav-pills {
        border-bottom: 1px solid #e2e8f0;
        padding-bottom: 5px;
    }
    
    .view-mode-tabs .nav-link {
        padding: 6px 15px;
        font-size: 13px;
        color: #64748b;
        border-radius: 6px;
    }
    
    .view-mode-tabs .nav-link.active {
        background-color: #2a4365;
        color: white;
    }
    
    /* Add to cart animation */
    .product-card.added-to-cart {
        animation: cartPulse 0.5s ease;
        border-color: #2a4365;
    }
    
    @keyframes  cartPulse {
        0% { transform: scale(1); }
        50% { transform: scale(0.95); }
        100% { transform: scale(1); }
    }
    
    .out-of-stock {
        opacity: 0.6;
        cursor: not-allowed;
    }
    
    .out-of-stock:hover {
        transform: none !important;
        box-shadow: none !important;
    }
    
    @media (max-width: 768px) {
        .product-grid {
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        }
        
        .product-card-inner {
            flex-direction: column;
            text-align: center;
        }
        
        .product-image {
            width: 100%;
            height: 100px;
        }
        
        .table-responsive {
            font-size: 13px;
        }
    }
</style>

<script>
// Product Grid JavaScript
(function() {
    'use strict';
    
    // Global variables for product grid
    window.productGridState = {
        currentViewMode: 'grid',
        allProducts: [],
        filteredProducts: [],
        currentCategory: 'all'
    };
    
    // Initialize when DOM is loaded
    document.addEventListener('DOMContentLoaded', function() {
        initProductGrid();
    });
    
    function initProductGrid() {
        console.log('Initializing Product Grid...');
        
        // Load initial products
        loadAllProducts();
        
        // Setup event listeners
        setupProductGridEventListeners();
        
        // Setup view mode tabs
        setupViewModeTabs();
        
        // Setup category filter
        setupCategoryFilter();
        
        // Setup search
        setupSearch();
    }
    
    function loadAllProducts(categoryId = null) {
        showLoading(true);
        
        let url = '/api/products';
        if (categoryId && categoryId !== 'all') {
            url += `?category_id=${categoryId}`;
        }
        
        fetch(url)
            .then(response => response.json())
            .then(data => {
                showLoading(false);
                
                if (data.success) {
                    window.productGridState.allProducts = data.products;
                    window.productGridState.filteredProducts = [...data.products];
                    renderProducts(window.productGridState.filteredProducts);
                } else {
                    console.error('Failed to load products:', data.error);
                    showProductError();
                }
            })
            .catch(error => {
                showLoading(false);
                console.error('Error loading products:', error);
                showProductError();
            });
    }
    
    function renderProducts(products) {
        console.log('Rendering', products.length, 'products');
        
        if (window.productGridState.currentViewMode === 'grid') {
            renderProductGrid(products);
        } else {
            renderProductTable(products);
        }
    }
    
    function renderProductGrid(products) {
        const grid = document.getElementById('productGrid');
        if (!grid) return;
        
        if (!products || products.length === 0) {
            grid.innerHTML = `
                <div class="col-12 text-center py-5">
                    <i class="bx bx-package bx-lg text-muted mb-3"></i>
                    <p class="text-muted">No products found</p>
                </div>
            `;
            return;
        }
        
        grid.innerHTML = '';
        
        products.forEach(product => {
            const productCard = createProductCard(product);
            grid.appendChild(productCard);
        });
    }
    
    function createProductCard(product) {
        const template = document.getElementById('productCardTemplate');
        const card = template.content.cloneNode(true);
        
        // Store product data on the element
        const cardElement = card.querySelector('.product-card');
        cardElement._productData = product;
        
        // Fill product data
        card.querySelector('[data-field="name"]').textContent = product.name || 'Unknown Product';
        card.querySelector('[data-field="sku"]').textContent = product.sku || 'N/A';
        card.querySelector('[data-field="barcode"]').textContent = product.barcode || 'N/A';
        card.querySelector('[data-field="price"]').textContent = `KES ${(product.price || product.final_price || product.sale_price || 0).toFixed(2)}`;
        card.querySelector('[data-field="cost"]').textContent = `Cost: KES ${(product.cost_price || 0).toFixed(2)}`;
        card.querySelector('[data-field="stock"]').textContent = `${product.stock || 0} in stock`;
        
        // Update badges
        const stockBadge = card.querySelector('[data-badge-type="stock"]');
        const vatBadge = card.querySelector('[data-badge-type="vat"]');
        const lowStockBadge = card.querySelector('[data-badge-type="low-stock"]');
        
        if (!product.stock || product.stock <= 0) {
            stockBadge.textContent = 'Out of Stock';
            stockBadge.className = 'badge bg-danger';
            cardElement.classList.add('out-of-stock');
        } else if (product.stock <= 5) {
            stockBadge.textContent = 'Low Stock';
            stockBadge.className = 'badge bg-warning';
        } else {
            stockBadge.textContent = 'In Stock';
            stockBadge.className = 'badge bg-success';
        }
        
        if (product.has_vat || product.is_vatable) {
            vatBadge.classList.remove('d-none');
        }
        
        if (product.stock <= (product.low_stock_threshold || 5)) {
            lowStockBadge.classList.remove('d-none');
        }
        
        // Add event listeners
        setupProductCardEventListeners(cardElement, product);
        
        return card;
    }
    
    function setupProductCardEventListeners(cardElement, product) {
        // Card click (add to cart)
        cardElement.addEventListener('click', function(e) {
            // Don't trigger if clicking on buttons or out of stock
            if (cardElement.classList.contains('out-of-stock')) return;
            if (e.target.closest('.btn') || e.target.closest('.btn-group')) return;
            
            addProductToCart(cardElement, product);
        });
        
        // Add to cart button
        const addBtn = cardElement.querySelector('.add-to-cart-btn');
        if (addBtn) {
            addBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                if (!cardElement.classList.contains('out-of-stock')) {
                    addProductToCart(cardElement, product);
                }
            });
        }
        
        // View details button
        const detailsBtn = cardElement.querySelector('.view-details-btn');
        if (detailsBtn) {
            detailsBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                viewProductDetails(product.id);
            });
        }
        
        // Add to favorites button
        const favoritesBtn = cardElement.querySelector('.add-to-favorites-btn');
        if (favoritesBtn) {
            favoritesBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                addToFavorites(product.id);
            });
        }
    }
    
    function addProductToCart(cardElement, product) {
        if (!product || !product.id) {
            console.error('Invalid product data');
            return;
        }
        
        // Add to cart using the global function
        if (window.addToCart) {
            const added = window.addToCart(product, 1);
            
            if (added) {
                // Visual feedback
                cardElement.classList.add('added-to-cart');
                setTimeout(() => {
                    cardElement.classList.remove('added-to-cart');
                }, 500);
            }
        } else {
            console.error('addToCart function not available');
        }
    }
    
    function renderProductTable(products) {
        const tbody = document.getElementById('productTable');
        if (!tbody) return;
        
        if (!products || products.length === 0) {
            tbody.innerHTML = `
                <tr>
                    <td colspan="8" class="text-center py-5">
                        <i class="bx bx-package bx-lg text-muted mb-3"></i>
                        <p class="text-muted">No products found</p>
                    </td>
                </tr>
            `;
            return;
        }
        
        tbody.innerHTML = '';
        
        products.forEach(product => {
            const productRow = createProductRow(product);
            tbody.appendChild(productRow);
        });
    }
    
    function createProductRow(product) {
        const template = document.getElementById('productRowTemplate');
        const row = template.content.cloneNode(true);
        
        // Store product data on the element
        const rowElement = row.querySelector('.product-row');
        rowElement._productData = product;
        
        // Fill product data
        row.querySelector('[data-field="name"]').textContent = product.name || 'Unknown Product';
        row.querySelector('[data-field="sku"]').textContent = product.sku || 'N/A';
        row.querySelector('[data-field="barcode"]').textContent = product.barcode || 'N/A';
        row.querySelector('[data-field="price"]').textContent = `KES ${(product.price || product.final_price || product.sale_price || 0).toFixed(2)}`;
        row.querySelector('[data-field="stock"]').textContent = product.stock || 0;
        
        // Update badges
        const stockBadge = row.querySelector('[data-badge-type="stock"]');
        const vatBadge = row.querySelector('.vat-badge');
        
        if (!product.stock || product.stock <= 0) {
            stockBadge.textContent = 'Out';
            stockBadge.className = 'badge bg-danger stock-badge';
            rowElement.classList.add('out-of-stock');
        } else if (product.stock <= 5) {
            stockBadge.textContent = 'Low';
            stockBadge.className = 'badge bg-warning stock-badge';
        } else {
            stockBadge.textContent = 'In';
            stockBadge.className = 'badge bg-success stock-badge';
        }
        
        if (product.has_vat || product.is_vatable) {
            vatBadge.classList.remove('d-none');
        }
        
        // Add event listeners
        setupProductRowEventListeners(rowElement, product);
        
        return row;
    }
    
    function setupProductRowEventListeners(rowElement, product) {
        // Row click (add to cart)
        rowElement.addEventListener('click', function(e) {
            // Don't trigger if clicking on buttons or out of stock
            if (rowElement.classList.contains('out-of-stock')) return;
            if (e.target.closest('.btn') || e.target.closest('.btn-group')) return;
            
            addProductToCartFromTable(rowElement, product);
        });
        
        // Add to cart button
        const addBtn = rowElement.querySelector('.add-to-cart-table-btn');
        if (addBtn) {
            addBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                if (!rowElement.classList.contains('out-of-stock')) {
                    addProductToCartFromTable(rowElement, product);
                }
            });
        }
        
        // View details button
        const detailsBtn = rowElement.querySelector('.view-details-table-btn');
        if (detailsBtn) {
            detailsBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                viewProductDetails(product.id);
            });
        }
    }
    
    function addProductToCartFromTable(rowElement, product) {
        if (!product || !product.id) {
            console.error('Invalid product data');
            return;
        }
        
        // Add to cart using the global function
        if (window.addToCart) {
            const added = window.addToCart(product, 1);
            
            if (added) {
                // Visual feedback
                rowElement.classList.add('added-to-cart');
                setTimeout(() => {
                    rowElement.classList.remove('added-to-cart');
                }, 500);
            }
        } else {
            console.error('addToCart function not available');
        }
    }
    
    function setupProductGridEventListeners() {
        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            // Focus search on Ctrl+F or /
            if ((e.ctrlKey && e.key === 'f') || e.key === '/') {
                e.preventDefault();
                const searchInput = document.getElementById('productSearch');
                if (searchInput) {
                    searchInput.focus();
                    searchInput.select();
                }
            }
            
            // Toggle view mode on Ctrl+V
            if (e.ctrlKey && e.key === 'v') {
                e.preventDefault();
                toggleViewMode();
            }
        });
    }
    
    function setupViewModeTabs() {
        const gridTab = document.getElementById('grid-tab');
        const listTab = document.getElementById('list-tab');
        
        if (gridTab && listTab) {
            gridTab.addEventListener('click', function() {
                window.productGridState.currentViewMode = 'grid';
                updateViewModeUI();
                renderProducts(window.productGridState.filteredProducts);
            });
            
            listTab.addEventListener('click', function() {
                window.productGridState.currentViewMode = 'list';
                updateViewModeUI();
                renderProducts(window.productGridState.filteredProducts);
            });
        }
    }
    
    function updateViewModeUI() {
        const viewModeIcon = document.getElementById('viewModeIcon');
        const viewModeText = document.getElementById('viewModeText');
        
        if (window.productGridState.currentViewMode === 'grid') {
            if (viewModeIcon) viewModeIcon.className = 'bx bx-grid';
            if (viewModeText) viewModeText.textContent = 'Grid View';
        } else {
            if (viewModeIcon) viewModeIcon.className = 'bx bx-list-ul';
            if (viewModeText) viewModeText.textContent = 'List View';
        }
    }
    
    function toggleViewMode() {
        window.productGridState.currentViewMode = window.productGridState.currentViewMode === 'grid' ? 'list' : 'grid';
        updateViewModeUI();
        
        // Switch tabs
        if (window.productGridState.currentViewMode === 'grid') {
            const gridTab = document.getElementById('grid-tab');
            if (gridTab) gridTab.click();
        } else {
            const listTab = document.getElementById('list-tab');
            if (listTab) listTab.click();
        }
        
        renderProducts(window.productGridState.filteredProducts);
    }
    
    function setupCategoryFilter() {
        const categoryFilter = document.getElementById('categoryFilter');
        if (categoryFilter) {
            categoryFilter.addEventListener('change', function() {
                const categoryId = this.value;
                window.productGridState.currentCategory = categoryId;
                filterByCategory(categoryId);
            });
        }
    }
    
    function filterByCategory(categoryId) {
        if (categoryId === 'all') {
            window.productGridState.filteredProducts = [...window.productGridState.allProducts];
        } else {
            window.productGridState.filteredProducts = window.productGridState.allProducts.filter(
                product => product.category_id == categoryId
            );
        }
        
        renderProducts(window.productGridState.filteredProducts);
    }
    
    function setupSearch() {
        const searchInput = document.getElementById('productSearch');
        if (!searchInput) return;
        
        let searchTimeout;
        
        searchInput.addEventListener('input', function(e) {
            clearTimeout(searchTimeout);
            const query = e.target.value.trim();
            
            if (query.length >= 2) {
                searchTimeout = setTimeout(() => {
                    searchProducts(query);
                }, 300);
            } else if (query.length === 0) {
                // Reset to category filter
                filterByCategory(window.productGridState.currentCategory);
            }
        });
        
        searchInput.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                this.value = '';
                filterByCategory(window.productGridState.currentCategory);
            } else if (e.key === 'Enter') {
                searchProducts(this.value);
            }
        });
    }
    
    function searchProducts(query) {
        if (!query || query.trim() === '') {
            filterByCategory(window.productGridState.currentCategory);
            return;
        }
        
        const searchTerm = query.toLowerCase();
        
        // Filter products locally first
        let filtered = window.productGridState.allProducts;
        
        if (window.productGridState.currentCategory !== 'all') {
            filtered = filtered.filter(product => 
                product.category_id == window.productGridState.currentCategory
            );
        }
        
        window.productGridState.filteredProducts = filtered.filter(product => {
            return (
                (product.name && product.name.toLowerCase().includes(searchTerm)) ||
                (product.sku && product.sku.toLowerCase().includes(searchTerm)) ||
                (product.barcode && product.barcode.toLowerCase().includes(searchTerm))
            );
        });
        
        renderProducts(window.productGridState.filteredProducts);
    }
    
    function showLoading(show) {
        const grid = document.getElementById('productGrid');
        const table = document.getElementById('productTable');
        
        if (show) {
            if (grid) grid.style.opacity = '0.5';
            if (table) table.style.opacity = '0.5';
        } else {
            if (grid) grid.style.opacity = '1';
            if (table) table.style.opacity = '1';
        }
    }
    
    function showProductError() {
        const grid = document.getElementById('productGrid');
        const table = document.getElementById('productTable');
        
        if (window.productGridState.currentViewMode === 'grid' && grid) {
            grid.innerHTML = `
                <div class="col-12 text-center py-5">
                    <i class="bx bx-error-circle bx-lg text-danger mb-3"></i>
                    <p class="text-danger">Failed to load products</p>
                    <button class="btn btn-sm btn-outline-primary" onclick="window.location.reload()">
                        Retry
                    </button>
                </div>
            `;
        } else if (window.productGridState.currentViewMode === 'list' && table) {
            table.innerHTML = `
                <tr>
                    <td colspan="8" class="text-center py-5">
                        <i class="bx bx-error-circle bx-lg text-danger mb-3"></i>
                        <p class="text-danger">Failed to load products</p>
                        <button class="btn btn-sm btn-outline-primary" onclick="window.location.reload()">
                            Retry
                        </button>
                    </td>
                </tr>
            `;
        }
    }
    
    // Helper functions
    function viewProductDetails(productId) {
        console.log('View product details:', productId);
        if (window.showToast) {
            window.showToast('Product details feature coming soon!', 'info');
        }
    }
    
    function addToFavorites(productId) {
        console.log('Add to favorites:', productId);
        if (window.showToast) {
            window.showToast('Added to favorites', 'success');
        }
    }
    
    function toggleStockFilter() {
        if (window.showToast) {
            window.showToast('Stock filter feature coming soon!', 'info');
        }
    }
    
    function showLowStock() {
        if (window.showToast) {
            window.showToast('Low stock feature coming soon!', 'info');
        }
    }
    
    // Export functions
    window.filterByCategory = filterByCategory;
    window.toggleViewMode = toggleViewMode;
    window.toggleStockFilter = toggleStockFilter;
    window.showLowStock = showLowStock;
    
})();
</script><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/pos-product-grid.blade.php ENDPATH**/ ?>