<div class="modal fade" id="mpesaTransactionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="bx bx-transfer me-2"></i>M-Pesa Transactions</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body">
                <!-- Search and Filter -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-text"><i class="bx bx-search"></i></span>
                            <input type="text" class="form-control" id="mpesaSearch" 
                                   placeholder="Search by transaction ID, phone, or reference...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="mpesaStatusFilter">
                            <option value="">All Status</option>
                            <option value="pending">Pending</option>
                            <option value="completed">Completed</option>
                            <option value="matched">Matched</option>
                            <option value="failed">Failed</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="mpesaDateFilter">
                            <option value="">All Dates</option>
                            <option value="today">Today</option>
                            <option value="yesterday">Yesterday</option>
                            <option value="week">This Week</option>
                            <option value="month">This Month</option>
                        </select>
                    </div>
                </div>
                
                <!-- Stats -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card border-0 bg-light">
                            <div class="card-body text-center">
                                <div class="text-muted small">Total Transactions</div>
                                <div class="fw-bold" id="totalMpesaTransactions">0</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-0 bg-light">
                            <div class="card-body text-center">
                                <div class="text-muted small">Unmatched</div>
                                <div class="fw-bold text-warning" id="unmatchedMpesa">0</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-0 bg-light">
                            <div class="card-body text-center">
                                <div class="text-muted small">Today's Amount</div>
                                <div class="fw-bold text-success" id="todayMpesaAmount">KES 0</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-0 bg-light">
                            <div class="card-body text-center">
                                <div class="text-muted small">Auto-Matched</div>
                                <div class="fw-bold text-primary" id="autoMatchedCount">0</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Transactions Table -->
                <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                    <table class="table table-hover">
                        <thead style="position: sticky; top: 0; background: white; z-index: 1;">
                            <tr>
                                <th>Transaction ID</th>
                                <th>Phone</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Status</th>
                                <th>Sale</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="mpesaTableBody">
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-info" onclick="POSMpesaManager.syncTransactions()">
                    <i class="bx bx-sync me-2"></i>Sync
                </button>
                <button type="button" class="btn btn-success" onclick="POSMpesaManager.showManualPaymentModal()">
                    <i class="bx bx-edit me-2"></i>Manual Entry
                </button>
                <button type="button" class="btn btn-primary" onclick="loadMpesaTransactions()">
                    <i class="bx bx-refresh me-2"></i>Refresh
                </button>
                <button type="button" class="btn btn-outline-primary" onclick="POSMpesaManager.exportMpesaReport()">
                    <i class="bx bx-download me-2"></i>Export
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .mpesa-transaction { cursor: pointer; transition: background-color 0.2s; }
    .mpesa-transaction:hover { background-color: #f8fafc; }
    .transaction-id { font-family: monospace; font-size: 12px; color: #475569; }
    .mpesa-phone { font-weight: 500; }
    .transaction-amount { font-weight: bold; color: #059669; }
    .transaction-date { font-size: 12px; color: #64748b; }
    .status-badge { font-size: 11px; padding: 3px 8px; border-radius: 10px; }
    .status-pending { background-color: #fef3c7; color: #92400e; }
    .status-completed { background-color: #dcfce7; color: #166534; }
    .status-matched { background-color: #dbeafe; color: #1e40af; }
    .status-failed { background-color: #fee2e2; color: #991b1b; }
    .action-buttons { display: flex; gap: 5px; }
    .action-buttons .btn { padding: 3px 8px; font-size: 12px; }
</style>

<script>
    function showMpesaTransactionsModal() {
        const modal = new bootstrap.Modal(document.getElementById('mpesaTransactionsModal'));
        modal.show();
        loadMpesaTransactions();
    }
    
    async function loadMpesaTransactions() {
        try {
            const search = document.getElementById('mpesaSearch')?.value || '';
            const status = document.getElementById('mpesaStatusFilter')?.value || '';
            const date = document.getElementById('mpesaDateFilter')?.value || '';
            
            let url = '/api/mpesa/transactions';
            const params = new URLSearchParams();
            if (search) params.append('search', search);
            if (status) params.append('status', status);
            if (date) params.append('date', date);
            
            if (params.toString()) {
                url += '?' + params.toString();
            }
            
            const response = await fetch(url);
            const data = await response.json();
            
            if (data.success) {
                renderMpesaTransactions(data.transactions.data || data.transactions);
                updateMpesaStats(data.transactions);
            } else {
                POSUtils.showToast('Failed to load transactions', 'error');
            }
        } catch (error) {
            console.error('Load M-Pesa transactions error:', error);
            POSUtils.showToast('Failed to load transactions', 'error');
        }
    }
    
    function renderMpesaTransactions(transactions) {
        const tbody = document.getElementById('mpesaTableBody');
        
        if (!transactions || transactions.length === 0) {
            tbody.innerHTML = `
                <tr>
                    <td colspan="8" class="text-center py-5">
                        <i class="bx bx-receipt fs-1 text-muted mb-3"></i>
                        <p class="text-muted">No transactions found</p>
                    </td>
                </tr>
            `;
            return;
        }
        
        tbody.innerHTML = '';
        
        transactions.forEach(transaction => {
            const statusClass = `status-${transaction.status}`;
            const saleLink = transaction.sale_id ? 
                `<a href="/sales/${transaction.sale_id}" target="_blank" onclick="event.stopPropagation()">
                    ${transaction.sale?.invoice_no || 'View'}
                </a>` : 
                '<span class="text-warning">Not matched</span>';
            
            const row = document.createElement('tr');
            row.className = 'mpesa-transaction';
            row.innerHTML = `
                <td>
                    <div class="transaction-id">${transaction.transaction_id}</div>
                </td>
                <td>
                    <div class="mpesa-phone">${transaction.phone}</div>
                    <div class="transaction-date">
                        ${transaction.first_name ? transaction.first_name + ' ' : ''}
                        ${transaction.last_name || ''}
                    </div>
                </td>
                <td class="transaction-amount">
                    KES ${parseFloat(transaction.amount).toFixed(2)}
                </td>
                <td>
                    <div class="transaction-date">
                        ${new Date(transaction.transaction_date).toLocaleDateString()}<br>
                        ${new Date(transaction.transaction_date).toLocaleTimeString()}
                    </div>
                </td>
                <td>${transaction.reference || '-'}</td>
                <td><span class="status-badge ${statusClass}">${transaction.status}</span></td>
                <td>${saleLink}</td>
                <td>
                    <div class="action-buttons">
                        ${!transaction.sale_id ? `
                            <button class="btn btn-sm btn-outline-primary" 
                                    onclick="event.stopPropagation(); matchMpesaTransaction(${transaction.id})">
                                <i class="bx bx-link"></i>
                            </button>
                        ` : ''}
                        <button class="btn btn-sm btn-outline-secondary" 
                                onclick="event.stopPropagation(); viewMpesaTransaction(${transaction.id})">
                            <i class="bx bx-show"></i>
                        </button>
                        ${transaction.sale_id ? `
                            <button class="btn btn-sm btn-outline-danger" 
                                    onclick="event.stopPropagation(); POSMpesaManager.unmatchTransaction(${transaction.id})">
                                <i class="bx bx-unlink"></i>
                            </button>
                        ` : ''}
                    </div>
                </td>
            `;
            
            tbody.appendChild(row);
        });
    }
    
    function updateMpesaStats(transactions) {
        const total = transactions.data?.length || transactions.length || 0;
        const unmatched = transactions.data?.filter(t => !t.sale_id && t.status === 'completed').length || 0;
        
        document.getElementById('totalMpesaTransactions').textContent = total;
        document.getElementById('unmatchedMpesa').textContent = unmatched;
        
        const today = new Date().toISOString().split('T')[0];
        const todayAmount = transactions.data?.filter(t => 
            t.transaction_date.startsWith(today) && t.status === 'completed'
        ).reduce((sum, t) => sum + parseFloat(t.amount), 0) || 0;
        
        document.getElementById('todayMpesaAmount').textContent = `KES ${todayAmount.toFixed(2)}`;
        
        // Auto-matched count
        const autoMatched = transactions.data?.filter(t => t.sale_id && t.is_auto_matched).length || 0;
        document.getElementById('autoMatchedCount').textContent = autoMatched;
    }
    
    function viewMpesaTransaction(id) {
        POSMpesaManager.viewDetails(id);
    }
    
    function matchMpesaTransaction(id) {
        window.currentMpesaTransactionId = id;
        const modal = new bootstrap.Modal(document.getElementById('saleSelectionModal'));
        modal.show();
    }
    
    // Event listeners
    document.addEventListener('DOMContentLoaded', function() {
        const mpesaSearch = document.getElementById('mpesaSearch');
        const statusFilter = document.getElementById('mpesaStatusFilter');
        const dateFilter = document.getElementById('mpesaDateFilter');
        
        if (mpesaSearch) {
            mpesaSearch.addEventListener('input', POSUtils.debounce(loadMpesaTransactions, 300));
        }
        
        if (statusFilter) {
            statusFilter.addEventListener('change', loadMpesaTransactions);
        }
        
        if (dateFilter) {
            dateFilter.addEventListener('change', loadMpesaTransactions);
        }
    });
    
    // Export functions
    window.showMpesaTransactionsModal = showMpesaTransactionsModal;
    window.loadMpesaTransactions = loadMpesaTransactions;
</script><?php /**PATH C:\xampp\htdocs\Autopos\resources\views/pos/components/mpesa-transactions-modal.blade.php ENDPATH**/ ?>