@extends('layouts.app')

@section('title', 'Users Management')

@push('style')
<!-- Additional styles if needed -->
<style>
    .user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }
    .role-badge {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
    .table-actions {
        min-width: 120px;
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Start breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Users</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">User Management</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                @can('create users')
                <div class="btn-group">
                    <button type="button" class="btn btn-primary px-4">Add User</button>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('users.create') }}">
                            <i class="bx bx-user-plus"></i> Add New User
                        </a>
                        <a class="dropdown-item" href="{{ route('users.import') }}">
                            <i class="bx bx-import"></i> Import Users
                        </a>
                        @can('export users')
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{{ route('users.export', ['type' => 'excel'] + request()->query()) }}">
                            <i class="bx bx-download"></i> Export to Excel
                        </a>
                        <a class="dropdown-item" href="{{ route('users.export', ['type' => 'pdf'] + request()->query()) }}">
                            <i class="bx bxs-file-pdf"></i> Export to PDF
                        </a>
                        @endcan
                    </div>
                </div>
                @endcan
            </div>
        </div>
        <!-- End breadcrumb -->

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Users</p>
                                <h4 class="my-1 text-primary">{{ $totalUsers }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-light-primary text-primary ms-auto">
                                <i class="bx bx-group"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active Users</p>
                                <h4 class="my-1 text-success">{{ $activeUsers }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-light-success text-success ms-auto">
                                <i class="bx bx-user-check"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Inactive Users</p>
                                <h4 class="my-1 text-warning">{{ $inactiveUsers }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-light-warning text-warning ms-auto">
                                <i class="bx bx-user-x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Roles</p>
                                <h4 class="my-1 text-info">{{ $roles->count() }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-light-info text-info ms-auto">
                                <i class="bx bx-user-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card radius-10">
            <div class="card-body">
                <h6 class="mb-0 text-primary">Filters</h6>
                <hr>
                <form method="GET" action="{{ route('users.index') }}" id="filterForm">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Search</label>
                            <input type="text" class="form-control" name="search" 
                                value="{{ request('search') }}" placeholder="Name, Email, Phone...">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role">
                                <option value="">All Roles</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->name }}" {{ request('role') == $role->name ? 'selected' : '' }}>
                                        {{ ucfirst($role->name) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="">All Status</option>
                                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Department</label>
                            <select class="form-select" name="department">
                                <option value="">All Departments</option>
                                @foreach($departments as $department)
                                    <option value="{{ $department }}" {{ request('department') == $department ? 'selected' : '' }}>
                                        {{ $department }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bx bx-filter-alt"></i> Filter
                                </button>
                                <a href="{{ route('users.index') }}" class="btn btn-secondary">
                                    <i class="bx bx-reset"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Users Table -->
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center justify-content-between mb-3">
                    <h6 class="mb-0 text-primary">Users List</h6>
                    @can('delete users')
                    <button type="button" class="btn btn-danger btn-sm" id="bulkDeleteBtn" disabled>
                        <i class="bx bx-trash"></i> Delete Selected
                    </button>
                    @endcan
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="50">
                                    <input type="checkbox" id="selectAll" class="form-check-input">
                                </th>
                                <th>User</th>
                                <th>Contact</th>
                                <th>Roles</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Last Login</th>
                                <th class="table-actions">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $user)
                            <tr>
                                <td>
                                    <input type="checkbox" class="form-check-input user-checkbox" 
                                           value="{{ $user->id }}"
                                           {{ $user->id == auth()->id() ? 'disabled' : '' }}>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $user->profile_image_url }}" 
                                             class="user-avatar me-3"
                                             onerror="this.src='{{ asset('assets/images/default-avatar.png') }}'">
                                        <div class="">
                                            <h6 class="mb-0 font-weight-bold">{{ $user->name }}</h6>
                                            @if($user->employee_id)
                                                <small class="text-muted">ID: {{ $user->employee_id }}</small>
                                            @endif
                                            <br>
                                            <small class="text-muted">Joined: {{ $user->created_at->format('M d, Y') }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div><i class="bx bx-envelope me-1"></i>{{ $user->email }}</div>
                                    @if($user->phone)
                                        <div><i class="bx bx-phone me-1"></i>{{ $user->phone }}</div>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($user->roles as $role)
                                        <span class="badge role-badge bg-{{ \App\Helpers\RoleHelper::getColor($role->name) }}">
                                            <i class="bx bx-{{ \App\Helpers\RoleHelper::getIcon($role->name) }} me-1"></i>
                                            {{ ucfirst($role->name) }}
                                        </span>
                                        @endforeach
                                    </div>
                                </td>
                                <td>
                                    @if($user->department)
                                        <span class="badge bg-info">{{ $user->department }}</span>
                                        @if($user->position)
                                            <br><small>{{ $user->position }}</small>
                                        @endif
                                    @else
                                        <span class="text-muted">Not assigned</span>
                                    @endif
                                </td>
                                <td>
                                    @can('edit users')
                                        <div class="form-check form-switch">
                                            <input type="checkbox" 
                                                   class="form-check-input status-toggle" 
                                                   id="status{{ $user->id }}" 
                                                   data-user-id="{{ $user->id }}"
                                                   {{ $user->is_active ? 'checked' : '' }}
                                                   {{ $user->id == auth()->id() ? 'disabled' : '' }}>
                                            <label class="form-check-label" for="status{{ $user->id }}">
                                                <span class="badge bg-{{ $user->is_active ? 'success' : 'danger' }}">
                                                    {{ $user->is_active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </label>
                                        </div>
                                    @else
                                        <span class="badge bg-{{ $user->is_active ? 'success' : 'danger' }}">
                                            {{ $user->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    @endcan
                                </td>
                                <td>
                                    @if($user->last_login_at)
                                        <div>{{ $user->last_login_at->format('M d, Y') }}</div>
                                        <small class="text-muted">{{ $user->last_login_at->format('h:i A') }}</small>
                                        @if($user->last_login_ip)
                                            <br><small class="text-muted">IP: {{ $user->last_login_ip }}</small>
                                        @endif
                                    @else
                                        <span class="text-muted">Never</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex order-actions gap-1">
                                        <a href="{{ route('users.show', $user) }}" 
                                           class="btn btn-sm btn-outline-info"
                                           title="View">
                                            <i class="bx bx-show"></i>
                                        </a>
                                        
                                        @can('edit users')
                                        <a href="{{ route('users.edit', $user) }}" 
                                           class="btn btn-sm btn-outline-primary"
                                           title="Edit">
                                            <i class="bx bx-edit"></i>
                                        </a>
                                        @endcan
                                        
                                        @can('delete users')
                                            @if($user->id != auth()->id())
                                            <form action="{{ route('users.destroy', $user) }}" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirmDelete(this);">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-danger"
                                                        title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing {{ $users->firstItem() ?? 0 }} to {{ $users->lastItem() ?? 0 }} of {{ $users->total() }} entries
                    </div>
                    <nav aria-label="Page navigation">
                        {{ $users->links() }}
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Delete Modal -->
<div class="modal fade" id="bulkDeleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Bulk Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the selected users? This action cannot be undone.</p>
                <div class="alert alert-warning border-0 bg-warning alert-dismissible fade show py-2">
                    <div class="d-flex align-items-center">
                        <div class="font-35 text-dark">
                            <i class="bx bx-info-circle"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="mb-0 text-dark">Warning</h6>
                            <div>Users with sales or purchases cannot be deleted.</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmBulkDelete">Delete Selected</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
function confirmDelete(form) {
    event.preventDefault();
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });
}

$(document).ready(function() {
    // Select all checkbox
    $('#selectAll').change(function() {
        $('.user-checkbox:not(:disabled)').prop('checked', this.checked);
        updateBulkActions();
    });

    // Update bulk actions when checkboxes change
    $('.user-checkbox').change(function() {
        updateBulkActions();
    });

    // Update bulk delete button state
    function updateBulkActions() {
        const checkedCount = $('.user-checkbox:checked').length;
        $('#bulkDeleteBtn').prop('disabled', checkedCount === 0);
    }

    // Bulk delete
    $('#bulkDeleteBtn').click(function() {
        const selectedIds = $('.user-checkbox:checked').map(function() {
            return $(this).val();
        }).get();

        if (selectedIds.length === 0) return;

        // Check if trying to delete yourself
        if (selectedIds.includes('{{ auth()->id() }}')) {
            Swal.fire({
                icon: 'error',
                title: 'Cannot Delete Yourself',
                text: 'You cannot delete your own account.'
            });
            return;
        }

        $('#bulkDeleteModal').modal('show');
        
        $('#confirmBulkDelete').off('click').on('click', function() {
            $(this).prop('disabled', true).html('<i class="bx bx-loader bx-spin"></i> Deleting...');
            
            $.ajax({
                url: '{{ route("users.bulk.delete") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    ids: selectedIds
                },
                success: function(response) {
                    $('#bulkDeleteModal').modal('hide');
                    $('#confirmBulkDelete').prop('disabled', false).text('Delete Selected');
                    
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: response.message
                        });
                    }
                },
                error: function(xhr) {
                    $('#bulkDeleteModal').modal('hide');
                    $('#confirmBulkDelete').prop('disabled', false).text('Delete Selected');
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: xhr.responseJSON?.message || 'An error occurred while deleting users.'
                    });
                }
            });
        });
    });

    // Status toggle
    $('.status-toggle').change(function() {
        const userId = $(this).data('user-id');
        const isActive = $(this).is(':checked');
        
        if (userId === '{{ auth()->id() }}') {
            Swal.fire({
                icon: 'error',
                title: 'Cannot Change Status',
                text: 'You cannot change your own status.'
            });
            $(this).prop('checked', !isActive);
            return;
        }

        Swal.fire({
            title: 'Are you sure?',
            text: `Do you want to ${isActive ? 'activate' : 'deactivate'} this user?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: `Yes, ${isActive ? 'activate' : 'deactivate'}`
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '{{ url("users") }}/' + userId + '/status',
                    method: 'PUT',
                    data: {
                        _token: '{{ csrf_token() }}',
                        status: isActive ? 1 : 0
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: xhr.responseJSON?.message || 'An error occurred.'
                        }).then(() => {
                            location.reload();
                        });
                    }
                });
            } else {
                $(this).prop('checked', !isActive);
            }
        });
    });
});
</script>
@endpush