@extends('layouts.app')

@section('title', 'General Settings')

@section('style')
<link href="{{ asset('assets/plugins/select2/css/select2.min.css') }}" rel="stylesheet" />
<link href="{{ asset('assets/plugins/select2/css/select2-bootstrap4.css') }}" rel="stylesheet" />
@endsection

@section('content')
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Settings</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('settings.index') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">General Settings</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button type="button" class="btn btn-primary" onclick="saveSettings()" id="saveBtn">
                    <i class="bx bx-save mr-1"></i>Save Settings
                </button>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Settings Tabs -->
                        <ul class="nav nav-tabs nav-primary mb-3" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link active" data-bs-toggle="tab" href="#app" role="tab" aria-selected="true">
                                    <i class="bx bx-globe mr-1"></i>Application
                                </a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" data-bs-toggle="tab" href="#display" role="tab" aria-selected="false">
                                    <i class="bx bx-palette mr-1"></i>Display
                                </a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" data-bs-toggle="tab" href="#datetime" role="tab" aria-selected="false">
                                    <i class="bx bx-time mr-1"></i>Date & Time
                                </a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" data-bs-toggle="tab" href="#security" role="tab" aria-selected="false">
                                    <i class="bx bx-shield-alt mr-1"></i>Security
                                </a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" data-bs-toggle="tab" href="#notifications" role="tab" aria-selected="false">
                                    <i class="bx bx-bell mr-1"></i>Notifications
                                </a>
                            </li>
                        </ul>
                        
                        <div class="tab-content py-3">
                            <!-- Application Settings -->
                            <div class="tab-pane fade show active" id="app" role="tabpanel">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="app_name" class="form-label">Application Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="app_name" name="app_name" 
                                               value="{{ config('app.name', 'AutoPOS') }}"
                                               placeholder="Enter application name">
                                        <div class="form-text">Displayed in browser title and header</div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="app_url" class="form-label">Application URL <span class="text-danger">*</span></label>
                                        <input type="url" class="form-control" id="app_url" name="app_url" 
                                               value="{{ config('app.url', url('/')) }}"
                                               placeholder="https://example.com">
                                        <div class="form-text">Base URL of your application</div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="app_env" class="form-label">Environment</label>
                                        <select class="form-select" id="app_env" name="app_env">
                                            <option value="local" {{ config('app.env') == 'local' ? 'selected' : '' }}>Local</option>
                                            <option value="development" {{ config('app.env') == 'development' ? 'selected' : '' }}>Development</option>
                                            <option value="staging" {{ config('app.env') == 'staging' ? 'selected' : '' }}>Staging</option>
                                            <option value="production" {{ config('app.env') == 'production' ? 'selected' : '' }}>Production</option>
                                        </select>
                                        <div class="form-text">Current: <code>{{ config('app.env') }}</code></div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="debug_mode" class="form-label">Debug Mode</label>
                                        <select class="form-select" id="debug_mode" name="debug_mode">
                                            <option value="1" {{ config('app.debug') ? 'selected' : '' }}>Enabled</option>
                                            <option value="0" {{ !config('app.debug') ? 'selected' : '' }}>Disabled</option>
                                        </select>
                                        <div class="form-text">Show detailed error messages</div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="maintenance_mode" class="form-label">Maintenance Mode</label>
                                        <select class="form-select" id="maintenance_mode" name="maintenance_mode">
                                            <option value="0">Disabled</option>
                                            <option value="1">Enabled</option>
                                        </select>
                                        <div class="form-text">Show maintenance page to users</div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="force_https" class="form-label">Force HTTPS</label>
                                        <select class="form-select" id="force_https" name="force_https">
                                            <option value="1" {{ request()->isSecure() ? 'selected' : '' }}>Enabled</option>
                                            <option value="0" {{ !request()->isSecure() ? 'selected' : '' }}>Disabled</option>
                                        </select>
                                        <div class="form-text">Redirect all HTTP traffic to HTTPS</div>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="app_description" class="form-label">Application Description</label>
                                    <textarea class="form-control" id="app_description" name="app_description" rows="3" placeholder="Brief description of your application">{{ old('app_description', 'Point of Sale System') }}</textarea>
                                </div>
                            </div>

                            <!-- Display Settings -->
                            <div class="tab-pane fade" id="display" role="tabpanel">
                                <div class="row mb-4">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label mb-2">Theme Mode</label>
                                        <div class="d-flex gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="theme_mode" id="theme_light" value="light" checked>
                                                <label class="form-check-label" for="theme_light">
                                                    <i class="bx bx-sun mr-1"></i> Light
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="theme_mode" id="theme_dark" value="dark">
                                                <label class="form-check-label" for="theme_dark">
                                                    <i class="bx bx-moon mr-1"></i> Dark
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="theme_mode" id="theme_auto" value="auto">
                                                <label class="form-check-label" for="theme_auto">
                                                    <i class="bx bx-adjust mr-1"></i> Auto
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="theme_color" class="form-label">Theme Color</label>
                                        <select class="form-select" id="theme_color" name="theme_color">
                                            <option value="default" selected>Default (Blue)</option>
                                            <option value="green">Green</option>
                                            <option value="red">Red</option>
                                            <option value="purple">Purple</option>
                                            <option value="orange">Orange</option>
                                            <option value="teal">Teal</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row mb-4">
                                    <div class="col-md-6 mb-3">
                                        <label for="sidebar_style" class="form-label">Sidebar Style</label>
                                        <select class="form-select" id="sidebar_style" name="sidebar_style">
                                            <option value="default" selected>Default</option>
                                            <option value="compact">Compact</option>
                                            <option value="icon-only">Icon Only</option>
                                            <option value="hidden">Hidden</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="layout_style" class="form-label">Layout Style</label>
                                        <select class="form-select" id="layout_style" name="layout_style">
                                            <option value="default" selected>Default</option>
                                            <option value="boxed">Boxed</option>
                                            <option value="fluid">Fluid</option>
                                            <option value="fixed">Fixed</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Display Options</label>
                                    <div class="row g-3">
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="show_breadcrumb" id="show_breadcrumb" checked>
                                                <label class="form-check-label" for="show_breadcrumb">Show Breadcrumb</label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="show_footer" id="show_footer" checked>
                                                <label class="form-check-label" for="show_footer">Show Footer</label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="show_sidebar_logo" id="show_sidebar_logo" checked>
                                                <label class="form-check-label" for="show_sidebar_logo">Show Sidebar Logo</label>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="animations" id="animations" checked>
                                                <label class="form-check-label" for="animations">Enable Animations</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Date & Time Settings -->
                            <div class="tab-pane fade" id="datetime" role="tabpanel">
                                <div class="row mb-3">
                                    <div class="col-md-6 mb-3">
                                        <label for="timezone" class="form-label">Timezone <span class="text-danger">*</span></label>
                                        <select class="form-select select2" id="timezone" name="timezone" required>
                                            <option value="Africa/Nairobi" {{ config('app.timezone', 'UTC') == 'Africa/Nairobi' ? 'selected' : '' }}>Africa/Nairobi (EAT)</option>
                                            <option value="Africa/Dar_es_Salaam" {{ config('app.timezone', 'UTC') == 'Africa/Dar_es_Salaam' ? 'selected' : '' }}>Africa/Dar_es_Salaam (EAT)</option>
                                            <option value="Africa/Kampala" {{ config('app.timezone', 'UTC') == 'Africa/Kampala' ? 'selected' : '' }}>Africa/Kampala (EAT)</option>
                                            <option value="UTC" {{ config('app.timezone', 'UTC') == 'UTC' ? 'selected' : '' }}>UTC</option>
                                            <option value="America/New_York" {{ config('app.timezone', 'UTC') == 'America/New_York' ? 'selected' : '' }}>America/New_York (EST)</option>
                                            <option value="Europe/London" {{ config('app.timezone', 'UTC') == 'Europe/London' ? 'selected' : '' }}>Europe/London (GMT)</option>
                                        </select>
                                        <div class="form-text">Current: <code>{{ config('app.timezone', 'UTC') }}</code></div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="locale" class="form-label">Locale/Language</label>
                                        <select class="form-select" id="locale" name="locale">
                                            <option value="en" {{ config('app.locale', 'en') == 'en' ? 'selected' : '' }}>English</option>
                                            <option value="sw" {{ config('app.locale', 'en') == 'sw' ? 'selected' : '' }}>Swahili</option>
                                            <option value="fr" {{ config('app.locale', 'en') == 'fr' ? 'selected' : '' }}>French</option>
                                            <option value="es" {{ config('app.locale', 'en') == 'es' ? 'selected' : '' }}>Spanish</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6 mb-3">
                                        <label for="date_format" class="form-label">Date Format</label>
                                        <select class="form-select" id="date_format" name="date_format">
                                            <option value="Y-m-d">YYYY-MM-DD (2026-01-03)</option>
                                            <option value="d/m/Y" selected>DD/MM/YYYY (03/01/2026)</option>
                                            <option value="m/d/Y">MM/DD/YYYY (01/03/2026)</option>
                                            <option value="d M Y">DD MMM YYYY (03 Jan 2026)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="time_format" class="form-label">Time Format</label>
                                        <select class="form-select" id="time_format" name="time_format">
                                            <option value="12" selected>12-hour (02:30 PM)</option>
                                            <option value="24">24-hour (14:30)</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6 mb-3">
                                        <label for="currency" class="form-label">Currency <span class="text-danger">*</span></label>
                                        <select class="form-select" id="currency" name="currency" required>
                                            <option value="KES" selected>KES - Kenyan Shilling</option>
                                            <option value="USD">USD - US Dollar</option>
                                            <option value="EUR">EUR - Euro</option>
                                            <option value="GBP">GBP - British Pound</option>
                                            <option value="UGX">UGX - Ugandan Shilling</option>
                                            <option value="TZS">TZS - Tanzanian Shilling</option>
                                            <option value="RWF">RWF - Rwandan Franc</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="currency_symbol" class="form-label">Currency Symbol Position</label>
                                        <select class="form-select" id="currency_symbol" name="currency_symbol">
                                            <option value="left" selected>Left (KSh 100)</option>
                                            <option value="right">Right (100 KSh)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Security Settings -->
                            <div class="tab-pane fade" id="security" role="tabpanel">
                                <div class="mb-4">
                                    <h6 class="mb-3">Session Settings</h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="session_lifetime" class="form-label">Session Lifetime</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="session_lifetime" name="session_lifetime" value="120" min="1" max="1440">
                                                <span class="input-group-text">minutes</span>
                                            </div>
                                            <div class="form-text">Default: 120 minutes (2 hours)</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <h6 class="mb-3">Password Settings</h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="password_min_length" class="form-label">Minimum Password Length</label>
                                            <input type="number" class="form-control" id="password_min_length" name="password_min_length" value="8" min="6" max="32">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="password_expiry" class="form-label">Password Expiry</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="password_expiry" name="password_expiry" value="90" min="0" max="365">
                                                <span class="input-group-text">days</span>
                                            </div>
                                            <div class="form-text">0 = Never expire</div>
                                        </div>
                                    </div>
                                    
                                    <div class="row g-3 mt-2">
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="password_uppercase" id="password_uppercase" checked>
                                                <label class="form-check-label" for="password_uppercase">Require uppercase letters</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="password_numbers" id="password_numbers" checked>
                                                <label class="form-check-label" for="password_numbers">Require numbers</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="password_special" id="password_special">
                                                <label class="form-check-label" for="password_special">Require special characters</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <h6 class="mb-3">Login Security</h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="login_attempts" class="form-label">Max Login Attempts</label>
                                            <input type="number" class="form-control" id="login_attempts" name="login_attempts" value="5" min="1" max="10">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="lockout_time" class="form-label">Lockout Time</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="lockout_time" name="lockout_time" value="15" min="1" max="60">
                                                <span class="input-group-text">minutes</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row g-3 mt-2">
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="two_factor_auth" id="two_factor_auth">
                                                <label class="form-check-label" for="two_factor_auth">Enable Two-Factor Authentication</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="remember_me" id="remember_me" checked>
                                                <label class="form-check-label" for="remember_me">Enable "Remember Me" feature</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Notification Settings -->
                            <div class="tab-pane fade" id="notifications" role="tabpanel">
                                <div class="mb-4">
                                    <h6 class="mb-3">Email Notifications</h6>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="email_system_alerts" id="email_system_alerts" checked>
                                                <label class="form-check-label" for="email_system_alerts">System Alerts & Errors</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="email_backup_reports" id="email_backup_reports" checked>
                                                <label class="form-check-label" for="email_backup_reports">Backup Reports</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="email_security_alerts" id="email_security_alerts" checked>
                                                <label class="form-check-label" for="email_security_alerts">Security Alerts</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <h6 class="mb-3">In-App Notifications</h6>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="inapp_sales_alerts" id="inapp_sales_alerts" checked>
                                                <label class="form-check-label" for="inapp_sales_alerts">New Sales & Transactions</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="inapp_stock_alerts" id="inapp_stock_alerts" checked>
                                                <label class="form-check-label" for="inapp_stock_alerts">Low Stock Alerts</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="inapp_expiry_alerts" id="inapp_expiry_alerts" checked>
                                                <label class="form-check-label" for="inapp_expiry_alerts">Product Expiry Alerts</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <h6 class="mb-3">Notification Preferences</h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="notification_sound" class="form-label">Notification Sound</label>
                                            <select class="form-select" id="notification_sound" name="notification_sound">
                                                <option value="default" selected>Default</option>
                                                <option value="chime">Chime</option>
                                                <option value="bell">Bell</option>
                                                <option value="beep">Beep</option>
                                                <option value="none">None</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="notification_duration" class="form-label">Display Duration</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="notification_duration" name="notification_duration" value="5" min="1" max="60">
                                                <span class="input-group-text">seconds</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="desktop_notifications" id="desktop_notifications" checked>
                                        <label class="form-check-label" for="desktop_notifications">Enable Desktop Notifications</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Settings Preview -->
        <div class="row mt-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-show mr-2"></i>Settings Preview</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <strong class="d-block mb-1">Application:</strong>
                            <span class="text-muted" id="previewApp">{{ config('app.name', 'AutoPOS') }} - {{ config('app.url', url('/')) }}</span>
                        </div>
                        <div class="mb-3">
                            <strong class="d-block mb-1">Date & Time:</strong>
                            <span class="text-muted" id="previewDateTime">{{ now()->format('d/m/Y H:i') }} ({{ config('app.timezone', 'UTC') }})</span>
                        </div>
                        <div class="mb-3">
                            <strong class="d-block mb-1">Currency:</strong>
                            <span class="text-muted" id="previewCurrency">KES (KSh 1,000.00)</span>
                        </div>
                        <div class="mb-3">
                            <strong class="d-block mb-1">Theme:</strong>
                            <span class="text-muted" id="previewTheme">Light Mode</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0"><i class="bx bx-history mr-2"></i>Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-outline-secondary" onclick="resetToDefaults()">
                                <i class="bx bx-reset mr-1"></i>Reset to Defaults
                            </button>
                            <button type="button" class="btn btn-outline-success" onclick="exportSettings()">
                                <i class="bx bx-download mr-1"></i>Export Settings
                            </button>
                            <button type="button" class="btn btn-outline-warning" onclick="importSettings()">
                                <i class="bx bx-upload mr-1"></i>Import Settings
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<!-- Import Settings Modal -->
<div class="modal fade" id="importModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bx bx-upload mr-2"></i>Import Settings</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning border-0">
                    <i class="bx bx-error-circle mr-2"></i>
                    Importing settings will overwrite all current settings.
                </div>
                
                <div class="mb-3">
                    <label for="settingsFile" class="form-label">Select Settings File</label>
                    <input class="form-control" type="file" id="settingsFile" accept=".json">
                    <div class="form-text">Supported format: JSON</div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="processImport()">
                    <i class="bx bx-upload mr-1"></i>Import
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="{{ asset('assets/plugins/select2/js/select2.min.js') }}"></script>

<script>
// Initialize Select2
$(document).ready(function() {
    $('.select2').select2({
        theme: 'bootstrap4',
        width: '100%'
    });
    
    // Update preview on change
    $('input, select, textarea').on('change input', updatePreview);
    
    // Initial preview
    updatePreview();
    
    // Auto-save indicator
    setInterval(() => {
        const hasChanges = false; // Implement change detection
        if (hasChanges) {
            console.log('Auto-saving settings...');
        }
    }, 30000);
});

// Save all settings
function saveSettings() {
    // Collect data from all forms
    const settings = {
        application: collectFormData(),
        display: collectDisplayData(),
        datetime: collectDatetimeData(),
        security: collectSecurityData(),
        notifications: collectNotificationData()
    };
    
    // Validate required fields
    if (!settings.application.app_name || !settings.application.app_url || 
        !settings.datetime.timezone || !settings.datetime.currency) {
        showNotification('Please fill in all required fields!', 'error');
        return;
    }
    
    const saveBtn = $('#saveBtn');
    const originalText = saveBtn.html();
    
    saveBtn.prop('disabled', true);
    saveBtn.html('<i class="bx bx-loader-circle bx-spin mr-1"></i>Saving...');
    
    // Simulate API call
    setTimeout(() => {
        saveBtn.prop('disabled', false);
        saveBtn.html(originalText);
        
        updatePreview();
        showNotification('Settings saved successfully!', 'success');
        console.log('Settings saved:', settings);
    }, 2000);
}

// Collect form data
function collectFormData() {
    const data = {};
    $('#app input, #app select, #app textarea').each(function() {
        const name = $(this).attr('name');
        if (name) {
            if ($(this).attr('type') === 'checkbox') {
                data[name] = $(this).is(':checked');
            } else if ($(this).attr('type') === 'radio') {
                if ($(this).is(':checked')) {
                    data[name] = $(this).val();
                }
            } else {
                data[name] = $(this).val();
            }
        }
    });
    return data;
}

function collectDisplayData() {
    const data = {};
    $('#display input, #display select').each(function() {
        const name = $(this).attr('name');
        if (name) {
            if ($(this).attr('type') === 'checkbox') {
                data[name] = $(this).is(':checked');
            } else if ($(this).attr('type') === 'radio') {
                if ($(this).is(':checked')) {
                    data[name] = $(this).val();
                }
            } else {
                data[name] = $(this).val();
            }
        }
    });
    return data;
}

function collectDatetimeData() {
    const data = {};
    $('#datetime input, #datetime select').each(function() {
        const name = $(this).attr('name');
        if (name) {
            data[name] = $(this).val();
        }
    });
    return data;
}

function collectSecurityData() {
    const data = {};
    $('#security input, #security select').each(function() {
        const name = $(this).attr('name');
        if (name) {
            if ($(this).attr('type') === 'checkbox') {
                data[name] = $(this).is(':checked');
            } else {
                data[name] = $(this).val();
            }
        }
    });
    return data;
}

function collectNotificationData() {
    const data = {};
    $('#notifications input, #notifications select').each(function() {
        const name = $(this).attr('name');
        if (name) {
            if ($(this).attr('type') === 'checkbox') {
                data[name] = $(this).is(':checked');
            } else {
                data[name] = $(this).val();
            }
        }
    });
    return data;
}

// Update preview
function updatePreview() {
    const appName = $('#app_name').val() || 'AutoPOS';
    const appUrl = $('#app_url').val() || window.location.origin;
    $('#previewApp').text(`${appName} - ${appUrl}`);
    
    const timezone = $('#timezone').val() || 'UTC';
    const now = new Date();
    const dateStr = now.toLocaleString('en-US', { timeZone: timezone });
    $('#previewDateTime').text(`${dateStr} (${timezone})`);
    
    const currency = $('#currency').val() || 'KES';
    const symbolPos = $('#currency_symbol').val() || 'left';
    const currencyDisplay = symbolPos === 'left' ? 'KSh 1,000.00' : '1,000.00 KSh';
    $('#previewCurrency').text(`${currency} (${currencyDisplay})`);
    
    const themeMode = $('input[name="theme_mode"]:checked').val() || 'light';
    $('#previewTheme').text(`${themeMode.charAt(0).toUpperCase() + themeMode.slice(1)} Mode`);
}

// Reset to defaults
function resetToDefaults() {
    Swal.fire({
        title: 'Reset Settings?',
        text: 'This will reset all settings to default values.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, reset it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Reset forms
            $('form input, form select, form textarea').each(function() {
                if ($(this).attr('type') === 'checkbox') {
                    $(this).prop('checked', false);
                } else if ($(this).attr('type') === 'radio') {
                    $(this).prop('checked', false);
                } else {
                    $(this).val('');
                }
            });
            
            // Set defaults
            $('#app_name').val('AutoPOS');
            $('#app_url').val(window.location.origin);
            $('#timezone').val('Africa/Nairobi').trigger('change');
            $('#currency').val('KES');
            $('#theme_light').prop('checked', true);
            
            updatePreview();
            showNotification('Settings reset to defaults!', 'success');
        }
    });
}

// Export settings
function exportSettings() {
    const settings = {
        application: collectFormData(),
        display: collectDisplayData(),
        datetime: collectDatetimeData(),
        security: collectSecurityData(),
        notifications: collectNotificationData(),
        exported_at: new Date().toISOString(),
        version: '1.0'
    };
    
    const dataStr = JSON.stringify(settings, null, 2);
    const dataUri = 'data:application/json;charset=utf-8,'+ encodeURIComponent(dataStr);
    const exportFileDefaultName = `autopos-settings-${new Date().toISOString().split('T')[0]}.json`;
    
    const linkElement = document.createElement('a');
    linkElement.setAttribute('href', dataUri);
    linkElement.setAttribute('download', exportFileDefaultName);
    linkElement.click();
    
    showNotification('Settings exported!', 'success');
}

// Import settings
function importSettings() {
    new bootstrap.Modal('#importModal').show();
}

// Process import
function processImport() {
    const fileInput = $('#settingsFile')[0];
    const file = fileInput.files[0];
    
    if (!file) {
        showNotification('Please select a file!', 'error');
        return;
    }
    
    const reader = new FileReader();
    reader.onload = function(e) {
        try {
            const settings = JSON.parse(e.target.result);
            
            if (!settings.application || !settings.datetime) {
                throw new Error('Invalid settings file format');
            }
            
            // Apply settings
            if (settings.application.app_name) {
                $('#app_name').val(settings.application.app_name);
            }
            if (settings.datetime.timezone) {
                $('#timezone').val(settings.datetime.timezone).trigger('change');
            }
            if (settings.datetime.currency) {
                $('#currency').val(settings.datetime.currency);
            }
            
            updatePreview();
            bootstrap.Modal.getInstance('#importModal').hide();
            showNotification('Settings imported!', 'success');
            
        } catch (error) {
            showNotification('Error: ' + error.message, 'error');
        }
    };
    
    reader.readAsText(file);
}

// Show notification
function showNotification(message, type = 'info') {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true
    });
    
    Toast.fire({
        icon: type,
        title: message
    });
}

// Keyboard shortcuts
$(document).on('keydown', function(e) {
    // Ctrl/Cmd + S to save
    if ((e.ctrlKey || e.metaKey) && e.key === 's') {
        e.preventDefault();
        saveSettings();
    }
    
    // Ctrl/Cmd + E to export
    if ((e.ctrlKey || e.metaKey) && e.key === 'e') {
        e.preventDefault();
        exportSettings();
    }
});
</script>
@endsection