@extends('layouts.app')

@section('style')
    <style>
        .product-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            padding: 30px;
            color: white;
            margin-bottom: 30px;
        }
        .info-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            transition: transform 0.3s;
        }
        .info-card:hover {
            transform: translateY(-5px);
        }
        .info-card .card-header {
            background-color: transparent;
            border-bottom: 2px solid #e9ecef;
            font-weight: 600;
        }
        .badge-custom {
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        .batch-card {
            border-left: 4px solid #667eea;
            border-radius: 8px;
        }
        .stock-movement-card {
            border-left: 4px solid #10b981;
            border-radius: 8px;
        }
        .price-history-card {
            border-left: 4px solid #f59e0b;
            border-radius: 8px;
        }
        .nav-tabs-custom .nav-link {
            border: none;
            color: #6c757d;
            font-weight: 600;
            padding: 12px 24px;
        }
        .nav-tabs-custom .nav-link.active {
            color: #667eea;
            border-bottom: 3px solid #667eea;
            background: transparent;
        }
        .tab-content {
            padding-top: 20px;
        }
        .action-btn {
            width: 40px;
            height: 40px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.3s;
        }
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 10px;
            background: white;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        .stat-card .stat-value {
            font-size: 28px;
            font-weight: 700;
            color: #2d3748;
        }
        .stat-card .stat-label {
            font-size: 14px;
            color: #718096;
            margin-top: 5px;
        }
        .expiry-status {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .expiry-normal { background-color: #d1fae5; color: #065f46; }
        .expiry-warning { background-color: #fef3c7; color: #92400e; }
        .expiry-critical { background-color: #fee2e2; color: #991b1b; }
        .stock-status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .stock-in_stock { background-color: #d1fae5; color: #065f46; }
        .stock-low_stock { background-color: #fef3c7; color: #92400e; }
        .stock-out_of_stock { background-color: #fee2e2; color: #991b1b; }
        .progress-bar-custom {
            height: 10px;
            border-radius: 5px;
        }
        .timeline {
            position: relative;
            padding-left: 30px;
        }
        .timeline:before {
            content: '';
            position: absolute;
            left: 10px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e5e7eb;
        }
        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }
        .timeline-item:before {
            content: '';
            position: absolute;
            left: -22px;
            top: 5px;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #667eea;
        }
        .modal-lg-custom {
            max-width: 900px;
        }
        .stock-action-btn {
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .stock-action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .batch-status-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 6px;
        }
        .batch-active { background-color: #10b981; }
        .batch-expiring { background-color: #f59e0b; }
        .batch-expired { background-color: #ef4444; }
        .batch-empty { background-color: #9ca3af; }
        .tax-calculator-table th {
            font-weight: 600;
            background-color: #f8f9fa;
        }
        .tax-example-card {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            transition: all 0.3s;
        }
        .tax-example-card:hover {
            border-color: #667eea;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .bg-green-100 {
            background-color: #d1fae5 !important;
        }
        .text-green-800 {
            color: #065f46 !important;
        }
        .bg-purple {
            background-color: #667eea !important;
        }
        .text-purple {
            color: #667eea !important;
        }
        .bg-gray-100 {
            background-color: #f3f4f6 !important;
        }
        .text-gray-800 {
            color: #374151 !important;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Product Header -->
        <div class="product-header">
            <div class="d-flex justify-content-between align-items-start">
                <div class="flex-grow-1">
                    <div class="d-flex align-items-center gap-3 mb-3">
                        <h2 class="mb-0 text-white">{{ $product->name }}</h2>
                        <span class="badge-custom" style="background: rgba(255,255,255,0.2);">
                            {{ $product->sku }}
                        </span>
                    </div>
                    <p class="text-white-50 mb-3">{{ $product->short_description }}</p>
                    <div class="d-flex flex-wrap gap-2">
                        @if($product->category)
                        <span class="badge-custom bg-white text-dark">
                            <i class="bx bx-category"></i> {{ $product->category->name }}
                        </span>
                        @endif
                        @if($product->brand)
                        <span class="badge-custom bg-white text-dark">
                            <i class="bx bx-barcode"></i> {{ $product->brand->name }}
                        </span>
                        @endif
                        <!-- Tax Status Badge -->
                        @if($product->has_vat && $product->tax)
                        <span class="badge-custom bg-green-100 text-green-800">
                            <i class="bx bx-receipt"></i> {{ $product->tax->name }} ({{ $product->tax->rate }}%)
                        </span>
                        @else
                        <span class="badge-custom bg-gray-100 text-gray-800">
                            <i class="bx bx-no-entry"></i> Tax Exempt
                        </span>
                        @endif
                        @if($product->is_featured)
                        <span class="badge-custom bg-yellow-100 text-yellow-800">
                            <i class="bx bx-star"></i> Featured
                        </span>
                        @endif
                        @if($product->is_on_sale)
                        <span class="badge-custom bg-red-100 text-red-800">
                            <i class="bx bx-dollar-circle"></i> On Sale
                        </span>
                        @endif
                    </div>
                </div>
                <div class="text-end">
                    <div class="d-flex gap-2">
                        <a href="{{ route('products.edit', $product) }}" 
                           class="btn btn-light btn-sm px-4">
                            <i class="bx bx-edit"></i> Edit
                        </a>
                        <div class="dropdown">
                            <button class="btn btn-light btn-sm px-4 dropdown-toggle" 
                                    type="button" data-bs-toggle="dropdown">
                                <i class="bx bx-dots-vertical-rounded"></i> Actions
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="#" 
                                       data-bs-toggle="modal" data-bs-target="#addStockModal">
                                        <i class="bx bx-plus"></i> Add Stock
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" 
                                       data-bs-toggle="modal" data-bs-target="#removeStockModal">
                                        <i class="bx bx-minus"></i> Remove Stock
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#" 
                                       data-bs-toggle="modal" data-bs-target="#adjustPriceModal">
                                        <i class="bx bx-dollar"></i> Adjust Price
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('products.price-history', $product) }}">
                                        <i class="bx bx-history"></i> Price History
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('products.stock-movements', $product) }}">
                                        <i class="bx bx-archive"></i> Stock Movements
                                    </a>
                                </li>
                                @if($product->track_batches)
                                <li>
                                    <a class="dropdown-item" href="{{ route('batches.create') }}?product_id={{ $product->id }}">
                                        <i class="bx bx-layer-plus"></i> Add New Batch
                                    </a>
                                </li>
                                @endif
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form action="{{ route('products.destroy', $product) }}" method="POST" 
                                          id="deleteForm" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="dropdown-item text-danger" 
                                                onclick="confirmDelete()">
                                            <i class="bx bx-trash"></i> Delete Product
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Row -->
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-5 mb-4">
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-primary">KES {{ number_format($product->final_price, 2) }}</div>
                    <div class="stat-label">Current Price</div>
                    @if($product->is_discounted)
                    <small class="text-muted">
                        <s>KES {{ number_format($product->sale_price, 2) }}</s> 
                        ({{ $product->discount_percent ? $product->discount_percent.'% off' : 'Discounted' }})
                    </small>
                    @endif
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-{{ $product->stock_status == 'out_of_stock' ? 'danger' : ($product->stock_status == 'low_stock' ? 'warning' : 'success') }}">
                        {{ $product->stock }}
                    </div>
                    <div class="stat-label">Current Stock</div>
                    <span class="stock-status-badge stock-{{ $product->stock_status }}">
                        {{ Str::title(str_replace('_', ' ', $product->stock_status)) }}
                    </span>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-info">{{ $product->available_stock }}</div>
                    <div class="stat-label">Available Stock</div>
                    <small class="text-muted">
                        Reserved: {{ $product->reserved_stock }} | 
                        Committed: {{ $product->committed_stock }}
                    </small>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-success">KES {{ number_format($product->profit_margin_percent, 1) }}%</div>
                    <div class="stat-label">Profit Margin</div>
                    <small class="text-muted">
                        Profit: KES {{ number_format($product->profit_margin, 2) }}
                    </small>
                </div>
            </div>
            <!-- Tax Statistics Card -->
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-{{ $product->has_vat ? 'purple' : 'gray' }}">
                        {{ $product->has_vat && $product->tax ? $product->tax->rate.'%' : '0%' }}
                    </div>
                    <div class="stat-label">Tax Rate</div>
                    <small class="text-muted">
                        @if($product->has_vat && $product->tax)
                        {{ $product->tax->name }}
                        @else
                        Tax Exempt
                        @endif
                    </small>
                </div>
            </div>
        </div>

        <!-- Main Content Tabs -->
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs nav-tabs-custom mb-3" id="productTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="overview-tab" data-bs-toggle="tab" 
                                data-bs-target="#overview" type="button">
                            <i class="bx bx-info-circle"></i> Overview
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="batches-tab" data-bs-toggle="tab" 
                                data-bs-target="#batches" type="button">
                            <i class="bx bx-layer"></i> Batches
                            @if($product->track_batches && $batchStats['total_batches'] > 0)
                            <span class="badge bg-primary rounded-pill ms-1">{{ $batchStats['total_batches'] }}</span>
                            @endif
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="inventory-tab" data-bs-toggle="tab" 
                                data-bs-target="#inventory" type="button">
                            <i class="bx bx-package"></i> Inventory
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pricing-tab" data-bs-toggle="tab" 
                                data-bs-target="#pricing" type="button">
                            <i class="bx bx-dollar-circle"></i> Pricing
                        </button>
                    </li>
                    <!-- New Tax Tab -->
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="tax-tab" data-bs-toggle="tab" 
                                data-bs-target="#tax" type="button">
                            <i class="bx bx-receipt"></i> Tax Information
                        </button>
                    </li>
                    @if($product->has_expiry)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="expiry-tab" data-bs-toggle="tab" 
                                data-bs-target="#expiry" type="button">
                            <i class="bx bx-calendar"></i> Expiry Tracking
                        </button>
                    </li>
                    @endif
                </ul>

                <div class="tab-content" id="productTabContent">
                    <!-- Overview Tab -->
                    <div class="tab-pane fade show active" id="overview" role="tabpanel">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-detail"></i> Product Details
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-borderless">
                                                    <tr>
                                                        <th width="40%">Product Name:</th>
                                                        <td>{{ $product->name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>SKU:</th>
                                                        <td>{{ $product->sku }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Barcode:</th>
                                                        <td>{{ $product->barcode ?? 'N/A' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Reference #:</th>
                                                        <td>{{ $product->ref_number ?? 'N/A' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Category:</th>
                                                        <td>
                                                            @if($product->category)
                                                            <span class="badge bg-light text-dark">
                                                                {{ $product->category->name }}
                                                            </span>
                                                            @else
                                                            N/A
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Brand:</th>
                                                        <td>{{ $product->brand->name ?? 'N/A' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="col-md-6">
                                                <table class="table table-borderless">
                                                    <tr>
                                                        <th width="40%">Supplier:</th>
                                                        <td>{{ $product->supplier->name ?? 'N/A' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Unit:</th>
                                                        <td>{{ $product->unit->name ?? 'N/A' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Tax Status:</th>
                                                        <td>
                                                            @if($product->has_vat && $product->tax)
                                                            <span class="badge bg-success">{{ $product->tax->name }} ({{ $product->tax->rate }}%)</span>
                                                            @else
                                                            <span class="badge bg-secondary">Tax Exempt</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Status:</th>
                                                        <td>
                                                            <span class="badge bg-{{ $product->status == 'active' ? 'success' : ($product->status == 'inactive' ? 'warning' : 'danger') }}">
                                                                {{ Str::title($product->status) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Created:</th>
                                                        <td>{{ $product->created_at->format('M d, Y H:i') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Last Updated:</th>
                                                        <td>{{ $product->updated_at->format('M d, Y H:i') }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        @if($product->description)
                                        <div class="mt-4">
                                            <h6>Description:</h6>
                                            <p class="mb-0">{{ $product->description }}</p>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Stock Status Card -->
                                <div class="info-card mb-3">
                                    <div class="card-header">
                                        <i class="bx bx-bar-chart-alt"></i> Stock Status
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span>Current Stock</span>
                                                <span class="fw-bold">{{ $product->stock }}</span>
                                            </div>
                                            @php
                                                $maxStock = $product->maximum_stock ?: $product->stock * 2;
                                                $stockPercentage = $product->stock > 0 ? ($product->stock / $maxStock) * 100 : 0;
                                            @endphp
                                            <div class="progress progress-bar-custom">
                                                <div class="progress-bar bg-{{ $product->stock_status == 'out_of_stock' ? 'danger' : ($product->stock_status == 'low_stock' ? 'warning' : 'success') }}" 
                                                     role="progressbar" style="width: {{ $stockPercentage }}%">
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row text-center">
                                            <div class="col-4 border-end">
                                                <div class="fw-bold text-primary">{{ $product->minimum_stock }}</div>
                                                <small class="text-muted">Min Stock</small>
                                            </div>
                                            <div class="col-4 border-end">
                                                <div class="fw-bold text-warning">{{ $product->reorder_point }}</div>
                                                <small class="text-muted">Reorder Point</small>
                                            </div>
                                            <div class="col-4">
                                                <div class="fw-bold text-info">{{ $product->maximum_stock ?? '∞' }}</div>
                                                <small class="text-muted">Max Stock</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Quick Actions -->
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-zap"></i> Quick Actions
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <button class="btn btn-outline-primary w-100 stock-action-btn" 
                                                        data-bs-toggle="modal" data-bs-target="#addStockModal">
                                                    <i class="bx bx-plus"></i> Add Stock
                                                </button>
                                            </div>
                                            <div class="col-6">
                                                <button class="btn btn-outline-danger w-100 stock-action-btn"
                                                        data-bs-toggle="modal" data-bs-target="#removeStockModal">
                                                    <i class="bx bx-minus"></i> Remove Stock
                                                </button>
                                            </div>
                                            <div class="col-6">
                                                <button class="btn btn-outline-success w-100 stock-action-btn"
                                                        onclick="location.href='{{ route('products.stock-movements', $product) }}'">
                                                    <i class="bx bx-archive"></i> Stock Movements
                                                </button>
                                            </div>
                                            <div class="col-6">
                                                <button class="btn btn-outline-info w-100 stock-action-btn"
                                                        onclick="location.href='{{ route('products.price-history', $product) }}'">
                                                    <i class="bx bx-history"></i> Price History
                                                </button>
                                            </div>
                                            <div class="col-6">
                                                <button class="btn btn-outline-warning w-100 stock-action-btn"
                                                        onclick="location.href='{{ route('products.tax-report') }}?tax_id={{ $product->tax_id }}'">
                                                    <i class="bx bx-receipt"></i> Tax Report
                                                </button>
                                            </div>
                                            @if($product->track_batches)
                                            <div class="col-6">
                                                <button class="btn btn-outline-warning w-100 stock-action-btn"
                                                        onclick="location.href='{{ route('batches.create') }}?product_id={{ $product->id }}'">
                                                    <i class="bx bx-layer-plus"></i> Add New Batch
                                                </button>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Batches Tab -->
                    <div class="tab-pane fade" id="batches" role="tabpanel">
                        @if($product->track_batches)
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">Product Batches</h5>
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('batches.create') }}?product_id={{ $product->id }}" 
                                           class="btn btn-primary btn-sm">
                                            <i class="bx bx-layer-plus"></i> Add New Batch
                                        </a>
                                        <a href="{{ route('products.batches', $product) }}" 
                                           class="btn btn-outline-secondary btn-sm">
                                            <i class="bx bx-list-ul"></i> View All
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Batch Statistics -->
                        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 mb-4">
                            <div class="col">
                                <div class="stat-card">
                                    <div class="stat-value text-primary">{{ $batchStats['total_batches'] }}</div>
                                    <div class="stat-label">Total Batches</div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="stat-card">
                                    <div class="stat-value text-success">{{ $batchStats['active_batches'] }}</div>
                                    <div class="stat-label">Active Batches</div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="stat-card">
                                    <div class="stat-value text-warning">{{ $batchStats['expiring_soon'] }}</div>
                                    <div class="stat-label">Expiring Soon</div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="stat-card">
                                    <div class="stat-value text-danger">{{ $batchStats['expired_batches'] }}</div>
                                    <div class="stat-label">Expired Batches</div>
                                </div>
                            </div>
                        </div>

                        <!-- Batches Table -->
                        <div class="info-card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-layer"></i> Recent Batches</span>
                                <a href="{{ route('products.batches', $product) }}" class="btn btn-link btn-sm">
                                    View All <i class="bx bx-chevron-right"></i>
                                </a>
                            </div>
                            <div class="card-body">
                                @if($product->batches->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Batch #</th>
                                                <th>Expiry Date</th>
                                                <th class="text-center">Quantity</th>
                                                <th class="text-end">Cost Price</th>
                                                <th class="text-end">Sale Price</th>
                                                <th>Status</th>
                                                <th class="text-end">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($product->batches->take(10) as $batch)
                                            @php
                                                $batchStatus = 'active';
                                                if($batch->current_quantity <= 0) {
                                                    $batchStatus = 'empty';
                                                } elseif($batch->expiry_date && $batch->expiry_date < now()) {
                                                    $batchStatus = 'expired';
                                                } elseif($batch->expiry_date && $batch->expiry_date <= now()->addDays($product->expiry_warning_days ?? 30)) {
                                                    $batchStatus = 'expiring';
                                                }
                                            @endphp
                                            <tr class="batch-card">
                                                <td>
                                                    <strong>{{ $batch->batch_number }}</strong>
                                                    @if($batch->lot_number)
                                                    <br><small class="text-muted">Lot: {{ $batch->lot_number }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($batch->expiry_date)
                                                    {{ $batch->expiry_date->format('M d, Y') }}
                                                    <br>
                                                    <small class="text-muted">
                                                        {{ $batch->expiry_date->diffForHumans() }}
                                                    </small>
                                                    @else
                                                    <span class="text-muted">No expiry</span>
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    <div class="fw-bold">{{ $batch->current_quantity }}</div>
                                                    <small class="text-muted">/ {{ $batch->initial_quantity }}</small>
                                                </td>
                                                <td class="text-end">KES {{ number_format($batch->batch_cost_price, 2) }}</td>
                                                <td class="text-end">KES {{ number_format($batch->batch_sale_price, 2) }}</td>
                                                <td>
                                                    <span class="badge bg-{{ $batchStatus == 'active' ? 'success' : ($batchStatus == 'expiring' ? 'warning' : ($batchStatus == 'expired' ? 'danger' : 'secondary')) }}">
                                                        <span class="batch-status-dot batch-{{ $batchStatus }}"></span>
                                                        {{ Str::title($batchStatus) }}
                                                    </span>
                                                </td>
                                                <td class="text-end">
                                                    <div class="d-flex justify-content-end gap-1">
                                                        <a href="{{ route('batches.show', $batch) }}" 
                                                           class="action-btn btn btn-outline-info btn-sm"
                                                           data-bs-toggle="tooltip" title="View Details">
                                                            <i class="bx bx-show"></i>
                                                        </a>
                                                        <a href="{{ route('batches.edit', $batch) }}" 
                                                           class="action-btn btn btn-outline-primary btn-sm"
                                                           data-bs-toggle="tooltip" title="Edit Batch">
                                                            <i class="bx bx-edit"></i>
                                                        </a>
                                                        <button class="action-btn btn btn-outline-warning btn-sm"
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#adjustBatchStockModal"
                                                                data-batch-id="{{ $batch->id }}"
                                                                data-batch-number="{{ $batch->batch_number }}"
                                                                data-current-quantity="{{ $batch->current_quantity }}"
                                                                onclick="setBatchAdjustmentData(this)"
                                                                title="Adjust Stock">
                                                            <i class="bx bx-adjust"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @else
                                <div class="text-center py-5">
                                    <i class="bx bx-layer display-4 text-muted mb-3"></i>
                                    <h5 class="text-muted">No batches found</h5>
                                    <p class="text-muted mb-4">This product has no batches yet.</p>
                                    <a href="{{ route('batches.create') }}?product_id={{ $product->id }}" 
                                       class="btn btn-primary">
                                        <i class="bx bx-layer-plus"></i> Create First Batch
                                    </a>
                                </div>
                                @endif
                            </div>
                        </div>
                        @else
                        <div class="text-center py-5">
                            <i class="bx bx-layer display-4 text-muted mb-3"></i>
                            <h5 class="text-muted">Batch Tracking Not Enabled</h5>
                            <p class="text-muted mb-4">This product is not configured for batch tracking.</p>
                            <a href="{{ route('products.edit', $product) }}" class="btn btn-primary">
                                <i class="bx bx-cog"></i> Enable Batch Tracking
                            </a>
                        </div>
                        @endif
                    </div>

                    <!-- Inventory Tab -->
                    <div class="tab-pane fade" id="inventory" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-trending-up"></i> Recent Stock Movements
                                    </div>
                                    <div class="card-body">
                                        @if($stockMovements->count() > 0)
                                        <div class="timeline">
                                            @foreach($stockMovements as $movement)
                                            <div class="timeline-item">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong>{{ $movement->reason }}</strong>
                                                        <p class="mb-1 small text-muted">
                                                            @if($movement->batch)
                                                            Batch: {{ $movement->batch->batch_number }}
                                                            @endif
                                                        </p>
                                                        <p class="mb-0 small">
                                                            {{ $movement->notes ?? 'No notes' }}
                                                        </p>
                                                    </div>
                                                    <div class="text-end">
                                                        <div class="fw-bold {{ $movement->movement_type == 'in' ? 'text-success' : 'text-danger' }}">
                                                            {{ $movement->movement_type == 'in' ? '+' : '-' }}{{ $movement->quantity }}
                                                        </div>
                                                        <small class="text-muted">
                                                            {{ $movement->created_at->format('M d, H:i') }}
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('products.stock-movements', $product) }}" 
                                               class="btn btn-outline-primary btn-sm">
                                                View All Movements
                                            </a>
                                        </div>
                                        @else
                                        <div class="text-center py-4">
                                            <i class="bx bx-history display-4 text-muted mb-3"></i>
                                            <p class="text-muted">No stock movements recorded yet.</p>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-stats"></i> Stock Analytics
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-4">
                                            <h6>Stock Distribution</h6>
                                            <div class="row">
                                                <div class="col-4 text-center">
                                                    <div class="fw-bold text-primary">{{ $product->stock }}</div>
                                                    <small class="text-muted">Total Stock</small>
                                                </div>
                                                <div class="col-4 text-center">
                                                    <div class="fw-bold text-success">{{ $product->available_stock }}</div>
                                                    <small class="text-muted">Available</small>
                                                </div>
                                                <div class="col-4 text-center">
                                                    <div class="fw-bold text-warning">{{ $product->reserved_stock + $product->committed_stock }}</div>
                                                    <small class="text-muted">Reserved/Committed</small>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <h6>Reorder Status</h6>
                                            @if($product->shouldReorder())
                                            <div class="alert alert-warning">
                                                <i class="bx bx-error"></i>
                                                <strong>Reorder Needed!</strong>
                                                <p class="mb-0">Stock is below reorder point. Suggested reorder quantity: {{ $product->getReorderQuantity() }}</p>
                                            </div>
                                            @else
                                            <div class="alert alert-success">
                                                <i class="bx bx-check-circle"></i>
                                                <strong>Stock Level OK</strong>
                                                <p class="mb-0">Current stock is above reorder point.</p>
                                            </div>
                                            @endif
                                        </div>
                                        
                                        <div>
                                            <h6>Quick Stock Actions</h6>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <button class="btn btn-outline-success w-100 btn-sm"
                                                            data-bs-toggle="modal" data-bs-target="#quickAddStockModal">
                                                        <i class="bx bx-plus"></i> Quick Add
                                                    </button>
                                                </div>
                                                <div class="col-6">
                                                    <button class="btn btn-outline-danger w-100 btn-sm"
                                                            data-bs-toggle="modal" data-bs-target="#quickRemoveStockModal">
                                                        <i class="bx bx-minus"></i> Quick Remove
                                                    </button>
                                                </div>
                                                <div class="col-12">
                                                    <button class="btn btn-outline-info w-100 btn-sm"
                                                            onclick="location.href='{{ route('products.add-stock.page', $product) }}'">
                                                        <i class="bx bx-detail"></i> Add Stock (Detailed)
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pricing Tab -->
                    <div class="tab-pane fade" id="pricing" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-dollar"></i> Price Details
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%">Cost Price:</th>
                                                <td class="text-end">KES {{ number_format($product->cost_price, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <th>Sale Price:</th>
                                                <td class="text-end">KES {{ number_format($product->sale_price, 2) }}</td>
                                            </tr>
                                            @if($product->wholesale_price)
                                            <tr>
                                                <th>Wholesale Price:</th>
                                                <td class="text-end">KES {{ number_format($product->wholesale_price, 2) }}</td>
                                            </tr>
                                            @endif
                                            <tr>
                                                <th>Final Price (Excl. Tax):</th>
                                                <td class="text-end fw-bold text-success">
                                                    KES {{ number_format($product->final_price, 2) }}
                                                </td>
                                            </tr>
                                            @if($product->has_vat && $product->tax)
                                            <tr>
                                                <th>Tax Amount ({{ $product->tax->rate }}%):</th>
                                                <td class="text-end text-danger">
                                                    KES {{ number_format($product->final_price * ($product->tax->rate / 100), 2) }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Final Price (Incl. Tax):</th>
                                                <td class="text-end fw-bold text-primary">
                                                    KES {{ number_format($product->final_price * (1 + $product->tax->rate / 100), 2) }}
                                                </td>
                                            </tr>
                                            @endif
                                            @if($product->is_discounted)
                                            <tr>
                                                <th>Discount:</th>
                                                <td class="text-end text-danger">
                                                    KES {{ number_format($product->discount_amount, 2) }}
                                                    @if($product->discount_percent)
                                                    ({{ $product->discount_percent }}%)
                                                    @endif
                                                </td>
                                            </tr>
                                            @endif
                                            <tr>
                                                <th>Profit Margin:</th>
                                                <td class="text-end">
                                                    <span class="fw-bold {{ $product->profit_margin_percent >= 0 ? 'text-success' : 'text-danger' }}">
                                                        {{ number_format($product->profit_margin_percent, 1) }}%
                                                    </span>
                                                    <br>
                                                    <small class="text-muted">
                                                        KES {{ number_format($product->profit_margin, 2) }}
                                                    </small>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Tax Status:</th>
                                                <td class="text-end">
                                                    @if($product->has_vat && $product->tax)
                                                    <span class="badge bg-success">{{ $product->tax->name }} ({{ $product->tax->rate }}%)</span>
                                                    @else
                                                    <span class="badge bg-secondary">Tax Exempt</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Last Price Update:</th>
                                                <td class="text-end">
                                                    @if($product->price_last_updated_at)
                                                    {{ $product->price_last_updated_at->format('M d, Y H:i') }}
                                                    @else
                                                    <span class="text-muted">Never</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        <div class="mt-4">
                                            <button class="btn btn-outline-primary w-100"
                                                    data-bs-toggle="modal" data-bs-target="#adjustPriceModal">
                                                <i class="bx bx-edit"></i> Adjust Prices
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-history"></i> Recent Price Changes
                                    </div>
                                    <div class="card-body">
                                        @if($product->priceHistories->count() > 0)
                                        <div class="timeline">
                                            @foreach($product->priceHistories as $history)
                                            <div class="timeline-item">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong>{{ Str::title(str_replace('_', ' ', $history->price_type)) }}</strong>
                                                        <p class="mb-1 small text-muted">
                                                            {{ $history->change_reason }}
                                                            @if($history->notes)
                                                            - {{ $history->notes }}
                                                            @endif
                                                        </p>
                                                    </div>
                                                    <div class="text-end">
                                                        <div>
                                                            <span class="text-muted"><s>KES {{ number_format($history->old_price, 2) }}</s></span>
                                                            <span class="fw-bold text-primary"> → KES {{ number_format($history->new_price, 2) }}</span>
                                                        </div>
                                                        <small class="text-muted">
                                                            {{ $history->created_at->format('M d, H:i') }}
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('products.price-history', $product) }}" 
                                               class="btn btn-outline-primary btn-sm">
                                                View All Price History
                                            </a>
                                        </div>
                                        @else
                                        <div class="text-center py-4">
                                            <i class="bx bx-dollar-circle display-4 text-muted mb-3"></i>
                                            <p class="text-muted">No price changes recorded yet.</p>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Information Tab -->
                    <div class="tab-pane fade" id="tax" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-receipt"></i> Tax Details
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%">Tax Status:</th>
                                                <td>
                                                    <span class="badge bg-{{ $product->has_vat ? 'success' : 'secondary' }}">
                                                        {{ $product->has_vat ? 'Taxable' : 'Tax Exempt' }}
                                                    </span>
                                                </td>
                                            </tr>
                                            @if($product->has_vat && $product->tax)
                                            <tr>
                                                <th>Tax Name:</th>
                                                <td>{{ $product->tax->name }}</td>
                                            </tr>
                                            <tr>
                                                <th>Tax Rate:</th>
                                                <td class="fw-bold">{{ $product->tax->rate }}%</td>
                                            </tr>
                                            <tr>
                                                <th>Tax Code:</th>
                                                <td><code>{{ $product->tax->code ?? 'N/A' }}</code></td>
                                            </tr>
                                            <tr>
                                                <th>Tax Description:</th>
                                                <td>{{ $product->tax->description ?? 'No description' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Is Active:</th>
                                                <td>
                                                    <span class="badge bg-{{ $product->tax->is_active ? 'success' : 'danger' }}">
                                                        {{ $product->tax->is_active ? 'Active' : 'Inactive' }}
                                                    </span>
                                                </td>
                                            </tr>
                                            @else
                                            <tr>
                                                <td colspan="2" class="text-center py-4">
                                                    <i class="bx bx-no-entry display-4 text-muted mb-3"></i>
                                                    <h5 class="text-muted">Tax Exempt Product</h5>
                                                    <p class="text-muted">This product is not subject to any taxes.</p>
                                                    <a href="{{ route('products.edit', $product) }}#tax" class="btn btn-outline-primary">
                                                        <i class="bx bx-edit"></i> Configure Tax
                                                    </a>
                                                </td>
                                            </tr>
                                            @endif
                                        </table>
                                        
                                        @if($product->has_vat && $product->tax)
                                        <div class="mt-4">
                                            <h6>Quick Actions</h6>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <button class="btn btn-outline-primary w-100 btn-sm"
                                                            onclick="location.href='{{ route('taxes.edit', $product->tax) }}'">
                                                        <i class="bx bx-cog"></i> Edit Tax Rate
                                                    </button>
                                                </div>
                                                <div class="col-6">
                                                    <button class="btn btn-outline-secondary w-100 btn-sm"
                                                            onclick="location.href='{{ route('taxes.show', $product->tax) }}'">
                                                        <i class="bx bx-show"></i> View Tax Details
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-calculator"></i> Tax Calculator
                                    </div>
                                    <div class="card-body">
                                        @if($product->has_vat && $product->tax && isset($taxExamples))
                                        <div class="mb-4">
                                            <label class="form-label">Enter Quantity</label>
                                            <input type="number" id="taxQuantity" class="form-control" 
                                                   min="1" value="1" step="1">
                                        </div>
                                        
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>Description</th>
                                                        <th class="text-end">Amount (KES)</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>Unit Price (Excl. Tax)</td>
                                                        <td class="text-end" id="unitPriceExclTax">
                                                            {{ number_format($product->final_price, 2) }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>Tax Rate ({{ $product->tax->rate }}%)</td>
                                                        <td class="text-end" id="taxRateDisplay">
                                                            {{ $product->tax->rate }}%
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>Tax Amount per Unit</td>
                                                        <td class="text-end" id="taxPerUnit">
                                                            {{ number_format($taxExamples['single_unit']['tax_amount'], 2) }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>Unit Price (Incl. Tax)</td>
                                                        <td class="text-end fw-bold" id="unitPriceInclTax">
                                                            {{ number_format($taxExamples['single_unit']['price_with_tax'], 2) }}
                                                        </td>
                                                    </tr>
                                                    <tr class="table-active">
                                                        <td><strong>Total Price for <span id="quantityLabel">1</span> unit(s)</strong></td>
                                                        <td class="text-end fw-bold" id="totalPriceExclTax">
                                                            {{ number_format($product->final_price, 2) }}
                                                        </td>
                                                    </tr>
                                                    <tr class="table-active">
                                                        <td><strong>Total Tax Amount</strong></td>
                                                        <td class="text-end fw-bold text-danger" id="totalTaxAmount">
                                                            {{ number_format($taxExamples['single_unit']['tax_amount'], 2) }}
                                                        </td>
                                                    </tr>
                                                    <tr class="table-success">
                                                        <td><strong>Total Amount (Incl. Tax)</strong></td>
                                                        <td class="text-end fw-bold text-success" id="totalPriceInclTax">
                                                            {{ number_format($taxExamples['single_unit']['price_with_tax'], 2) }}
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                        <div class="mt-3">
                                            <small class="text-muted">
                                                <i class="bx bx-info-circle"></i>
                                                Tax calculations are based on the final price after discounts.
                                            </small>
                                        </div>
                                        @else
                                        <div class="text-center py-5">
                                            <i class="bx bx-calculator display-4 text-muted mb-3"></i>
                                            <h5 class="text-muted">No Tax Calculator Available</h5>
                                            <p class="text-muted mb-4">This product is tax-exempt.</p>
                                            <a href="{{ route('products.edit', $product) }}#tax" class="btn btn-outline-primary">
                                                <i class="bx bx-edit"></i> Configure Tax
                                            </a>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Tax Examples Section -->
                        @if($product->has_vat && $product->tax && isset($taxExamples))
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-list-check"></i> Common Tax Examples
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="card border mb-3 tax-example-card">
                                                    <div class="card-header bg-light">
                                                        <h6 class="mb-0">Single Unit Sale</h6>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Unit Price:</span>
                                                            <span>KES {{ number_format($taxExamples['single_unit']['price_excl_tax'], 2) }}</span>
                                                        </div>
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Tax ({{ $product->tax->rate }}%):</span>
                                                            <span class="text-danger">KES {{ number_format($taxExamples['single_unit']['tax_amount'], 2) }}</span>
                                                        </div>
                                                        <hr>
                                                        <div class="d-flex justify-content-between fw-bold">
                                                            <span>Total:</span>
                                                            <span class="text-success">KES {{ number_format($taxExamples['single_unit']['price_with_tax'], 2) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card border mb-3 tax-example-card">
                                                    <div class="card-header bg-light">
                                                        <h6 class="mb-0">Bulk Sale (10 Units)</h6>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Subtotal:</span>
                                                            <span>KES {{ number_format($taxExamples['ten_units']['price_excl_tax'], 2) }}</span>
                                                        </div>
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Tax ({{ $product->tax->rate }}%):</span>
                                                            <span class="text-danger">KES {{ number_format($taxExamples['ten_units']['tax_amount'], 2) }}</span>
                                                        </div>
                                                        <hr>
                                                        <div class="d-flex justify-content-between fw-bold">
                                                            <span>Total:</span>
                                                            <span class="text-success">KES {{ number_format($taxExamples['ten_units']['price_with_tax'], 2) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="alert alert-info mt-3">
                                            <i class="bx bx-info-circle"></i>
                                            <strong>Note:</strong> Tax is calculated on the final sale price. 
                                            Discounts and promotions are applied before tax calculation.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Expiry Tracking Tab -->
                    @if($product->has_expiry)
                    <div class="tab-pane fade" id="expiry" role="tabpanel">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="info-card">
                                    <div class="card-header">
                                        <i class="bx bx-calendar-exclamation"></i> Expiry Summary
                                    </div>
                                    <div class="card-body">
                                        <div class="row mb-4">
                                            <div class="col-md-6">
                                                <div class="alert alert-{{ $expirySummary['alert_level'] == 'critical' ? 'danger' : ($expirySummary['alert_level'] == 'warning' ? 'warning' : 'success') }}">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-shrink-0">
                                                            <i class="bx bx-{{ $expirySummary['alert_level'] == 'critical' ? 'error' : ($expirySummary['alert_level'] == 'warning' ? 'time-five' : 'check-circle') }} display-6"></i>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <h5 class="alert-heading">
                                                                @if($expirySummary['alert_level'] == 'critical')
                                                                    Expired Stock Detected
                                                                @elseif($expirySummary['alert_level'] == 'warning')
                                                                    Stock Expiring Soon
                                                                @else
                                                                    Expiry Status Normal
                                                                @endif
                                                            </h5>
                                                            <p class="mb-0">
                                                                @if($expirySummary['alert_level'] == 'critical')
                                                                {{ $expirySummary['expired_quantity'] }} units have expired.
                                                                @elseif($expirySummary['alert_level'] == 'warning')
                                                                {{ $expirySummary['expiring_soon_quantity'] }} units expiring within {{ $product->expiry_warning_days }} days.
                                                                @else
                                                                All stock is valid.
                                                                @endif
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="stat-card h-100">
                                                    <div class="stat-value text-primary">{{ $expirySummary['valid_quantity'] }}</div>
                                                    <div class="stat-label">Valid Stock Quantity</div>
                                                    <div class="mt-3">
                                                        <div class="d-flex justify-content-between small">
                                                            <span class="text-danger">Expired: {{ $expirySummary['expired_quantity'] }}</span>
                                                            <span class="text-warning">Expiring: {{ $expirySummary['expiring_soon_quantity'] }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        @if($expirySummary['alert_level'] != 'normal')
                                        <div class="alert alert-info">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div>
                                                    <i class="bx bx-info-circle"></i>
                                                    <strong>Recommended Action:</strong>
                                                    Consider setting discounts for expiring stock.
                                                </div>
                                                <button class="btn btn-outline-primary btn-sm"
                                                        data-bs-toggle="modal" data-bs-target="#setExpiryDiscountModal">
                                                    <i class="bx bx-dollar"></i> Set Discount
                                                </button>
                                            </div>
                                        </div>
                                        @endif

                                        <div class="mt-4">
                                            <h6>Expiry Settings</h6>
                                            <table class="table table-borderless">
                                                <tr>
                                                    <th width="40%">Expiry Tracking:</th>
                                                    <td>
                                                        <span class="badge bg-{{ $product->has_expiry ? 'success' : 'secondary' }}">
                                                            {{ $product->has_expiry ? 'Enabled' : 'Disabled' }}
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Batch Tracking:</th>
                                                    <td>
                                                        <span class="badge bg-{{ $product->track_batches ? 'success' : 'secondary' }}">
                                                            {{ $product->track_batches ? 'Enabled' : 'Disabled' }}
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Expiry Warning Days:</th>
                                                    <td>{{ $product->expiry_warning_days }} days</td>
                                                </tr>
                                                <tr>
                                                    <th>Last Expiry Check:</th>
                                                    <td>
                                                        @if($product->stock_last_updated_at)
                                                        {{ $product->stock_last_updated_at->format('M d, Y H:i') }}
                                                        @else
                                                        <span class="text-muted">Never</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-card h-100">
                                    <div class="card-header">
                                        <i class="bx bx-line-chart"></i> Expiry Distribution
                                    </div>
                                    <div class="card-body">
                                        <canvas id="expiryChart" height="250"></canvas>
                                        <div class="mt-3">
                                            <div class="row text-center">
                                                <div class="col-4">
                                                    <div class="fw-bold text-success">{{ $expirySummary['valid_quantity'] }}</div>
                                                    <small class="text-muted">Valid</small>
                                                </div>
                                                <div class="col-4">
                                                    <div class="fw-bold text-warning">{{ $expirySummary['expiring_soon_quantity'] }}</div>
                                                    <small class="text-muted">Expiring Soon</small>
                                                </div>
                                                <div class="col-4">
                                                    <div class="fw-bold text-danger">{{ $expirySummary['expired_quantity'] }}</div>
                                                    <small class="text-muted">Expired</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Stock Modal -->
<div class="modal fade" id="addStockModal" tabindex="-1" aria-labelledby="addStockModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('products.add-stock', $product) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addStockModalLabel">
                        <i class="bx bx-plus"></i> Add Stock to {{ $product->name }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Quantity *</label>
                        <input type="number" name="quantity" class="form-control" min="1" required 
                               placeholder="Enter quantity to add">
                    </div>
                    
                    @if($product->track_batches && $product->has_expiry)
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="use_batch" 
                                   id="useBatch" value="1" checked>
                            <label class="form-check-label" for="useBatch">
                                Add to specific batch (required for expiry tracking)
                            </label>
                        </div>
                    </div>
                    
                    <div id="batchFields">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Batch Number *</label>
                                <input type="text" name="batch_data[batch_number]" class="form-control" 
                                       value="{{ 'BATCH-' . date('Ymd') . '-' . strtoupper(substr(md5(uniqid()), 0, 6)) }}" 
                                       required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Expiry Date *</label>
                                <input type="date" name="batch_data[expiry_date]" class="form-control" 
                                       min="{{ date('Y-m-d') }}" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Manufacture Date</label>
                                <input type="date" name="batch_data[manufacture_date]" class="form-control" 
                                       max="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cost Price</label>
                                <input type="number" step="0.01" name="batch_data[cost_price]" 
                                       class="form-control" value="{{ $product->cost_price }}">
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Reason *</label>
                        <select name="reason" class="form-select" required>
                            <option value="purchase">Purchase/Replenishment</option>
                            <option value="return">Customer Return</option>
                            <option value="adjustment">Stock Adjustment</option>
                            <option value="transfer">Transfer In</option>
                            <option value="production">Production</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Additional notes about this stock addition"></textarea>
                    </div>
                    
                    @if(!$product->track_batches)
                    <div class="alert alert-info">
                        <i class="bx bx-info-circle"></i>
                        This product doesn't use batch tracking. Stock will be added to general inventory.
                    </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Stock</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Remove Stock Modal -->
<div class="modal fade" id="removeStockModal" tabindex="-1" aria-labelledby="removeStockModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('products.remove-stock', $product) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="removeStockModalLabel">
                        <i class="bx bx-minus"></i> Remove Stock from {{ $product->name }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info mb-3">
                        <i class="bx bx-info-circle"></i>
                        <strong>Available Stock:</strong> {{ $product->available_stock }} units
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Quantity *</label>
                        <input type="number" name="quantity" class="form-control" 
                               min="1" max="{{ $product->available_stock }}" required 
                               placeholder="Enter quantity to remove">
                    </div>
                    
                    @if($product->track_batches && $product->batches()->where('current_quantity', '>', 0)->exists())
                    <div class="mb-3">
                        <label class="form-label">Removal Method</label>
                        <select name="method" class="form-select">
                            <option value="fifo">FIFO (First In, First Out)</option>
                            @if($product->has_expiry)
                            <option value="fefo">FEFO (First Expired, First Out)</option>
                            @endif
                            <option value="manual">Manual Selection</option>
                        </select>
                        <div class="form-text">
                            @if($product->has_expiry)
                            FEFO is recommended for expiry-tracked products
                            @else
                            FIFO is recommended for non-expiry products
                            @endif
                        </div>
                    </div>
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Reason *</label>
                        <select name="reason" class="form-select" required>
                            <option value="sale">Sale</option>
                            <option value="damaged">Damaged/Defective</option>
                            <option value="return_to_supplier">Return to Supplier</option>
                            <option value="adjustment">Stock Adjustment</option>
                            <option value="transfer">Transfer Out</option>
                            <option value="sample">Sample/Test</option>
                            <option value="theft">Theft/Loss</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Reference Number</label>
                        <input type="text" name="reference_number" class="form-control" 
                               placeholder="Optional reference number (e.g., Sale #, RMA #)">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Additional notes about this stock removal"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Remove Stock</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Quick Add Stock Modal -->
<div class="modal fade" id="quickAddStockModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form action="{{ route('products.add-stock', $product) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Quick Add Stock</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="number" name="quantity" class="form-control" min="1" value="1" required>
                    </div>
                    <input type="hidden" name="reason" value="quick_adjustment">
                    <input type="hidden" name="notes" value="Quick stock addition">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Quick Remove Stock Modal -->
<div class="modal fade" id="quickRemoveStockModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form action="{{ route('products.remove-stock', $product) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Quick Remove Stock</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="number" name="quantity" class="form-control" 
                               min="1" max="{{ $product->available_stock }}" value="1" required>
                    </div>
                    <input type="hidden" name="reason" value="quick_adjustment">
                    <input type="hidden" name="notes" value="Quick stock removal">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Remove</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Adjust Price Modal -->
<div class="modal fade" id="adjustPriceModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="adjustPriceForm">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Adjust Product Price</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Price Type</label>
                        <select name="price_type" class="form-select" required>
                            <option value="sale_price">Sale Price</option>
                            <option value="cost_price">Cost Price</option>
                            <option value="wholesale_price">Wholesale Price</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Update Type</label>
                        <select name="update_type" class="form-select" required>
                            <option value="set">Set to specific value</option>
                            <option value="increase">Increase by amount</option>
                            <option value="decrease">Decrease by amount</option>
                            <option value="percentage">Change by percentage</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Value</label>
                        <input type="number" name="value" class="form-control" step="0.01" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Change Reason *</label>
                        <input type="text" name="change_reason" class="form-control" required 
                               placeholder="e.g., Supplier price change, promotion, etc.">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Additional notes about this price change"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Price</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Set Expiry Discount Modal -->
@if($product->has_expiry)
<div class="modal fade" id="setExpiryDiscountModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('products.set-expiry-discount', $product) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Set Discount for Expiring Stock</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="bx bx-error-circle"></i>
                        <strong>Expiring Stock Detected:</strong>
                        {{ $expirySummary['expiring_soon_quantity'] }} units expiring within {{ $product->expiry_warning_days }} days.
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Discount Type</label>
                        <select name="discount_type" class="form-select" required>
                            <option value="percent">Percentage Discount</option>
                            <option value="amount">Fixed Amount Discount</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Discount Value</label>
                        <input type="number" name="discount_value" class="form-control" step="0.01" required 
                               placeholder="Enter discount value">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Discount Reason *</label>
                        <input type="text" name="discount_reason" class="form-control" required 
                               value="Expiring stock clearance">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" class="form-control" value="{{ date('Y-m-d') }}">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">End Date</label>
                        <input type="date" name="end_date" class="form-control" 
                               value="{{ date('Y-m-d', strtotime('+30 days')) }}">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Additional notes about this discount"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">Set Discount</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

<!-- Adjust Batch Stock Modal -->
<div class="modal fade" id="adjustBatchStockModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="adjustBatchStockForm" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Adjust Batch Stock</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info mb-3">
                        <i class="bx bx-info-circle"></i>
                        Adjusting stock for batch: <strong id="batchNumberLabel"></strong>
                        <br>Current quantity: <strong id="currentQuantityLabel"></strong>
                    </div>
                    
                    <input type="hidden" name="batch_id" id="batchIdInput">
                    
                    <div class="mb-3">
                        <label class="form-label">Adjustment Type</label>
                        <select name="adjustment_type" class="form-select" required>
                            <option value="add">Add Stock</option>
                            <option value="remove">Remove Stock</option>
                            <option value="set">Set to Specific Quantity</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="number" name="quantity" class="form-control" min="0" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Reason *</label>
                        <select name="reason" class="form-select" required>
                            <option value="correction">Quantity Correction</option>
                            <option value="damaged">Damaged Stock</option>
                            <option value="quality_control">Quality Control</option>
                            <option value="theft">Theft/Loss</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Additional notes about this adjustment"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Apply Adjustment</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('script')
<!-- Include Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function() {
    // Tooltip initialization
    $('[data-bs-toggle="tooltip"]').tooltip();

    // Tab persistence
    const urlParams = new URLSearchParams(window.location.search);
    const activeTab = urlParams.get('tab');
    if (activeTab) {
        const tabTrigger = document.querySelector(`[data-bs-target="#${activeTab}"]`);
        if (tabTrigger) {
            new bootstrap.Tab(tabTrigger).show();
        }
    }

    // Tab click tracking
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function(e) {
        const tabId = $(e.target).attr('data-bs-target').replace('#', '');
        history.replaceState(null, null, `?tab=${tabId}`);
    });

    // Expiry Chart
    @if($product->has_expiry)
    const expiryCtx = document.getElementById('expiryChart').getContext('2d');
    const expiryChart = new Chart(expiryCtx, {
        type: 'doughnut',
        data: {
            labels: ['Valid Stock', 'Expiring Soon', 'Expired'],
            datasets: [{
                data: [
                    {{ $expirySummary['valid_quantity'] }},
                    {{ $expirySummary['expiring_soon_quantity'] }},
                    {{ $expirySummary['expired_quantity'] }}
                ],
                backgroundColor: [
                    '#10b981',
                    '#f59e0b',
                    '#ef4444'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                }
            }
        }
    });
    @endif

    // Tax Calculator
    @if($product->has_vat && $product->tax && isset($taxExamples))
    const taxRate = {{ $product->tax->rate }};
    const unitPriceExclTax = {{ $product->final_price }};
    
    function updateTaxCalculation() {
        const quantity = parseInt($('#taxQuantity').val()) || 1;
        
        // Update quantity label
        $('#quantityLabel').text(quantity);
        
        // Calculate totals
        const totalExclTax = unitPriceExclTax * quantity;
        const totalTaxAmount = totalExclTax * (taxRate / 100);
        const totalInclTax = totalExclTax + totalTaxAmount;
        const taxPerUnit = unitPriceExclTax * (taxRate / 100);
        
        // Update displays
        $('#totalPriceExclTax').text('KES ' + totalExclTax.toFixed(2));
        $('#totalTaxAmount').text('KES ' + totalTaxAmount.toFixed(2));
        $('#totalPriceInclTax').text('KES ' + totalInclTax.toFixed(2));
        $('#taxPerUnit').text('KES ' + taxPerUnit.toFixed(2));
        $('#unitPriceInclTax').text('KES ' + (unitPriceExclTax + taxPerUnit).toFixed(2));
    }
    
    // Initial calculation
    updateTaxCalculation();
    
    // Update on quantity change
    $('#taxQuantity').on('input', function() {
        updateTaxCalculation();
    });
    @endif

    // Adjust Price Form
    $('#adjustPriceForm').submit(function(e) {
        e.preventDefault();
        
        const formData = $(this).serialize();
        
        $.ajax({
            url: '{{ route("products.pricing.update", $product) }}',            type: 'POST',
            data: formData,
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Price Updated',
                    text: response.message
                }).then(() => {
                    location.reload();
                });
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Update Failed',
                    text: xhr.responseJSON?.message || 'Failed to update price'
                });
            }
        });
    });

    // Adjust Batch Stock Form
    $('#adjustBatchStockForm').submit(function(e) {
        e.preventDefault();
        
        const batchId = $('#batchIdInput').val();
        const formData = $(this).serialize();
        
        $.ajax({
            url: `/batches/${batchId}/adjust-stock`,
            type: 'POST',
            data: formData,
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Stock Adjusted',
                    text: response
                }).then(() => {
                    location.reload();
                });
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Adjustment Failed',
                    text: xhr.responseJSON?.message || 'Failed to adjust stock'
                });
            }
        });
    });

    // Set batch adjustment data
    window.setBatchAdjustmentData = function(element) {
        const batchId = $(element).data('batch-id');
        const batchNumber = $(element).data('batch-number');
        const currentQuantity = $(element).data('current-quantity');
        
        $('#batchIdInput').val(batchId);
        $('#batchNumberLabel').text(batchNumber);
        $('#currentQuantityLabel').text(currentQuantity);
        $('#adjustBatchStockForm').attr('action', `/batches/${batchId}/adjust-stock`);
    };

    // Toggle batch fields
    $('#useBatch').change(function() {
        if ($(this).is(':checked')) {
            $('#batchFields').show();
            $('#batchFields input, #batchFields select').prop('required', true);
        } else {
            $('#batchFields').hide();
            $('#batchFields input, #batchFields select').prop('required', false);
        }
    });

    // Confirm delete
    window.confirmDelete = function() {
        Swal.fire({
            title: 'Delete Product?',
            text: "This will delete the product and all associated data. This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $('#deleteForm').submit();
            }
        });
    };

    // Real-time stock updates
    function updateStockInfo() {
        $.ajax({
            url: '{{ route("products.search") }}',
            type: 'GET',
            data: {
                q: '{{ $product->id }}',
                check_stock: true
            },
            success: function(response) {
                if (response.stock !== undefined) {
                    $('.stock-value').text(response.stock);
                    $('.available-stock-value').text(response.available_stock);
                    
                    // Update stock status badge
                    $('.stock-status-badge').removeClass('stock-in_stock stock-low_stock stock-out_of_stock');
                    $('.stock-status-badge').addClass('stock-' + response.stock_status);
                    $('.stock-status-badge').text(response.stock_status.replace('_', ' ').toUpperCase());
                }
            }
        });
    }

    // Update stock every 30 seconds
    setInterval(updateStockInfo, 30000);

    // Keyboard shortcuts
    $(document).keydown(function(e) {
        // Ctrl/Cmd + S to add stock
        if ((e.ctrlKey || e.metaKey) && e.key === 's') {
            e.preventDefault();
            $('#addStockModal').modal('show');
        }
        
        // Ctrl/Cmd + R to remove stock
        if ((e.ctrlKey || e.metaKey) && e.key === 'r') {
            e.preventDefault();
            $('#removeStockModal').modal('show');
        }
        
        // Ctrl/Cmd + P to adjust price
        if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
            e.preventDefault();
            $('#adjustPriceModal').modal('show');
        }
        
        // Ctrl/Cmd + T to go to tax tab
        if ((e.ctrlKey || e.metaKey) && e.key === 't') {
            e.preventDefault();
            $('#tax-tab').tab('show');
        }
    });
});
</script>
@endsection