@extends('layouts.app')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Products</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('batches.index') }}">Batches</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Expiry Alerts</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('batches.index') }}" class="btn btn-outline-secondary">
                    <i class="bx bx-arrow-back"></i> Back to Batches
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Expiry Alerts</h5>
                        <p class="card-text">Showing batches expiring within {{ $days }} days</p>
                        
                        <form method="GET" action="{{ route('batches.expiry-alerts') }}" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Days Threshold</label>
                                <select name="days" class="form-select" onchange="this.form.submit()">
                                    <option value="7" {{ $days == 7 ? 'selected' : '' }}>7 Days</option>
                                    <option value="15" {{ $days == 15 ? 'selected' : '' }}>15 Days</option>
                                    <option value="30" {{ $days == 30 ? 'selected' : '' }}>30 Days</option>
                                    <option value="60" {{ $days == 60 ? 'selected' : '' }}>60 Days</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Severity</label>
                                <select name="severity" class="form-select" onchange="this.form.submit()">
                                    <option value="">All</option>
                                    <option value="expired" {{ request('severity') == 'expired' ? 'selected' : '' }}>Expired</option>
                                    <option value="critical" {{ request('severity') == 'critical' ? 'selected' : '' }}>Critical (≤7 days)</option>
                                    <option value="warning" {{ request('severity') == 'warning' ? 'selected' : '' }}>Warning (8-30 days)</option>
                                </select>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="row row-cols-1 row-cols-md-4 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-danger">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Expired</p>
                                <h4 class="my-1">{{ $stats['expired'] }}</h4>
                            </div>
                            <div class="widgets-icons bg-light-danger text-danger ms-auto">
                                <i class="bx bx-error-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Critical</p>
                                <h4 class="my-1">{{ $stats['critical'] }}</h4>
                            </div>
                            <div class="widgets-icons bg-light-warning text-warning ms-auto">
                                <i class="bx bx-time"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Warning</p>
                                <h4 class="my-1">{{ $stats['warning'] }}</h4>
                            </div>
                            <div class="widgets-icons bg-light-info text-info ms-auto">
                                <i class="bx bx-alarm"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Value</p>
                                <h4 class="my-1">${{ number_format($stats['total_value'], 2) }}</h4>
                            </div>
                            <div class="widgets-icons bg-light-success text-success ms-auto">
                                <i class="bx bx-dollar-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Expiring Batches Table -->
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">Expiring Batches</h5>
                
                @if($batches->isEmpty())
                    <div class="text-center py-5">
                        <i class="bx bx-check-circle display-4 text-success"></i>
                        <h5 class="mt-3 text-success">No expiring batches found!</h5>
                        <p class="text-muted">All batches are valid for at least {{ $days }} more days.</p>
                    </div>
                @else
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Batch</th>
                                    <th>Product</th>
                                    <th>Expiry Date</th>
                                    <th>Days Left</th>
                                    <th>Quantity</th>
                                    <th>Cost Value</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($batches as $batch)
                                    @php
                                        $daysLeft = $batch->expiry_date ? $batch->expiry_date->diffInDays(now()) : 999;
                                        $status = 'success';
                                        if ($daysLeft < 0) {
                                            $status = 'danger';
                                        } elseif ($daysLeft <= 7) {
                                            $status = 'warning';
                                        }
                                    @endphp
                                    <tr class="table-{{ $status }}">
                                        <td>
                                            <strong>{{ $batch->batch_number }}</strong>
                                        </td>
                                        <td>
                                            <a href="{{ route('products.show', $batch->product) }}" class="text-dark">
                                                {{ $batch->product->name }}
                                            </a>
                                        </td>
                                        <td>
                                            {{ $batch->expiry_date->format('Y-m-d') }}
                                        </td>
                                        <td>
                                            @if($daysLeft < 0)
                                                <span class="badge bg-danger">Expired {{ abs($daysLeft) }} days ago</span>
                                            @else
                                                {{ $daysLeft }} days
                                            @endif
                                        </td>
                                        <td>{{ $batch->current_quantity }}</td>
                                        <td>${{ number_format($batch->current_quantity * $batch->batch_cost_price, 2) }}</td>
                                        <td>
                                            @if($daysLeft < 0)
                                                <span class="badge bg-danger">Expired</span>
                                            @elseif($daysLeft <= 7)
                                                <span class="badge bg-warning">Critical</span>
                                            @else
                                                <span class="badge bg-info">Warning</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <a href="{{ route('batches.show', $batch) }}" class="btn btn-outline-info btn-sm">
                                                    <i class="bx bx-show"></i>
                                                </a>
                                                @if($daysLeft <= 30 && $batch->current_quantity > 0)
                                                <button type="button" class="btn btn-outline-warning btn-sm set-expiry-discount"
                                                        data-batch-id="{{ $batch->id }}"
                                                        data-product-id="{{ $batch->product_id }}">
                                                    <i class="bx bx-tag"></i>
                                                </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <div class="pagination-info">
                            Showing {{ $batches->firstItem() }} to {{ $batches->lastItem() }} of {{ $batches->total() }} batches
                        </div>
                        <nav>
                            {{ $batches->withQueryString()->links() }}
                        </nav>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Set expiry discount
        $('.set-expiry-discount').click(function() {
            const batchId = $(this).data('batch-id');
            const productId = $(this).data('product-id');
            
            Swal.fire({
                title: 'Set Expiry Discount',
                input: 'number',
                inputLabel: 'Discount Percentage',
                inputPlaceholder: 'Enter discount %',
                inputAttributes: {
                    step: '0.01',
                    min: '0',
                    max: '100'
                },
                showCancelButton: true,
                confirmButtonText: 'Apply Discount',
                cancelButtonText: 'Cancel',
                inputValidator: (value) => {
                    if (!value || parseFloat(value) <= 0 || parseFloat(value) > 100) {
                        return 'Please enter a valid percentage (0-100)';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `{{ route('products.set-expiry-discount', ':id') }}`.replace(':id', productId),
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            discount_type: 'percent',
                            discount_value: result.value,
                            discount_reason: 'Batch expiry discount',
                            batch_id: batchId
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Discount Applied',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'Failed to apply discount'
                            });
                        }
                    });
                }
            });
        });
    });
</script>
@endsection