<!-- resources/views/pos/components/pos-payment-modal.blade.php -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="bx bx-credit-card me-2"></i>Complete Payment</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body p-4">
                <!-- Payment Summary Banner -->
                <div class="payment-summary-banner mb-4 p-3" 
                     style="background: linear-gradient(135deg, #1a365d 0%, #2a4365 100%); 
                            border-radius: 10px; color: white;">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <div class="d-flex align-items-center">
                                <div class="fs-2 fw-bold me-3" id="paymentTotalAmount">KES 0.00</div>
                                <div>
                                    <div class="small opacity-75">TOTAL AMOUNT</div>
                                    <div class="small">
                                        <span id="paymentItemCount">0</span> items • 
                                        <span id="paymentCustomer">Walk-in</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="small opacity-75 mb-1">INVOICE NO</div>
                            <div class="fw-bold" id="paymentInvoiceNo">POS-{{ date('Ymd') }}-001</div>
                        </div>
                    </div>
                </div>
                
                <!-- VAT Summary Section - Added Here -->
                <div class="payment-summary-section mb-4 p-3 border rounded bg-light">
                    <h6 class="mb-3 text-primary fw-bold">
                        <i class="bx bx-receipt me-2"></i>Invoice Breakdown
                    </h6>
                    <div class="row">
                        <div class="col-md-8">
                            <!-- VAT breakdown lines -->
                            <div class="d-flex justify-content-between mb-1">
                                <span>Subtotal:</span>
                                <span id="paymentSubtotalAmount">KES 0.00</span>
                            </div>
                            
                            <div class="d-flex justify-content-between mb-1">
                                <span>Discount:</span>
                                <span id="paymentDiscountAmount" class="text-danger">-KES 0.00</span>
                            </div>
                            
                            <div class="d-flex justify-content-between mb-1">
                                <span class="fw-semibold">VAT (16%):</span>
                                <span id="paymentVATAmount" class="fw-semibold">KES 0.00</span>
                            </div>
                            
                            <div id="paymentVATBreakdown" class="mt-2 d-none">
                                <!-- VAT breakdown will be inserted here -->
                            </div>
                        </div>
                        <div class="col-md-4 text-end">
                            <hr class="my-2 d-md-none">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold">Total:</span>
                                <span id="paymentTotalAmountSummary" class="fw-bold fs-4 text-primary">KES 0.00</span>
                            </div>
                            <small class="text-muted d-block mt-1">Inclusive of VAT where applicable</small>
                        </div>
                    </div>
                </div>
                
                <!-- Progress Steps -->
                <div class="payment-progress mb-4">
                    <div class="wizard-progress">
                        <div class="progress-step">
                            <div class="step-circle active" data-step="1">1</div>
                            <div class="step-label active">Method</div>
                        </div>
                        <div class="progress-step">
                            <div class="step-circle" data-step="2">2</div>
                            <div class="step-label">Details</div>
                        </div>
                        <div class="progress-step">
                            <div class="step-circle" data-step="3">3</div>
                            <div class="step-label">Confirm</div>
                        </div>
                    </div>
                </div>
                
                <!-- Step 1: Payment Method Selection -->
                <div class="payment-step active" id="step1">
                    <h6 class="mb-3 text-muted">SELECT PAYMENT METHOD</h6>
                    <div class="payment-methods-grid">
                        <!-- Cash -->
                        <div class="payment-method-card" data-method="cash" onclick="selectPaymentMethod('cash')">
                            <div class="method-icon bg-success">
                                <i class="bx bx-money"></i>
                            </div>
                            <div class="method-info">
                                <div class="method-name">Cash</div>
                                <div class="method-desc">Pay with cash</div>
                                <div class="method-info-tip">+ Quick • Exact Change</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>
                        
                        <!-- M-Pesa -->
                        <div class="payment-method-card" data-method="mpesa">
                            <div class="method-icon" style="background: #abdbecff;">
                                <img src="{{ asset('assets/images/mpesa.svg') }}" 
                                    alt="M-Pesa Logo" 
                                    style="width:32px; height:32px;">
                            </div>
                            <div class="method-info">
                                <div class="method-name">M-Pesa</div>
                                <div class="method-desc">Mobile money</div>
                                <div class="method-info-tip">+ STK Push • Manual</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>

                        <!-- Card -->
                        <div class="payment-method-card" data-method="card" onclick="selectPaymentMethod('card')">
                            <div class="method-icon" style="background: #4169E1;">
                                <i class="bx bx-credit-card"></i>
                            </div>
                            <div class="method-info">
                                <div class="method-name">Card</div>
                                <div class="method-desc">Credit/Debit card</div>
                                <div class="method-info-tip">+ Visa • MasterCard • Amex</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>
                        
                        <!-- Credit Sale -->
                        <div class="payment-method-card" data-method="credit" onclick="selectPaymentMethod('credit')">
                            <div class="method-icon" style="background: #FFA500;">
                                <i class="bx bx-credit-card-front"></i>
                            </div>
                            <div class="method-info">
                                <div class="method-name">Credit Sale</div>
                                <div class="method-desc">Pay later</div>
                                <div class="method-info-tip">+ 15-90 Days • Customer Credit</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>
                        
                        <!-- Split Payment -->
                        <div class="payment-method-card" data-method="multiple" onclick="selectPaymentMethod('multiple')">
                            <div class="method-icon" style="background: #9B59B6;">
                                <i class="bx bx-layer"></i>
                            </div>
                            <div class="method-info">
                                <div class="method-name">Split Payment</div>
                                <div class="method-desc">Multiple methods</div>
                                <div class="method-info-tip">+ Cash + M-Pesa + Card</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>
                        
                        <!-- Bank Transfer -->
                        <div class="payment-method-card" data-method="bank" onclick="selectPaymentMethod('bank')">
                            <div class="method-icon" style="background: #27AE60;">
                                <i class="bx bx-bank"></i>
                            </div>
                            <div class="method-info">
                                <div class="method-name">Bank Transfer</div>
                                <div class="method-desc">Bank payment</div>
                                <div class="method-info-tip">+ EFT • RTGS • Cheque</div>
                            </div>
                            <div class="method-check"><i class="bx bx-check"></i></div>
                        </div>
                    </div>
                    
                    <!-- Method Selection Tips -->
                    <div class="alert alert-info mt-3">
                        <i class="bx bx-info-circle me-2"></i>
                        <strong>Tips:</strong> Press <kbd>F8</kbd> for Quick Cash, <kbd>F9</kbd> for M-Pesa, 
                        <kbd>ESC</kbd> to cancel
                    </div>
                </div>
                
                <!-- Step 2: Payment Details -->
                <div class="payment-step" id="step2" style="display: none;">
                    <h6 class="mb-3 text-muted">PAYMENT DETAILS</h6>
                    <div id="paymentFormContainer">
                        <!-- Forms will be loaded here dynamically -->
                        <div class="alert alert-info text-center py-5">
                            <i class="bx bx-credit-card fs-1 mb-3"></i>
                            <p>Please select a payment method to continue</p>
                        </div>
                    </div>
                </div>
                
                <!-- Step 3: Confirmation -->
                <div class="payment-step" id="step3" style="display: none;">
                    <h6 class="mb-3 text-muted">CONFIRM PAYMENT</h6>
                    <div class="confirmation-content">
                        <div class="text-center mb-4">
                            <div class="confirmation-icon mb-3">
                                <i class="bx bx-check-circle fs-1 text-success"></i>
                            </div>
                            <h5 class="text-success">Ready to Process Payment</h5>
                            <p class="text-muted">Review all details before completing</p>
                        </div>
                        
                        <div class="confirmation-details">
                            <div class="card mb-3 border-success">
                                <div class="card-body">
                                    <h6 class="card-title mb-3"><i class="bx bx-receipt me-2"></i>Transaction Summary</h6>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="text-muted small">Payment Method</div>
                                            <div class="fw-bold" id="confirmMethod">-</div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="text-muted small">Amount</div>
                                            <div class="fw-bold" id="confirmAmount">KES 0.00</div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="text-muted small">Customer</div>
                                            <div class="fw-bold" id="confirmCustomer">Walk-in Customer</div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="text-muted small">Invoice Number</div>
                                            <div class="fw-bold" id="confirmInvoice">POS-{{ date('Ymd') }}-001</div>
                                        </div>
                                    </div>
                                    
                                    <!-- VAT Details in Confirmation -->
                                    <div class="mt-3 pt-3 border-top">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="text-muted small">Subtotal</div>
                                                <div class="fw-bold" id="confirmSubtotal">KES 0.00</div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="text-muted small">VAT Amount</div>
                                                <div class="fw-bold text-success" id="confirmVAT">KES 0.00</div>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="text-muted" id="confirmVATBreakdown">
                                                <!-- VAT breakdown will be inserted here -->
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Payment Specific Details -->
                            <div id="paymentSpecificDetails" class="mb-3"></div>
                            
                            <!-- Receipt Options -->
                            <div class="receipt-options card">
                                <div class="card-body">
                                    <h6 class="card-title mb-3"><i class="bx bx-printer me-2"></i>Receipt Options</h6>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-check form-switch mb-3">
                                                <input class="form-check-input" type="checkbox" id="printReceipt" checked>
                                                <label class="form-check-label" for="printReceipt">
                                                    <i class="bx bx-printer me-1"></i>Print Receipt
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check form-switch mb-3">
                                                <input class="form-check-input" type="checkbox" id="sendEmail">
                                                <label class="form-check-label" for="sendEmail">
                                                    <i class="bx bx-envelope me-1"></i>Email Receipt
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check form-switch mb-3">
                                                <input class="form-check-input" type="checkbox" id="sendToEtims" checked>
                                                <label class="form-check-label" for="sendToEtims">
                                                    <i class="bx bx-cloud-upload me-1"></i>Send to KRA
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-warning small mb-0">
                                        <i class="bx bx-error-circle me-2"></i>
                                        <strong>Note:</strong> Kenyan law requires all receipts to be sent to KRA eTIMS
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="bx bx-x me-1"></i>Cancel
                </button>
                <button type="button" class="btn btn-outline-primary" id="prevStepBtn" style="display: none;">
                    <i class="bx bx-chevron-left me-1"></i>Back
                </button>
                <button type="button" class="btn btn-primary" id="nextStepBtn">
                    <span id="nextStepText">Next</span>
                    <i class="bx bx-chevron-right ms-1"></i>
                    <span class="spinner-border spinner-border-sm d-none" id="paymentSpinner"></span>
                </button>
                <button type="button" class="btn btn-success" id="completePaymentBtn" style="display: none;">
                    <i class="bx bx-check-circle me-1"></i>Complete Payment
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Hidden Template for VAT Breakdown -->
<template id="vatBreakdownTemplate">
    <div class="vat-breakdown-details mt-2 p-2 bg-white rounded border">
        <div class="d-flex justify-content-between small mb-1">
            <span>Taxable Amount:</span>
            <span class="fw-semibold" id="taxableAmount">KES 0.00</span>
        </div>
        <div class="d-flex justify-content-between small mb-1">
            <span>Non-taxable:</span>
            <span id="nonTaxableAmount">KES 0.00</span>
        </div>
        <div class="vat-rates mt-2">
            <!-- VAT rates will be dynamically added here -->
        </div>
    </div>
    <!-- Include Payment Form Templates -->

</template>
@include('pos.components.payment-forms.cash')
@include('pos.components.payment-forms.mpesa')
@include('pos.components.payment-forms.card')
@include('pos.components.payment-forms.credit')
@include('pos.components.payment-forms.split')
@include('pos.components.payment-forms.bank')
<!-- CSS for the new VAT section -->
<style>
.payment-summary-section {
    border: 1px solid #dee2e6;
    border-left: 4px solid #2a4365;
    background: linear-gradient(to right, #f8f9fa, #ffffff);
}

.payment-summary-section h6 {
    color: #2a4365;
    font-size: 1rem;
}

#paymentVATBreakdown .vat-rate-item {
    border-left: 3px solid #38a169;
    padding-left: 10px;
    margin: 5px 0;
}

#paymentVATBreakdown .vat-rate-item .vat-rate {
    font-weight: 600;
    color: #2d3748;
}

#paymentVATBreakdown .vat-rate-item .vat-amount {
    color: #38a169;
    font-weight: 500;
}

#paymentTotalAmountSummary {
    color: #2a4365;
    text-shadow: 0 1px 2px rgba(0,0,0,0.1);
}

.vat-breakdown-details {
    font-size: 0.85rem;
}

.vat-breakdown-details .vat-rates {
    border-top: 1px dashed #cbd5e0;
    padding-top: 8px;
    margin-top: 8px;
}

.vat-breakdown-details .vat-rate-line {
    display: flex;
    justify-content: space-between;
    padding: 2px 0;
    border-bottom: 1px dotted #e2e8f0;
}

.vat-breakdown-details .vat-rate-line:last-child {
    border-bottom: none;
}
</style>

<!-- Payment VAT Helper Initialization -->
<script>
(function() {
    'use strict';
    
    // Wait for DOM and PaymentVATHelper to be ready
    function initializePaymentVAT() {
        console.log('🔄 Initializing Payment Modal VAT Controller...');
        
        // Check if PaymentVATHelper exists
        if (typeof window.PaymentVATHelper === 'undefined') {
            console.warn('⚠️ PaymentVATHelper not available yet, retrying...');
            setTimeout(initializePaymentVAT, 100);
            return;
        }
        
        // Check if init method exists
        if (typeof window.PaymentVATHelper.init !== 'function') {
            console.error('❌ PaymentVATHelper.init is not a function');
            
            // Create a fallback if needed
            if (window.PaymentVATHelper && typeof window.PaymentVATHelper === 'object') {
                // Add missing init method
                window.PaymentVATHelper.init = function() {
                    console.log('✅ PaymentVATHelper initialized (fallback)');
                    return this;
                };
                
                // Add update method
                window.PaymentVATHelper.updatePaymentModalVAT = function() {
                    console.log('🔄 Fallback VAT update');
                    // Simple fallback logic
                    const totalElement = document.getElementById('paymentTotalAmount');
                    if (totalElement && window.posState && window.posState.cartVATData) {
                        totalElement.textContent = `KES ${window.posState.cartVATData.totalWithVAT || 0}`;
                    }
                };
            }
            
            return;
        }
        
        // Initialize the helper
        try {
            window.PaymentVATHelper.init();
            console.log('✅ Payment Modal VAT Controller initialized');
        } catch (error) {
            console.error('❌ Error initializing PaymentVATHelper:', error);
        }
    }
    
    // Start initialization
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initializePaymentVAT);
    } else {
        setTimeout(initializePaymentVAT, 100);
    }
})();
</script>

<style>
    /* Payment Method Cards */
    .payment-methods-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 15px;
        margin-bottom: 20px;
    }
    
    .payment-method-card {
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        padding: 15px;
        cursor: pointer;
        transition: all 0.3s ease;
        background: white;
        position: relative;
        overflow: hidden;
    }
    
    .payment-method-card:hover {
        border-color: #2a4365;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(42, 67, 101, 0.15);
    }
    
    .payment-method-card.selected {
        border-color: #2a4365;
        background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
        box-shadow: 0 0 0 3px rgba(42, 67, 101, 0.1);
    }
    
    .method-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        margin-bottom: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    
    .method-info { flex: 1; }
    .method-name { 
        font-weight: 700; 
        font-size: 15px; 
        color: #1e293b; 
        margin-bottom: 4px;
    }
    .method-desc { 
        font-size: 13px; 
        color: #64748b; 
        margin-bottom: 6px;
    }
    .method-check { 
        position: absolute;
        top: 10px;
        right: 10px;
        color: #10b981; 
        font-size: 20px; 
        opacity: 0; 
        transition: opacity 0.3s;
    }
    .payment-method-card.selected .method-check { opacity: 1; }
    
    /* Progress Wizard */
    .wizard-progress {
        display: flex;
        justify-content: space-between;
        position: relative;
        margin: 20px 0 30px;
    }
    
    .wizard-progress:before {
        content: '';
        position: absolute;
        top: 20px;
        left: 10%;
        right: 10%;
        height: 3px;
        background: #e2e8f0;
        z-index: 1;
    }
    
    .progress-step { 
        position: relative; 
        z-index: 2; 
        text-align: center; 
        flex: 1; 
    }
    .step-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #e2e8f0;
        color: #64748b;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 8px;
        border: 4px solid white;
        font-weight: bold;
        font-size: 14px;
        transition: all 0.3s;
        position: relative;
        z-index: 2;
    }
    
    .step-circle.active { 
        background: #2a4365; 
        color: white; 
        box-shadow: 0 4px 10px rgba(42, 67, 101, 0.3);
    }
    .step-circle.completed { 
        background: #10b981; 
        color: white; 
        box-shadow: 0 4px 10px rgba(16, 185, 129, 0.3);
    }
    .step-label { 
        font-size: 13px; 
        color: #94a3b8; 
        font-weight: 600; 
        transition: all 0.3s; 
    }
    .step-label.active { 
        color: #2a4365; 
        font-weight: 700; 
    }
    
    /* Form Styles */
    .payment-form {
        animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    .payment-form .form-control-lg {
        font-size: 1.2rem;
        padding: 0.75rem 1rem;
    }
    
    /* Button States */
    #nextStepBtn:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        background-color: #6c757d !important;
        border-color: #6c757d !important;
    }
    
    #nextStepBtn.btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
    }
    
    #nextStepBtn.btn-primary {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .payment-methods-grid { 
            grid-template-columns: repeat(2, 1fr); 
            gap: 10px;
        }
        
        .wizard-progress:before { left: 15%; right: 15%; }
        
        .payment-form .row {
            flex-direction: column;
        }
        
        #paymentModal .modal-dialog {
            margin: 10px;
        }
    }
    
    @media (max-width: 576px) {
        .payment-methods-grid { 
            grid-template-columns: 1fr; 
        }
        
        .wizard-progress:before { display: none; }
        
        .progress-step {
            margin-bottom: 10px;
        }
        
        .step-circle {
            width: 35px;
            height: 35px;
            font-size: 13px;
        }
        
        .method-icon {
            width: 40px;
            height: 40px;
            font-size: 20px;
        }
        
        .method-name { font-size: 14px; }
        .method-desc { font-size: 12px; }
    }
</style>