<div class="modal fade" id="discountModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="bx bx-percent me-2"></i>Apply Discount
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
                <!-- Discount Summary -->
                <div class="discount-summary mb-4">
                    <div class="card border-warning">
                        <div class="card-body text-center">
                            <div class="text-muted small mb-2">Current Sale Total</div>
                            <div class="fs-3 fw-bold text-primary" id="currentSaleTotal">KES 0.00</div>
                            <div class="mt-2">
                                <span class="badge bg-light text-dark">
                                    <i class="bx bx-package me-1"></i>
                                    <span id="currentItemCount">0</span> items
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Discount Type Selection -->
                <div class="discount-type mb-4">
                    <label class="form-label fw-bold">Discount Type</label>
                    <div class="row g-2">
                        <div class="col-6">
                            <div class="form-check discount-type-card">
                                <input class="form-check-input" type="radio" name="discountType" 
                                       id="discountAmount" value="amount" checked>
                                <label class="form-check-label w-100" for="discountAmount">
                                    <div class="card border-0">
                                        <div class="card-body text-center">
                                            <i class="bx bx-money fs-2 mb-2 text-primary"></i>
                                            <div class="fw-bold">Fixed Amount</div>
                                            <div class="small text-muted">Discount in KES</div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-check discount-type-card">
                                <input class="form-check-input" type="radio" name="discountType" 
                                       id="discountPercent" value="percent">
                                <label class="form-check-label w-100" for="discountPercent">
                                    <div class="card border-0">
                                        <div class="card-body text-center">
                                            <i class="bx bx-percentage fs-2 mb-2 text-success"></i>
                                            <div class="fw-bold">Percentage</div>
                                            <div class="small text-muted">Discount by %</div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Discount Value Input -->
                <div class="discount-value mb-4">
                    <label class="form-label fw-bold">Discount Value</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-text bg-light" id="discountPrefix">KES</span>
                        <input type="number" class="form-control" id="discountValueInput" 
                               placeholder="0.00" min="0" step="0.01" autofocus>
                        <span class="input-group-text bg-light d-none" id="discountSuffix">%</span>
                    </div>
                    <div class="form-text" id="discountHint">
                        Enter discount amount in KES
                    </div>
                </div>
                
                <!-- Discount Preview -->
                <div class="discount-preview mb-4" id="discountPreview" style="display: none;">
                    <div class="card border-success">
                        <div class="card-body">
                            <h6 class="card-title">Discount Preview</h6>
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="small text-muted">Original Total</div>
                                    <div class="fw-bold" id="originalTotal">KES 0.00</div>
                                </div>
                                <div class="col-6">
                                    <div class="small text-muted">Discount Amount</div>
                                    <div class="fw-bold text-success" id="discountAmountPreview">-KES 0.00</div>
                                </div>
                                <div class="col-6">
                                    <div class="small text-muted">New Total</div>
                                    <div class="fw-bold text-primary" id="newTotal">KES 0.00</div>
                                </div>
                                <div class="col-6">
                                    <div class="small text-muted">Savings</div>
                                    <div class="fw-bold text-danger" id="savingsPercent">0%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Discount Reason -->
                <div class="discount-reason mb-4">
                    <label class="form-label">Reason for Discount (Optional)</label>
                    <select class="form-select" id="discountReason">
                        <option value="">Select reason...</option>
                        <option value="seasonal">Seasonal Sale</option>
                        <option value="loyalty">Loyalty Discount</option>
                        <option value="bulk">Bulk Purchase</option>
                        <option value="promotion">Store Promotion</option>
                        <option value="employee">Employee Discount</option>
                        <option value="damaged">Damaged Goods</option>
                        <option value="other">Other</option>
                    </select>
                    <div class="mt-2" id="customReason" style="display: none;">
                        <input type="text" class="form-control" id="customReasonInput" 
                               placeholder="Enter custom reason...">
                    </div>
                </div>
                
                <!-- Quick Discount Presets -->
                <div class="discount-presets mb-4">
                    <label class="form-label fw-bold">Quick Discounts</label>
                    <div class="d-flex flex-wrap gap-2">
                        <button class="btn btn-outline-secondary" onclick="applyQuickDiscount(5)">
                            5% Off
                        </button>
                        <button class="btn btn-outline-secondary" onclick="applyQuickDiscount(10)">
                            10% Off
                        </button>
                        <button class="btn btn-outline-secondary" onclick="applyQuickDiscount(100)">
                            KES 100 Off
                        </button>
                        <button class="btn btn-outline-secondary" onclick="applyQuickDiscount(500)">
                            KES 500 Off
                        </button>
                    </div>
                </div>
                
                <!-- Discount History -->
                <div class="discount-history" id="discountHistorySection" style="display: none;">
                    <label class="form-label fw-bold">Recent Discounts</label>
                    <div class="list-group" id="discountHistory">
                        <!-- Recent discounts will be loaded here -->
                    </div>
                </div>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-outline-danger" onclick="removeDiscount()">
                    <i class="bx bx-trash me-2"></i>Remove Discount
                </button>
                <button type="button" class="btn btn-warning" onclick="applyDiscount()">
                    <i class="bx bx-check me-2"></i>Apply Discount
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .discount-type-card .form-check-input {
        position: absolute;
        left: 10px;
        top: 10px;
        z-index: 1;
    }
    
    .discount-type-card .card {
        border: 2px solid transparent;
        transition: all 0.3s;
        cursor: pointer;
    }
    
    .discount-type-card .form-check-input:checked + .form-check-label .card {
        border-color: #f59e0b;
        background-color: #fffbeb;
    }
    
    .discount-type-card .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .discount-presets .btn {
        transition: all 0.3s;
    }
    
    .discount-presets .btn:hover {
        background-color: #fef3c7;
        border-color: #f59e0b;
        transform: translateY(-1px);
    }
    
    .discount-history .list-group-item {
        border-left: 3px solid transparent;
        transition: all 0.2s;
    }
    
    .discount-history .list-group-item:hover {
        border-left-color: #f59e0b;
        background-color: #fffbeb;
    }
    
    .discount-history-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .discount-history-amount {
        font-weight: bold;
        color: #10b981;
    }
    
    .discount-history-reason {
        font-size: 12px;
        color: #64748b;
    }
</style>

<script>
    let currentDiscount = 0;
    let discountType = 'amount'; // 'amount' or 'percent'
    
    function showDiscountModal() {
        const modal = new bootstrap.Modal(document.getElementById('discountModal'));
        modal.show();
        updateDiscountSummary();
        loadDiscountHistory();
    }
    
    function updateDiscountSummary() {
        const total = calculateCartTotal();
        document.getElementById('currentSaleTotal').textContent = 'KES ' + total.toFixed(2);
        document.getElementById('currentItemCount').textContent = cart.length;
        document.getElementById('originalTotal').textContent = 'KES ' + total.toFixed(2);
        
        // Update preview if discount exists
        if (currentDiscount > 0) {
            updateDiscountPreview();
        }
    }
    
    function toggleDiscountType() {
        discountType = document.querySelector('input[name="discountType"]:checked').value;
        const prefix = document.getElementById('discountPrefix');
        const suffix = document.getElementById('discountSuffix');
        const hint = document.getElementById('discountHint');
        
        if (discountType === 'amount') {
            prefix.textContent = 'KES';
            suffix.classList.add('d-none');
            hint.textContent = 'Enter discount amount in KES';
        } else {
            prefix.textContent = '';
            suffix.classList.remove('d-none');
            hint.textContent = 'Enter discount percentage (0-100)';
        }
        
        // Clear value and update preview
        document.getElementById('discountValueInput').value = '';
        updateDiscountPreview();
    }
    
    function updateDiscountPreview() {
        const valueInput = document.getElementById('discountValueInput').value;
        if (!valueInput) {
            document.getElementById('discountPreview').style.display = 'none';
            return;
        }
        
        const value = parseFloat(valueInput);
        if (isNaN(value) || value <= 0) {
            document.getElementById('discountPreview').style.display = 'none';
            return;
        }
        
        const originalTotal = calculateCartTotal();
        let discountAmount = 0;
        let newTotal = 0;
        
        if (discountType === 'amount') {
            discountAmount = Math.min(value, originalTotal);
            newTotal = originalTotal - discountAmount;
        } else {
            discountAmount = originalTotal * (Math.min(value, 100) / 100);
            newTotal = originalTotal - discountAmount;
        }
        
        const savingsPercent = ((discountAmount / originalTotal) * 100).toFixed(1);
        
        // Update preview
        document.getElementById('discountPreview').style.display = 'block';
        document.getElementById('discountAmountPreview').textContent = '-KES ' + discountAmount.toFixed(2);
        document.getElementById('newTotal').textContent = 'KES ' + newTotal.toFixed(2);
        document.getElementById('savingsPercent').textContent = savingsPercent + '%';
    }
    
    function applyQuickDiscount(value) {
        const total = calculateCartTotal();
        
        if (value <= 100) {
            // Percentage discount
            document.getElementById('discountPercent').checked = true;
            toggleDiscountType();
            document.getElementById('discountValueInput').value = value;
        } else {
            // Fixed amount discount
            document.getElementById('discountAmount').checked = true;
            toggleDiscountType();
            document.getElementById('discountValueInput').value = value;
        }
        
        updateDiscountPreview();
    }
    
    function applyDiscount() {
        const valueInput = document.getElementById('discountValueInput').value;
        const reason = document.getElementById('discountReason').value;
        const customReason = document.getElementById('customReasonInput').value;
        
        if (!valueInput) {
            showToast('Please enter a discount value', 'error');
            return;
        }
        
        const value = parseFloat(valueInput);
        if (isNaN(value) || value <= 0) {
            showToast('Please enter a valid discount value', 'error');
            return;
        }
        
        const total = calculateCartTotal();
        let discountAmount = 0;
        
        if (discountType === 'amount') {
            discountAmount = Math.min(value, total);
        } else {
            if (value > 100) {
                showToast('Discount percentage cannot exceed 100%', 'error');
                return;
            }
            discountAmount = total * (value / 100);
        }
        
        // Apply discount to cart
        currentDiscount = discountAmount;
        
        // Update cart display
        updateCartDisplay();
        
        // Save discount reason
        const discountReason = reason === 'other' ? customReason : reason;
        if (discountReason) {
            saveDiscountToHistory(discountAmount, discountReason);
        }
        
        // Close modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('discountModal'));
        modal.hide();
        
        showToast(`Discount applied: -KES ${discountAmount.toFixed(2)}`, 'success');
    }
    
    function removeDiscount() {
        currentDiscount = 0;
        updateCartDisplay();
        
        const modal = bootstrap.Modal.getInstance(document.getElementById('discountModal'));
        modal.hide();
        
        showToast('Discount removed', 'info');
    }
    
    function saveDiscountToHistory(amount, reason) {
        const history = JSON.parse(localStorage.getItem('discountHistory') || '[]');
        history.unshift({
            amount: amount,
            reason: reason,
            date: new Date().toISOString(),
            type: discountType
        });
        
        // Keep only last 10 discounts
        if (history.length > 10) {
            history.pop();
        }
        
        localStorage.setItem('discountHistory', JSON.stringify(history));
    }
    
    function loadDiscountHistory() {
        const history = JSON.parse(localStorage.getItem('discountHistory') || '[]');
        const container = document.getElementById('discountHistory');
        
        if (history.length === 0) {
            document.getElementById('discountHistorySection').style.display = 'none';
            return;
        }
        
        document.getElementById('discountHistorySection').style.display = 'block';
        
        let html = '';
        history.forEach(item => {
            html += `
                <div class="list-group-item">
                    <div class="discount-history-item">
                        <div>
                            <div class="fw-bold">-KES ${item.amount.toFixed(2)}</div>
                            <div class="discount-history-reason">${item.reason}</div>
                        </div>
                        <div class="text-muted small">
                            ${new Date(item.date).toLocaleDateString()}
                        </div>
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    }
    
    // Event listeners
    document.querySelectorAll('input[name="discountType"]').forEach(radio => {
        radio.addEventListener('change', toggleDiscountType);
    });
    
    document.getElementById('discountValueInput').addEventListener('input', updateDiscountPreview);
    
    document.getElementById('discountReason').addEventListener('change', function() {
        const customReasonDiv = document.getElementById('customReason');
        if (this.value === 'other') {
            customReasonDiv.style.display = 'block';
        } else {
            customReasonDiv.style.display = 'none';
        }
    });
    
    // Initialize when modal is shown
    document.getElementById('discountModal').addEventListener('shown.bs.modal', function() {
        updateDiscountSummary();
        document.getElementById('discountValueInput').focus();
    });
</script>