<div class="card mb-3">
    <div class="card-body py-3">
        <div class="d-flex justify-content-between align-items-center">
            <div class="customer-display d-flex align-items-center gap-3">
                <div class="customer-avatar">
                    <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center" 
                         style="width: 40px; height: 40px; border-radius: 50%;">
                        <i class="bx bx-user"></i>
                    </div>
                </div>
                <div class="customer-info">
                    <div class="customer-name fw-bold" id="currentCustomerName">
                        Walk-in Customer
                    </div>
                    <div class="customer-meta text-muted small" id="currentCustomerMeta">
                        Tap to select customer
                    </div>
                </div>
            </div>
            
            <div class="customer-actions d-flex gap-2">
                <button class="btn btn-sm btn-outline-primary" onclick="showCustomerModal()">
                    <i class="bx bx-user-plus me-1"></i>Select
                </button>
                <button class="btn btn-sm btn-outline-secondary" onclick="quickAddCustomer()">
                    <i class="bx bx-plus me-1"></i>Add New
                </button>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-info dropdown-toggle" type="button" 
                            data-bs-toggle="dropdown">
                        <i class="bx bx-dots-vertical-rounded"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="viewCustomerHistory()">
                            <i class="bx bx-history me-2"></i>Purchase History
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="checkCreditBalance()">
                            <i class="bx bx-credit-card me-2"></i>Credit Balance
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="applyLoyaltyPoints()">
                            <i class="bx bx-star me-2"></i>Loyalty Points
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Customer Quick Stats (Visible when customer selected) -->
        <div class="customer-stats mt-3" id="customerStats" style="display: none;">
            <div class="row g-2">
                <div class="col-3">
                    <div class="card border-0 bg-light">
                        <div class="card-body p-2 text-center">
                            <div class="small text-muted">Total Spent</div>
                            <div class="fw-bold" id="customerTotalSpent">KES 0</div>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card border-0 bg-light">
                        <div class="card-body p-2 text-center">
                            <div class="small text-muted">Visits</div>
                            <div class="fw-bold" id="customerVisits">0</div>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card border-0 bg-light">
                        <div class="card-body p-2 text-center">
                            <div class="small text-muted">Credit Limit</div>
                            <div class="fw-bold" id="customerCreditLimit">KES 0</div>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card border-0 bg-light">
                        <div class="card-body p-2 text-center">
                            <div class="small text-muted">Last Visit</div>
                            <div class="fw-bold small" id="customerLastVisit">-</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden Customer ID -->
<input type="hidden" id="customerId" value="">