<div class="modal fade" id="customerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">
                    <i class="bx bx-user me-2"></i>Select Customer
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
                <!-- Search and Filter -->
                <div class="customer-search mb-4">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bx bx-search"></i>
                                </span>
                                <input type="text" class="form-control" id="customerSearch" 
                                       placeholder="Search by name, phone, email, or customer code..."
                                       autofocus>
                                <button class="btn btn-outline-primary" onclick="searchCustomers()">
                                    Search
                                </button>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <select class="form-select" id="customerTypeFilter">
                                <option value="all">All Customers</option>
                                <option value="walk-in">Walk-in</option>
                                <option value="regular">Regular</option>
                                <option value="business">Business</option>
                                <option value="credit">Credit Customers</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Stats -->
                <div class="customer-stats mb-4" id="customerStatsSummary">
                    <div class="row g-2">
                        <div class="col-3">
                            <div class="card border-0 bg-light">
                                <div class="card-body p-2 text-center">
                                    <div class="small text-muted">Total</div>
                                    <div class="fw-bold" id="totalCustomers">0</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="card border-0 bg-light">
                                <div class="card-body p-2 text-center">
                                    <div class="small text-muted">Active Today</div>
                                    <div class="fw-bold" id="activeToday">0</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="card border-0 bg-light">
                                <div class="card-body p-2 text-center">
                                    <div class="small text-muted">Credit Limit</div>
                                    <div class="fw-bold" id="totalCredit">KES 0</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="card border-0 bg-light">
                                <div class="card-body p-2 text-center">
                                    <div class="small text-muted">Avg. Sale</div>
                                    <div class="fw-bold" id="avgCustomerSale">KES 0</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Customer List -->
                <div class="customer-list">
                    <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                        <table class="table table-hover">
                            <thead style="position: sticky; top: 0; background: white; z-index: 1;">
                                <tr>
                                    <th>Customer</th>
                                    <th>Contact</th>
                                    <th>Type</th>
                                    <th>Credit</th>
                                    <th>Last Purchase</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="customerTableBody">
                                <!-- Customers will be loaded here -->
                                <tr>
                                    <td colspan="6" class="text-center py-5">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading customers...</span>
                                        </div>
                                        <p class="mt-2 text-muted">Loading customers...</p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Quick Add Form -->
                <div class="quick-add-form mt-4" id="quickAddForm">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="mb-0">
                                <i class="bx bx-plus-circle me-2"></i>Quick Add Customer
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">Full Name *</label>
                                    <input type="text" class="form-control" id="quickName" 
                                           placeholder="John Doe">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Phone Number *</label>
                                    <input type="tel" class="form-control" id="quickPhone" 
                                           placeholder="0712 345 678">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" id="quickEmail" 
                                           placeholder="john@example.com">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Customer Type</label>
                                    <select class="form-select" id="quickType">
                                        <option value="walk-in">Walk-in</option>
                                        <option value="regular">Regular</option>
                                        <option value="business">Business</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Credit Limit (KES)</label>
                                    <input type="number" class="form-control" id="quickCredit" 
                                           placeholder="0.00" min="0" step="1000">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <button class="btn btn-primary" onclick="addQuickCustomer()">
                                <i class="bx bx-plus me-2"></i>Add Customer
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="selectWalkInCustomer()">
                    <i class="bx bx-walk me-2"></i>Use Walk-in Customer
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .customer-search .input-group {
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .customer-stats .card {
        transition: transform 0.2s;
    }
    
    .customer-stats .card:hover {
        transform: translateY(-2px);
    }
    
    .customer-table {
        border-collapse: separate;
        border-spacing: 0;
    }
    
    .customer-table tbody tr {
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .customer-table tbody tr:hover {
        background-color: #f8fafc;
    }
    
    .customer-table tbody tr.selected {
        background-color: #e0f2fe;
    }
    
    .customer-avatar {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        background: linear-gradient(135deg, #2a4365 0%, #1a365d 100%);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: bold;
    }
    
    .customer-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .customer-name {
        font-weight: 600;
        font-size: 14px;
        color: #1e293b;
    }
    
    .customer-phone {
        font-size: 12px;
        color: #64748b;
    }
    
    .customer-type-badge {
        font-size: 10px;
        padding: 2px 8px;
        border-radius: 10px;
    }
    
    .badge-walk-in {
        background-color: #dbeafe;
        color: #1e40af;
    }
    
    .badge-regular {
        background-color: #dcfce7;
        color: #166534;
    }
    
    .badge-business {
        background-color: #fef3c7;
        color: #92400e;
    }
    
    .badge-credit {
        background-color: #fee2e2;
        color: #991b1b;
    }
    
    .credit-info {
        font-size: 12px;
    }
    
    .credit-available {
        color: #10b981;
        font-weight: 600;
    }
    
    .credit-used {
        color: #ef4444;
    }
    
    .last-purchase {
        font-size: 11px;
        color: #64748b;
    }
    
    .customer-actions {
        display: flex;
        gap: 5px;
    }
    
    .customer-actions .btn {
        padding: 4px 8px;
        font-size: 12px;
    }
    
    .quick-add-form .card {
        border: 1px solid #2a4365;
        box-shadow: 0 2px 8px rgba(42, 67, 101, 0.1);
    }
    
    @media (max-width: 768px) {
        .customer-table thead {
            display: none;
        }
        
        .customer-table tbody tr {
            display: block;
            margin-bottom: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px;
        }
        
        .customer-table tbody td {
            display: block;
            text-align: right;
            padding: 5px 10px;
            border: none;
        }
        
        .customer-table tbody td::before {
            content: attr(data-label);
            float: left;
            font-weight: bold;
            color: #64748b;
        }
        
        .customer-info {
            justify-content: space-between;
        }
    }

    /* VAT Status Styling */
.vat-customer-badge {
    border-radius: 6px;
    font-size: 0.85rem;
}

.vat-customer-badge .badge {
    font-size: 0.75rem;
    padding: 0.25em 0.6em;
}

.customer-type-badge {
    font-size: 0.75rem;
}

/* Customer VAT status colors */
.vat-status-exempted {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.vat-status-zero-rated {
    background-color: #fff3cd;
    color: #856404;
    border: 1px solid #ffeaa7;
}

.vat-status-vatable {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

/* Customer modal VAT info */
.customer-vat-info {
    margin-top: 10px;
    padding: 8px;
    border-radius: 4px;
    font-size: 0.85rem;
}

/* Badge styling */
.badge-walk-in {
    background-color: #6c757d;
    color: white;
}

.badge-regular {
    background-color: #0d6efd;
    color: white;
}

.badge-business {
    background-color: #6610f2;
    color: white;
}

.badge-credit {
    background-color: #fd7e14;
    color: white;
}

/* Customer table styling */
tr.selected {
    background-color: #e8f4fd !important;
}

tr.selected td {
    border-color: #b6d4fe;
}

.customer-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.customer-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #0d6efd 0%, #6610f2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 0.9rem;
}

.customer-avatar-large {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #0d6efd 0%, #6610f2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 1.5rem;
    margin: 0 auto;
}

.customer-name {
    font-weight: 600;
    color: #212529;
}

.customer-phone {
    font-size: 0.85rem;
    color: #6c757d;
}

.customer-actions .btn {
    padding: 0.15rem 0.4rem;
    font-size: 0.75rem;
}

.credit-info {
    font-size: 0.85rem;
}

.last-purchase {
    font-weight: 500;
}
</style>

