<template id="multipleFormTemplate">
    <div class="payment-form multiple-form">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i>
            <strong>Split Payment:</strong> Distribute total amount across multiple payment methods
        </div>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <label class="form-label">Total Amount</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text bg-primary text-white">KES</span>
                    <input type="text" class="form-control form-control-lg fw-bold" 
                           id="splitTotalAmount" readonly>
                </div>
            </div>
            <div class="col-md-6">
                <label class="form-label">Remaining Balance</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text" id="splitRemainingIndicator">KES</span>
                    <input type="text" class="form-control form-control-lg fw-bold" 
                           id="splitRemainingDisplay" readonly>
                </div>
            </div>
        </div>
        
        <!-- Split Amounts -->
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="splitCash" class="form-label">Cash Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" class="form-control split-amount" id="splitCash" 
                           placeholder="0.00" step="0.01" min="0" value="0">
                </div>
                <div class="form-text">Amount paid in cash</div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="splitMpesa" class="form-label">M-Pesa Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" class="form-control split-amount" id="splitMpesa" 
                           placeholder="0.00" step="0.01" min="0" value="0">
                </div>
                <div class="form-text">Amount paid via M-Pesa</div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="splitCard" class="form-label">Card Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" class="form-control split-amount" id="splitCard" 
                           placeholder="0.00" step="0.01" min="0" value="0">
                </div>
                <div class="form-text">Amount paid via card</div>
            </div>
            <div class="col-md-6 mb-3">
                <label for="splitOther" class="form-label">Other Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" class="form-control split-amount" id="splitOther" 
                           placeholder="0.00" step="0.01" min="0" value="0">
                </div>
                <div class="form-text">Other payment methods</div>
            </div>
        </div>
        
        <!-- Quick Distribution Buttons -->
        <div class="mb-3">
            <label class="form-label">Quick Distribution:</label>
            <div class="d-flex flex-wrap gap-2">
                <button type="button" class="btn btn-sm btn-outline-primary" onclick="distributeSplit('cash')">
                    All Cash
                </button>
                <button type="button" class="btn btn-sm btn-outline-primary" onclick="distributeSplit('mpesa')">
                    All M-Pesa
                </button>
                <button type="button" class="btn btn-sm btn-outline-primary" onclick="distributeSplit('card')">
                    All Card
                </button>
                <button type="button" class="btn btn-sm btn-outline-success" onclick="distributeSplit('equal')">
                    50/50 Split
                </button>
                <button type="button" class="btn btn-sm btn-outline-info" onclick="distributeSplit('auto')">
                    Auto-Distribute
                </button>
            </div>
        </div>
        
        <!-- M-Pesa Details (Conditional) -->
        <div id="splitMpesaDetails" class="mb-3" style="display: none;">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title mb-3"><i class="bx bx-transfer me-2"></i>M-Pesa Details</h6>
                    <div class="mb-3">
                        <label for="splitMpesaPhone" class="form-label">Phone Number</label>
                        <div class="input-group">
                            <span class="input-group-text">+254</span>
                            <input type="tel" class="form-control" id="splitMpesaPhone" 
                                   placeholder="7XXXXXXXX">
                        </div>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="splitMpesaSMS">
                        <label class="form-check-label" for="splitMpesaSMS">
                            Send SMS confirmation
                        </label>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Split Summary -->
        <div class="split-summary mt-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title mb-3"><i class="bx bx-pie-chart-alt me-2"></i>Payment Summary</h6>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-muted small">Cash</div>
                            <div class="fw-bold" id="splitCashSummary">KES 0.00</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small">M-Pesa</div>
                            <div class="fw-bold" id="splitMpesaSummary">KES 0.00</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small">Card</div>
                            <div class="fw-bold" id="splitCardSummary">KES 0.00</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-muted small">Other</div>
                            <div class="fw-bold" id="splitOtherSummary">KES 0.00</div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="text-muted small">Split Total</div>
                            <div class="fw-bold" id="splitTotalSummary">KES 0.00</div>
                        </div>
                        <div class="col-md-6">
                            <div class="text-muted small">Remaining</div>
                            <div class="fw-bold" id="splitRemainingSummary">KES 0.00</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="alert alert-info mt-3">
            <i class="bx bx-info-circle me-2"></i>
            <strong>Note:</strong> The sum of all amounts must equal the total amount.
        </div>
    </div>
</template>