<template id="mpesaFormTemplate">
    <div class="payment-form mpesa-form">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i>
            <strong>M-Pesa Payment:</strong> Select payment method below
        </div>
        
        <!-- M-Pesa Type Selection -->
        <div class="mb-4">
            <label class="form-label mb-3">M-Pesa Payment Type</label>
            <div class="d-flex gap-3">
                <div class="form-check form-check-inline mpesa-type-card" data-type="stk">
                    <input class="form-check-input" type="radio" name="mpesaType" id="mpesaStkPush" value="stk" checked>
                    <label class="form-check-label" for="mpesaStkPush">
                        <div class="text-center">
                            <i class="bx bx-send fs-3 mb-2"></i>
                            <div class="fw-bold">STK Push</div>
                            <div class="small text-muted">Send request to phone</div>
                        </div>
                    </label>
                </div>
                <div class="form-check form-check-inline mpesa-type-card" data-type="manual">
                    <input class="form-check-input" type="radio" name="mpesaType" id="mpesaManual" value="manual">
                    <label class="form-check-label" for="mpesaManual">
                        <div class="text-center">
                            <i class="bx bx-pencil fs-3 mb-2"></i>
                            <div class="fw-bold">Manual Entry</div>
                            <div class="small text-muted">Record existing payment</div>
                        </div>
                    </label>
                </div>
            </div>
        </div>
        
        <!-- Common Fields -->
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="mpesaPhone" class="form-label">Phone Number *</label>
                <div class="input-group">
                    <span class="input-group-text">+254</span>
                    <input type="tel" class="form-control" id="mpesaPhone" 
                           placeholder="7XXXXXXXX" pattern="[0-9]{9}" maxlength="9" required 
                           inputmode="numeric">
                </div>
                <div class="form-text">9-digit Safaricom number (7XXXXXXXX)</div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">Amount</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="text" class="form-control" id="mpesaAmount" readonly>
                </div>
            </div>
        </div>
        
        <!-- STK Push Fields (Default) -->
        <div id="stkPushFields">
            <div class="alert alert-warning">
                <i class="bx bx-error-circle me-2"></i>
                <strong>STK Push Instructions:</strong> 
                A payment request will be sent to the customer's phone. They need to enter their M-Pesa PIN to complete.
            </div>
            
            <div class="mb-3">
                <label for="mpesaReference" class="form-label">Payment Reference</label>
                <input type="text" class="form-control" id="mpesaReference" 
                       placeholder="e.g., POS Sale - {{ date('Ymd') }}" 
                       value="POS Sale - {{ date('YmdHis') }}">
            </div>
            
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" id="sendMpesaSMS" checked>
                <label class="form-check-label" for="sendMpesaSMS">
                    <i class="bx bx-message me-1"></i>Send SMS confirmation to customer
                </label>
            </div>
            
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="mpesaAutoConfirm" checked>
                <label class="form-check-label" for="mpesaAutoConfirm">
                    <i class="bx bx-check-shield me-1"></i>Auto-confirm payment when received
                </label>
            </div>
        </div>
        
        <!-- Manual M-Pesa Fields (Hidden) -->
        <div id="manualMpesaFields" style="display: none;">
            <div class="alert alert-warning">
                <i class="bx bx-error-circle me-2"></i>
                <strong>Manual Entry:</strong> Use this when customer has already paid via M-Pesa.
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="mpesaTransactionId" class="form-label">Transaction ID *</label>
                    <input type="text" class="form-control" id="mpesaTransactionId" 
                           placeholder="e.g., QL1234ABC" required>
                    <div class="form-text">Find on customer's M-Pesa message</div>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="mpesaReceiptNo" class="form-label">Receipt Number</label>
                    <input type="text" class="form-control" id="mpesaReceiptNo" 
                           placeholder="e.g., RA123456789">
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="mpesaTransactionDate" class="form-label">Transaction Date & Time</label>
                    <input type="datetime-local" class="form-control" id="mpesaTransactionDate" 
                           value="{{ date('Y-m-d\TH:i') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label for="mpesaSenderName" class="form-label">Sender Name (Optional)</label>
                    <input type="text" class="form-control" id="mpesaSenderName" 
                           placeholder="Customer name on M-Pesa">
                </div>
            </div>
        </div>
    </div>
</template>