<!-- resources/views/pos/components/manual-mpesa-modal.blade.php -->
<div class="modal fade" id="manualMpesaModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">
                    <i class="bx bx-transfer me-2"></i>Manual M-Pesa Payment
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
                <!-- Tabs for different actions -->
                <ul class="nav nav-tabs mb-4" id="mpesaTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="search-tab" data-bs-toggle="tab" 
                                data-bs-target="#search-tab-pane" type="button" role="tab">
                            <i class="bx bx-search me-1"></i>Search Transaction
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="manual-tab" data-bs-toggle="tab" 
                                data-bs-target="#manual-tab-pane" type="button" role="tab">
                            <i class="bx bx-edit me-1"></i>Manual Entry
                        </button>
                    </li>
                </ul>
                
                <!-- Tab Content -->
                <div class="tab-content">
                    <!-- Search Tab -->
                    <div class="tab-pane fade show active" id="search-tab-pane" role="tabpanel">
                        <div class="alert alert-light mb-3">
                            <i class="bx bx-info-circle me-2"></i>
                            Search for existing M-Pesa transactions by phone number or transaction ID
                        </div>
                        
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="mpesaTransactionSearch" 
                                   placeholder="Enter transaction code or phone number...">
                            <button class="btn btn-primary" type="button" 
                                    onclick="POSMpesaManager.searchMpesaTransaction()">
                                <i class="bx bx-search"></i> Search
                            </button>
                        </div>
                        
                        <div id="mpesaSearchResults">
                            <!-- Search results will appear here -->
                        </div>
                    </div>
                    
                    <!-- Manual Entry Tab -->
                    <div class="tab-pane fade" id="manual-tab-pane" role="tabpanel">
                        <form id="manualMpesaForm">
                            <div class="alert alert-light mb-3">
                                <i class="bx bx-info-circle me-2"></i>
                                Record a manual M-Pesa payment. This will be added to your transaction records.
                            </div>
                            
                            <div class="row g-3 mb-4">
                                <div class="col-md-6">
                                    <label class="form-label">Transaction ID *</label>
                                    <input type="text" class="form-control" id="mpesaManualTransactionId" 
                                           name="transaction_id" placeholder="ABC123XYZ" required>
                                    <div class="form-text">M-Pesa transaction code from customer</div>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Phone Number *</label>
                                    <div class="input-group">
                                        <span class="input-group-text">+254</span>
                                        <input type="tel" class="form-control" id="mpesaManualPhone" 
                                               name="phone" placeholder="7XXXXXXXX" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Amount *</label>
                                    <div class="input-group">
                                        <span class="input-group-text">KES</span>
                                        <input type="number" class="form-control" id="mpesaManualAmount" 
                                               name="amount" min="0" step="0.01" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Transaction Date</label>
                                    <input type="datetime-local" class="form-control" 
                                           name="transaction_date" value="{{ date('Y-m-d\TH:i') }}">
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Reference (Optional)</label>
                                    <input type="text" class="form-control" id="mpesaManualReference" 
                                           name="reference" placeholder="Payment for...">
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Sale (Optional)</label>
                                    <select class="form-select" id="mpesaManualSale" name="sale_id">
                                        <option value="">Select sale to match...</option>
                                    </select>
                                </div>
                                
                                <div class="col-12">
                                    <label class="form-label">Notes (Optional)</label>
                                    <textarea class="form-control" name="notes" rows="2" 
                                              placeholder="Additional information..."></textarea>
                                </div>
                            </div>
                            
                            <!-- Sale Search Section -->
                            <div class="card mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <i class="bx bx-receipt me-2"></i>Search and Match to Sale
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control" id="saleSearchInput" 
                                               placeholder="Search by invoice number or customer name...">
                                        <button class="btn btn-outline-primary" type="button" 
                                                onclick="POSMpesaManager.searchSaleForPayment()">
                                            <i class="bx bx-search"></i> Search
                                        </button>
                                    </div>
                                    
                                    <div id="saleSearchResults" class="mb-3">
                                        <!-- Sale search results will appear here -->
                                    </div>
                                    
                                    <div id="selectedSaleInfo">
                                        <!-- Selected sale info will appear here -->
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="POSMpesaManager.processManualPayment()">
                    <i class="bx bx-check me-2"></i>Record Payment
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .transaction-item, .sale-item {
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .transaction-item:hover, .sale-item:hover {
        background-color: #f8fafc;
    }
    
    .transaction-item.selected, .sale-item.selected {
        background-color: #e3f2fd;
        border-left: 4px solid #2a4365;
    }
    
    #mpesaTabs .nav-link {
        font-weight: 500;
        color: #64748b;
        padding: 10px 20px;
    }
    
    #mpesaTabs .nav-link.active {
        color: #2a4365;
        font-weight: 600;
        border-bottom: 3px solid #2a4365;
    }
</style>