<div class="sidebar-wrapper" data-simplebar="true">
    <div class="sidebar-header">
        <div>
            <img src="{{ asset('assets/images/autopos.png') }}" class="logo-icon" alt="logo icon">
        </div>
        <div>
            <h4 class="logo-text">{{ config('app.name', 'AutoPOS') }}</h4>
        </div>
        <div class="toggle-icon ms-auto"><i class='bx bx-arrow-to-left'></i></div>
    </div>
    
    <!--navigation-->
    <ul class="metismenu" id="menu">
        <!-- Dashboard -->
        <li>
            <a href="{{ route('dashboard') }}">
                <div class="parent-icon"><i class='bx bx-home'></i></div>
                <div class="menu-title">Dashboard</div>
            </a>
        </li>

        <!-- POS -->
        @hasanyrole('cashier|manager|admin')
        <li>
            <a href="{{ route('pos.index') }}">
                <div class="parent-icon"><i class='bx bx-cart-alt'></i></div>
                <div class="menu-title">POS</div>
            </a>
        </li>
        @endhasanyrole

        <li class="menu-label">Products & Inventory</li>

        <!-- Products Management -->
        @hasanyrole('manager|admin')
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-package'></i></div>
                <div class="menu-title">Products</div>
            </a>
            <ul>
                <!-- Product Listing -->
                <li>
                    <a href="{{ route('products.index') }}">
                        <i class="bx bx-right-arrow-alt"></i>All Products
                    </a>
                </li>
                
                <!-- Add New Product -->
                <li>
                    <a href="{{ route('products.create') }}">
                        <i class="bx bx-plus-circle"></i>Add New Product
                    </a>
                </li>
                
                <!-- Categories -->
                <li>
                    <a href="{{ route('categories.index') }}">
                        <i class="bx bx-category"></i>Categories
                    </a>
                </li>
                
                <!-- Product Batches -->
                <li>
                    <a href="{{ route('batches.index') }}">
                        <i class="bx bx-layer"></i>Product Batches
                    </a>
                </li>
                
                <!-- Brands -->
                <li>
                    <a href="{{ route('brands.index') }}">
                        <i class="bx bx-tag"></i>Brands
                    </a>
                </li>
                
                <!-- Units -->
                <li>
                    <a href="{{ route('units.index') }}">
                        <i class="bx bx-ruler"></i>Units
                    </a>
                </li>
                
                <!-- Pricing Management -->
                <li>
                    <a href="{{ route('products.pricing.index') }}">
                        <i class="bx bx-dollar-circle"></i>Pricing Management
                    </a>
                </li>
                
                <!-- Import/Export -->
                <li>
                    <a href="javascript:;" class="has-arrow">
                        <i class="bx bx-right-arrow-alt"></i>Import/Export
                    </a>
                    <ul>
                        <li>
                            <a href="{{ route('products.import') }}">
                                <i class="bx bx-import"></i>Import Products
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('products.export') }}">
                                <i class="bx bx-export"></i>Export Products
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('products.template.download') }}">
                                <i class="bx bx-download"></i>Download Template
                            </a>
                        </li>
                    </ul>
                </li>
                
                <!-- Product Reports -->
                <li>
                    <a href="javascript:;" class="has-arrow">
                        <i class="bx bx-right-arrow-alt"></i>Reports
                    </a>
                    <ul>
                        <li>
                            <a href="{{ route('products.statistics') }}">
                                <i class="bx bx-bar-chart"></i>Product Statistics
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('products.expiry-report') }}">
                                <i class="bx bx-calendar-exclamation"></i>Expiry Report
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.inventory') }}">
                                <i class="bx bx-archive"></i>Inventory Report
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </li>
        @endhasanyrole

        <!-- Inventory Management -->
        @hasanyrole('manager|admin')
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-archive'></i></div>
                <div class="menu-title">Inventory</div>
            </a>
            <ul>
                <li>
                    <a href="{{ route('batches.expiry-alerts') }}">
                        <i class="bx bx-right-arrow-alt"></i>Expiry Alerts
                    </a>
                </li>
                <li>
                    <a href="{{ route('products.index') }}?stock_status=low_stock">
                        <i class="bx bx-right-arrow-alt"></i>Low Stock Items
                    </a>
                </li>
                <li>
                    <a href="{{ route('products.index') }}?stock_status=out_of_stock">
                        <i class="bx bx-right-arrow-alt"></i>Out of Stock Items
                    </a>
                </li>
            </ul>
        </li>
        @endhasanyrole

        <li class="menu-label">Sales & Purchases</li>

        <!-- Sales -->
        @hasanyrole('cashier|manager|admin')
        <li>
            <a href="{{ route('pos.index') }}">
                <div class="parent-icon"><i class='bx bx-money'></i></div>
                <div class="menu-title">Sales</div>
            </a>
        </li>
        @endhasanyrole

        <!-- Customers -->
        <li>
            <a href="{{ route('customers.index') }}">
                <div class="parent-icon"><i class='bx bx-user'></i></div>
                <div class="menu-title">Customers</div>
            </a>
        </li>

        <!-- Purchases -->
        @hasanyrole('purchaser|manager|admin')
        <li>
            <a href="{{ route('purchases.index') }}">
                <div class="parent-icon"><i class='bx bx-purchase-tag'></i></div>
                <div class="menu-title">Purchases</div>
            </a>
        </li>
        @endhasanyrole

        <!-- Suppliers -->
        @hasanyrole('purchaser|manager|admin')
        <li>
            <a href="{{ route('suppliers.index') }}">
                <div class="parent-icon"><i class='bx bx-store'></i></div>
                <div class="menu-title">Suppliers</div>
            </a>
        </li>
        @endhasanyrole

        <li class="menu-label">Analytics & Reports</li>

        <!-- Reports Dashboard -->
        @hasanyrole('manager|admin')
        <li>
            <a href="{{ route('reports.index') }}">
                <div class="parent-icon"><i class='bx bx-bar-chart-alt'></i></div>
                <div class="menu-title">Reports Dashboard</div>
            </a>
        </li>
        @endhasanyrole

        <!-- Analytics -->
        @hasanyrole('manager|admin')
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-line-chart'></i></div>
                <div class="menu-title">Analytics</div>
            </a>
            <ul>
                <li>
                    <a href="{{ route('reports.sales') }}">
                        <i class="bx bx-right-arrow-alt"></i>Sales Analytics
                    </a>
                </li>
                <li>
                    <a href="{{ route('reports.customers') }}">
                        <i class="bx bx-right-arrow-alt"></i>Customer Analytics
                    </a>
                </li>
                <li>
                    <a href="{{ route('reports.suppliers') }}">
                        <i class="bx bx-right-arrow-alt"></i>Supplier Analytics
                    </a>
                </li>
                <li>
                    <a href="{{ route('price-histories.analytics') }}">
                        <i class="bx bx-right-arrow-alt"></i>Price Analytics
                    </a>
                </li>
            </ul>
        </li>
        @endhasanyrole

        <li class="menu-label">System Management</li>

        <!-- Users Management -->
        @role('admin')
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class='bx bx-user-circle'></i></div>
                <div class="menu-title">Users</div>
            </a>
            <ul>
                <li>
                    <a href="{{ route('users.index') }}">
                        <i class="bx bx-right-arrow-alt"></i>All Users
                    </a>
                </li>
                <li>
                    <a href="{{ route('users.create') }}">
                        <i class="bx bx-user-plus"></i>Add New User
                    </a>
                </li>
                <li>
                    <a href="{{ route('users.statistics') }}">
                        <i class="bx bx-bar-chart"></i>User Statistics
                    </a>
                </li>
                <li>
                    <a href="{{ route('users.import') }}">
                        <i class="bx bx-import"></i>Import Users
                    </a>
                </li>
            </ul>
        </li>
        @endrole

        <!-- Settings -->
        @role('admin')
        <li>
            <a href="{{ route('settings.index') }}">
                <div class="parent-icon"><i class='bx bx-cog'></i></div>
                <div class="menu-title">Settings</div>
            </a>
        </li>
        @endrole

        <!-- Taxes -->
        @role('admin')
        <li>
            <a href="{{ route('taxes.index') }}">
                <div class="parent-icon"><i class='bx bx-receipt'></i></div>
                <div class="menu-title">Tax Settings</div>
            </a>
        </li>
        @endrole

        <!-- Activity Logs -->
        @role('admin')
        <li>
            <a href="{{ route('activities.index') }}">
                <div class="parent-icon"><i class='bx bx-history'></i></div>
                <div class="menu-title">Activity Logs</div>
            </a>
        </li>
        @endrole

        <!-- Printers -->
        @hasanyrole('manager|admin')
        <li>
            <a href="{{ route('printers.index') }}">
                <div class="parent-icon"><i class='bx bx-printer'></i></div>
                <div class="menu-title">Printers</div>
            </a>
        </li>
        @endhasanyrole

        <!-- M-Pesa -->
        @hasanyrole('manager|admin')
        <li>
            <a href="{{ route('mpesa.index') }}">
                <div class="parent-icon"><i class='bx bx-mobile-alt'></i></div>
                <div class="menu-title">M-Pesa</div>
            </a>
        </li>
        @endhasanyrole

        <li class="menu-label">Personal</li>

        <!-- Profile -->
        <li>
            <a href="{{ route('profile.edit') }}">
                <div class="parent-icon"><i class='bx bx-user'></i></div>
                <div class="menu-title">My Profile</div>
            </a>
        </li>



        <!-- Quick Search -->
        <li>
            <a href="javascript:;" onclick="toggleQuickSearch()">
                <div class="parent-icon"><i class='bx bx-search'></i></div>
                <div class="menu-title">Quick Search</div>
            </a>
        </li>

        <!-- Help & Support -->
        <li>
            <a href="#">
                <div class="parent-icon"><i class='bx bx-help-circle'></i></div>
                <div class="menu-title">Help & Support</div>
            </a>
        </li>
    </ul>
    <!--end navigation-->
</div>

<!-- Quick Search Modal -->
<div class="modal fade" id="quickSearchModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick Search</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="input-group mb-3">
                    <input type="text" class="form-control" id="globalSearch" placeholder="Search products, customers, sales...">
                    <button class="btn btn-primary" type="button">
                        <i class='bx bx-search'></i>
                    </button>
                </div>
                <div id="searchResults" class="mt-3">
                    <!-- Search results will appear here -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleQuickSearch() {
    $('#quickSearchModal').modal('show');
    $('#globalSearch').focus();
}

$(document).ready(function() {
    $('#globalSearch').on('keyup', function() {
        const query = $(this).val();
        if (query.length > 2) {
            $.ajax({
                url: '{{ route("ajax.products") }}',
                method: 'GET',
                data: { search: query },
                success: function(response) {
                    let html = '';
                    if (response.length > 0) {
                        html += '<h6>Products:</h6>';
                        response.forEach(product => {
                            html += `<a href="{{ route('products.index') }}/${product.id}" class="d-block text-decoration-none py-1">
                                <i class="bx bx-package me-2"></i>${product.name}
                                <span class="float-end text-muted">${product.code || ''}</span>
                            </a>`;
                        });
                    } else {
                        html = '<p class="text-muted">No results found</p>';
                    }
                    $('#searchResults').html(html);
                }
            });
        }
    });
});
</script>