<!--start header wrapper-->
<header>
    <div class="topbar d-flex align-items-center">
        <nav class="navbar navbar-expand">
            <div class="mobile-toggle-menu"><i class='bx bx-menu'></i></div>
            
            <!-- Search Bar -->
            <div class="search-bar flex-grow-1">
                <div class="position-relative search-bar-box">
                    <input type="text" class="form-control search-control" placeholder="Type to search..."> 
                    <span class="position-absolute top-50 search-show translate-middle-y"><i class='bx bx-search'></i></span>
                    <span class="position-absolute top-50 search-close translate-middle-y"><i class='bx bx-x'></i></span>
                </div>
            </div>
            
            <div class="top-menu ms-auto">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item mobile-search-icon">
                        <a class="nav-link" href="#">   
                            <i class='bx bx-search'></i>
                        </a>
                    </li>
                    
                    <!-- Quick Actions Dropdown -->
                    <li class="nav-item dropdown dropdown-large">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"> 
                            <i class='bx bx-category'></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <div class="row row-cols-3 g-3 p-3">
                                <!-- Sales -->
                                <div class="col text-center">
                                    <a href="{{ route('sales.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-cosmic text-white">
                                            <i class='bx bx-cart'></i>
                                        </div>
                                        <div class="app-title">Sales</div>
                                    </a>
                                </div>
                                <!-- Products -->
                                <div class="col text-center">
                                    <a href="{{ route('products.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-burning text-white">
                                            <i class='bx bx-package'></i>
                                        </div>
                                        <div class="app-title">Products</div>
                                    </a>
                                </div>
                                <!-- Customers -->
                                <div class="col text-center">
                                    <a href="{{ route('customers.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-lush text-white">
                                            <i class='bx bx-user'></i>
                                        </div>
                                        <div class="app-title">Customers</div>
                                    </a>
                                </div>
                                <!-- Reports -->
                                <div class="col text-center">
                                    <a href="{{ route('reports.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-kyoto text-dark">
                                            <i class='bx bx-stats'></i>
                                        </div>
                                        <div class="app-title">Reports</div>
                                    </a>
                                </div>
                                <!-- Purchases -->
                                <div class="col text-center">
                                    <a href="{{ route('purchases.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-blues text-dark">
                                            <i class='bx bx-package'></i>
                                        </div>
                                        <div class="app-title">Purchases</div>
                                    </a>
                                </div>
                                <!-- Suppliers -->
                                <div class="col text-center">
                                    <a href="{{ route('suppliers.index') ?? 'javascript:void(0);' }}" class="text-decoration-none">
                                        <div class="app-box mx-auto bg-gradient-moonlit text-white">
                                            <i class='bx bx-group'></i>
                                        </div>
                                        <div class="app-title">Suppliers</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    
                    <!-- Notifications -->
                    <li class="nav-item dropdown dropdown-large">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret position-relative" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"> 
                            <span class="alert-count">3</span>
                            <i class='bx bx-bell'></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a href="javascript:;">
                                <div class="msg-header">
                                    <p class="msg-header-title">Notifications</p>
                                    <p class="msg-header-clear ms-auto">Marks all as read</p>
                                </div>
                            </a>
                            <div class="header-notifications-list">
                                <a class="dropdown-item" href="{{ route('customers.index') ?? 'javascript:void(0);' }}">
                                    <div class="d-flex align-items-center">
                                        <div class="notify bg-light-primary text-primary">
                                            <i class="bx bx-group"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="msg-name">New Customers<span class="msg-time float-end">14 Sec ago</span></h6>
                                            <p class="msg-info">5 new customers registered</p>
                                        </div>
                                    </div>
                                </a>
                                <a class="dropdown-item" href="{{ route('sales.index') ?? 'javascript:void(0);' }}">
                                    <div class="d-flex align-items-center">
                                        <div class="notify bg-light-danger text-danger">
                                            <i class="bx bx-cart-alt"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="msg-name">New Orders <span class="msg-time float-end">2 min ago</span></h6>
                                            <p class="msg-info">You have received new orders</p>
                                        </div>
                                    </div>
                                </a>
                                <a class="dropdown-item" href="{{ route('products.index') ?? 'javascript:void(0);' }}">
                                    <div class="d-flex align-items-center">
                                        <div class="notify bg-light-success text-success">
                                            <i class="bx bx-package"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="msg-name">Low Stock<span class="msg-time float-end">19 min ago</span></h6>
                                            <p class="msg-info">5 products running low on stock</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <a href="javascript:;">
                                <div class="text-center msg-footer">View All Notifications</div>
                            </a>
                        </div>
                    </li>
                    
                    <!-- Messages -->
                    <li class="nav-item dropdown dropdown-large">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret position-relative" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"> 
                            <span class="alert-count">2</span>
                            <i class='bx bx-comment'></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a href="javascript:;">
                                <div class="msg-header">
                                    <p class="msg-header-title">Messages</p>
                                    <p class="msg-header-clear ms-auto">Marks all as read</p>
                                </div>
                            </a>
                            <div class="header-message-list">
                                <!-- Sample Messages -->
                                <a class="dropdown-item" href="javascript:;">
                                    <div class="d-flex align-items-center">
                                        <div class="user-online">
                                            <i class="bx bx-user-circle text-primary fs-4"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="msg-name">Customer Inquiry <span class="msg-time float-end">5 sec ago</span></h6>
                                            <p class="msg-info">New product inquiry from customer</p>
                                        </div>
                                    </div>
                                </a>
                                <a class="dropdown-item" href="javascript:;">
                                    <div class="d-flex align-items-center">
                                        <div class="user-online">
                                            <i class="bx bx-user-circle text-success fs-4"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="msg-name">Supplier Message <span class="msg-time float-end">14 sec ago</span></h6>
                                            <p class="msg-info">New shipment arriving tomorrow</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <a href="javascript:;">
                                <div class="text-center msg-footer">View All Messages</div>
                            </a>
                        </div>
                    </li>
                </ul>
            </div>
            
            <!-- User Profile -->
            <div class="user-box dropdown">
                <a class="d-flex align-items-center nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    @if(Auth::check() && Auth::user()->profile_image)
                        <img src="{{ Auth::user()->profile_image_url }}" class="user-img" alt="user avatar"
                             onerror="this.src='{{ asset('assets/images/avatars/avatar-2.png') }}'">
                    @else
                        <img src="{{ asset('assets/images/avatars/avatar-2.png') }}" class="user-img" alt="user avatar">
                    @endif
                    <div class="user-info ps-3">
                        <p class="user-name mb-0">{{ Auth::check() ? Auth::user()->name : 'Guest' }}</p>
                        <p class="designation mb-0">
                            @if(Auth::check())
                                {{ ucfirst(Auth::user()->roles->pluck('name')->first() ?? 'User') }}
                            @else
                                User
                            @endif
                        </p>
                    </div>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="{{ route('profile.edit') ?? 'javascript:void(0);' }}">
                            <i class="bx bx-user"></i>
                            <span>Profile</span>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('dashboard') ?? 'javascript:void(0);' }}">
                            <i class='bx bx-home-circle'></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <div class="dropdown-divider mb-0"></div>
                    </li>
                    <li>
                        @if(Auth::check())
                            <form method="POST" action="{{ route('logout') }}" id="logout-form">
                                @csrf
                                <button type="submit" class="dropdown-item" style="background: none; border: none; width: 100%; text-align: left;">
                                    <i class='bx bx-log-out-circle'></i>
                                    <span>Logout</span>
                                </button>
                            </form>
                        @else
                            <a class="dropdown-item" href="{{ route('login') }}">
                                <i class='bx bx-log-in-circle'></i>
                                <span>Login</span>
                            </a>
                        @endif
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>
<!-- Page wrapper end -->

@push('script')
<script>
$(document).ready(function() {
    // Search functionality
    $('.search-show').click(function() {
        $('.search-bar-box').addClass('searching');
        $('.search-control').focus();
    });

    $('.search-close').click(function() {
        $('.search-bar-box').removeClass('searching');
        $('.search-control').val('');
    });

    // Mobile search
    $('.mobile-search-icon a').click(function(e) {
        e.preventDefault();
        $('.search-bar-box').toggleClass('searching');
        if ($('.search-bar-box').hasClass('searching')) {
            $('.search-control').focus();
        }
    });

    // Logout confirmation
    $('#logout-form').submit(function(e) {
        e.preventDefault();
        if (confirm('Are you sure you want to logout?')) {
            this.submit();
        }
    });

    // Close dropdowns when clicking outside
    $(document).click(function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').removeClass('show');
        }
    });

    // Toggle mobile menu
    $('.mobile-toggle-menu').click(function() {
        $('.wrapper').toggleClass('toggled');
    });

    // Initialize tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();
});
</script>

<style>
/* Search functionality styles */
.search-bar-box.searching .search-control {
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.search-bar-box.searching .search-close {
    opacity: 1;
    pointer-events: all;
}

.search-close {
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s;
}

/* User image fallback */
.user-img {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    object-fit: cover;
}

/* Dropdown styles */
.dropdown-menu {
    min-width: 300px;
    border: 1px solid rgba(0,0,0,.15);
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
}

/* App boxes */
.app-box {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 5px;
    transition: transform 0.2s;
}

.app-box:hover {
    transform: translateY(-2px);
}

.app-title {
    font-size: 12px;
    margin-top: 5px;
    color: #6c757d;
}

/* Notification styles */
.alert-count {
    position: absolute;
    top: 0;
    right: 0;
    transform: translate(25%, -25%);
    background: #dc3545;
    color: white;
    border-radius: 50%;
    width: 18px;
    height: 18px;
    font-size: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.notify {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 10px;
    flex-shrink: 0;
}

/* Mobile responsiveness */
@media (max-width: 768px) {
    .dropdown-menu {
        position: fixed !important;
        top: 60px !important;
        left: 10px !important;
        right: 10px !important;
        width: auto !important;
    }
}
</style>
@endpush