@extends("layouts.app")
@section("style")
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <style>
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .chart-container {
            min-height: 150px;
        }
    </style>
@endsection

@section("content")
    <div class="page-wrapper">
        <div class="page-content">
            <!-- Start breadcrumb -->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">Dashboard</div>
                <div class="ps-3">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0 p-0">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                            <li class="breadcrumb-item active" aria-current="page">Overview</li>
                        </ol>
                    </nav>
                </div>
                <div class="ms-auto">
                    <div class="btn-group">
                        <button type="button" class="btn btn-primary" onclick="refreshDashboard()">
                            <i class="bx bx-refresh"></i> Refresh
                        </button>
                    </div>
                </div>
            </div>
            <!-- End breadcrumb -->

            <!-- Statistics Cards -->
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 mb-4">
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Total Revenue</p>
                                    <h4 class="my-1 text-primary" id="totalRevenue">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="revenueChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-primary text-primary ms-auto">
                                    <i class='bx bxs-wallet'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="revenueChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-success">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Total Sales</p>
                                    <h4 class="my-1 text-success" id="totalSales">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="salesChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-success text-success ms-auto">
                                    <i class='bx bx-cart-alt'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="salesChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-warning">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Total Customers</p>
                                    <h4 class="my-1 text-warning" id="totalCustomers">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="customersChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-warning text-warning ms-auto">
                                    <i class='bx bx-group'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="customersChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-info">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Total Products</p>
                                    <h4 class="my-1 text-info" id="totalProducts">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="productsChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-info text-info ms-auto">
                                    <i class='bx bx-package'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="productsChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-danger">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Today's Sales</p>
                                    <h4 class="my-1 text-danger" id="todaySales">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="todaySalesChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-danger text-danger ms-auto">
                                    <i class='bx bx-calendar'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="todayChart"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col">
                    <div class="card radius-10 stat-card border-start border-0 border-3 border-secondary">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Pending Orders</p>
                                    <h4 class="my-1 text-secondary" id="pendingOrders">
                                        {{-- Data will be loaded via AJAX --}}
                                    </h4>
                                    <p class="mb-0 font-13" id="pendingOrdersChange">
                                        {{-- Data will be loaded via AJAX --}}
                                    </p>
                                </div>
                                <div class="widgets-icons bg-light-secondary text-secondary ms-auto">
                                    <i class='bx bx-time'></i>
                                </div>
                            </div>
                            <div class="chart-container mt-3" id="pendingChart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end row-->

            <!-- Dashboard Content -->
            <div class="row">
                <!-- Sales Overview Chart -->
                <div class="col-xl-8 d-flex">
                    <div class="card radius-10 w-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Sales Overview</h5>
                                    <p class="mb-0 font-13 text-secondary">
                                        <i class='bx bxs-calendar'></i> Last 30 days
                                    </p>
                                </div>
                                <div class="dropdown ms-auto">
                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        Last 30 days
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(7)">Last 7 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(30)">Last 30 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(90)">Last 90 days</a></li>
                                        <li><a class="dropdown-item" href="#" onclick="changePeriod(365)">Last Year</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div id="salesOverviewChart" style="min-height: 300px;"></div>
                        </div>
                    </div>
                </div>

                <!-- Recent Activities -->
                <div class="col-xl-4">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Recent Activities</h5>
                                </div>
                                <div class="font-22 ms-auto"><i class='bx bx-dots-horizontal-rounded'></i></div>
                            </div>
                            <div class="activities-list mt-3" id="recentActivities">
                                {{-- Activities will be loaded via AJAX --}}
                                <div class="text-center py-4">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Low Stock Products -->
                    <div class="card radius-10 mt-3">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Low Stock Products</h5>
                                </div>
                                <div class="font-22 ms-auto"><i class='bx bx-dots-horizontal-rounded'></i></div>
                            </div>
                            <div class="mt-3" id="lowStockProducts">
                                {{-- Low stock products will be loaded via AJAX --}}
                                <div class="text-center py-4">
                                    <div class="spinner-border text-warning" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end row-->

            <!-- Recent Sales & Top Products -->
            <div class="row mt-3">
                <!-- Recent Sales -->
                <div class="col-xl-8 d-flex">
                    <div class="card radius-10 w-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Recent Sales</h5>
                                    <p class="mb-0 font-13 text-secondary">
                                        <i class='bx bxs-calendar'></i> Today's transactions
                                    </p>
                                </div>
                                <div class="font-22 ms-auto">
                                    <a href="{{ route('sales.index') }}" class="text-primary">View All</a>
                                </div>
                            </div>
                            <div class="table-responsive mt-4">
                                <table class="table align-middle mb-0 table-hover" id="recentSalesTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Invoice No</th>
                                            <th>Customer</th>
                                            <th>Date & Time</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody id="recentSalesBody">
                                        {{-- Recent sales will be loaded via AJAX --}}
                                        <tr>
                                            <td colspan="5" class="text-center py-4">
                                                <div class="spinner-border text-primary" role="status">
                                                    <span class="visually-hidden">Loading...</span>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Top Products -->
                <div class="col-xl-4 d-flex">
                    <div class="card radius-10 w-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Top Products</h5>
                                    <p class="mb-0 font-13 text-secondary">
                                        <i class='bx bxs-calendar'></i> Best sellers
                                    </p>
                                </div>
                                <div class="font-22 ms-auto">
                                    <a href="{{ route('products.index') }}" class="text-primary">View All</a>
                                </div>
                            </div>
                            <div class="product-list p-3 mb-3" id="topProducts">
                                {{-- Top products will be loaded via AJAX --}}
                                <div class="text-center py-4">
                                    <div class="spinner-border text-success" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--end row-->

            <!-- Quick Actions -->
            <div class="row mt-3">
                <div class="col-12">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h5 class="mb-1">Quick Actions</h5>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-md-3 col-6 mb-3">
                                    <a href="{{ route('pos.index') }}" class="btn btn-primary w-100 d-flex flex-column align-items-center py-3">
                                        <i class='bx bx-cart-add mb-2' style="font-size: 2rem;"></i>
                                        <span>New Sale</span>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-3">
                                    <a href="{{ route('purchases.create') }}" class="btn btn-success w-100 d-flex flex-column align-items-center py-3">
                                        <i class='bx bx-package mb-2' style="font-size: 2rem;"></i>
                                        <span>New Purchase</span>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-3">
                                    <a href="{{ route('customers.create') }}" class="btn btn-info w-100 d-flex flex-column align-items-center py-3">
                                        <i class='bx bx-user-plus mb-2' style="font-size: 2rem;"></i>
                                        <span>Add Customer</span>
                                    </a>
                                </div>
                                <div class="col-md-3 col-6 mb-3">
                                    <a href="{{ route('products.create') }}" class="btn btn-warning w-100 d-flex flex-column align-items-center py-3">
                                        <i class='bx bx-plus mb-2' style="font-size: 2rem;"></i>
                                        <span>Add Product</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

// Replace the entire script section in your blade file with this:

@section("script")
    <script src="{{ asset('assets/plugins/apexcharts-bundle/js/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/apexcharts-bundle/js/apexcharts.min.js') }}"></script>

    
    <script>

        
        // Global currency configuration
        const CURRENCY = {
            symbol: 'KES ',
            decimalPlaces: 2,
            thousandsSeparator: ',',
            decimalSeparator: '.'
        };

        $(document).ready(function() {
            loadDashboardData();
            loadRecentActivities();
            loadLowStockProducts();
            loadRecentSales();
            loadTopProducts();
            
            // Refresh dashboard every 30 seconds
            setInterval(loadDashboardData, 30000);
        });

        function refreshDashboard() {
            loadDashboardData();
            loadRecentActivities();
            loadLowStockProducts();
            loadRecentSales();
            loadTopProducts();
            
            // Show success message
            showNotification('success', 'Dashboard refreshed successfully!');
        }

        function changePeriod(days) {
            loadDashboardData(days);
            $('.dropdown-toggle').text('Last ' + days + ' days');
        }

        function loadDashboardData(period = 30) {
            $.ajax({
                url: '{{ route("dashboard.data") }}',
                method: 'GET',
                data: { period: period },
                success: function(response) {
                    // Update currency configuration from server if provided
                    if (response.currency) {
                        Object.assign(CURRENCY, response.currency);
                    }
                    
                    // Update statistics cards
                    updateStatCard('totalRevenue', response.total_revenue, response.revenue_change, 'primary');
                    updateStatCard('totalSales', response.total_sales, response.sales_change, 'success');
                    updateStatCard('totalCustomers', response.total_customers, response.customers_change, 'warning');
                    updateStatCard('totalProducts', response.total_products, response.products_change, 'info');
                    updateStatCard('todaySales', response.today_sales, response.today_sales_change, 'danger');
                    updateStatCard('pendingOrders', response.pending_orders, response.pending_orders_change, 'secondary');
                    
                    // Update sales overview chart
                    updateSalesOverviewChart(response.sales_overview);
                },
                error: function(xhr) {
                    console.error('Error loading dashboard data:', xhr);
                    showNotification('error', 'Failed to load dashboard data');
                }
            });
        }

        function updateStatCard(elementId, value, change, colorClass) {
            // Use formatted values from server if available, otherwise format locally
            if (elementId === 'totalRevenue' || elementId === 'todaySales') {
                // For currency values
                const formattedValue = formatCurrency(value);
                $('#' + elementId).html(formattedValue);
            } else {
                // For count values (non-currency)
                $('#' + elementId).text(value.toLocaleString());
            }
            
            const changeElement = $('#' + elementId.replace('total', '').replace('today', '').replace('pending', '') + 'Change');
            if (change >= 0) {
                changeElement.html('<i class="bx bxs-up-arrow align-middle"></i>' + change + '% Since last period')
                    .removeClass('text-danger').addClass('text-success');
            } else {
                changeElement.html('<i class="bx bxs-down-arrow align-middle"></i>' + Math.abs(change) + '% Since last period')
                    .removeClass('text-success').addClass('text-danger');
            }
        }

        function formatCurrency(amount) {
            // Format with KES currency
            return CURRENCY.symbol + 
                parseFloat(amount).toLocaleString('en-KE', {
                    minimumFractionDigits: CURRENCY.decimalPlaces,
                    maximumFractionDigits: CURRENCY.decimalPlaces
                });
            
            // Alternative manual formatting:
            // return CURRENCY.symbol + 
            //     parseFloat(amount).toFixed(CURRENCY.decimalPlaces)
            //         .replace(/\B(?=(\d{3})+(?!\d))/g, CURRENCY.thousandsSeparator);
        }

        function updateSalesOverviewChart(data) {
            if (data && data.labels && data.series) {
                // Destroy previous chart if exists
                if (window.salesChart) {
                    window.salesChart.destroy();
                }

                const options = {
                    series: [{
                        name: 'Sales',
                        data: data.series
                    }],
                    chart: {
                        height: 300,
                        type: 'area',
                        toolbar: {
                            show: false
                        }
                    },
                    colors: ['#4CAF50'],
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 2
                    },
                    xaxis: {
                        categories: data.labels,
                        labels: {
                            style: {
                                colors: '#6c757d',
                                fontSize: '12px'
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            formatter: function(val) {
                                return CURRENCY.symbol + val.toLocaleString('en-KE', {
                                    minimumFractionDigits: 0,
                                    maximumFractionDigits: 0
                                });
                            },
                            style: {
                                colors: '#6c757d',
                                fontSize: '12px'
                            }
                        }
                    },
                    tooltip: {
                        y: {
                            formatter: function(val) {
                                return CURRENCY.symbol + val.toLocaleString('en-KE', {
                                    minimumFractionDigits: 2,
                                    maximumFractionDigits: 2
                                });
                            }
                        }
                    },
                    grid: {
                        borderColor: '#e0e0e0',
                        strokeDashArray: 5
                    }
                };

                window.salesChart = new ApexCharts(document.querySelector("#salesOverviewChart"), options);
                window.salesChart.render();
            }
        }

        function loadRecentActivities() {
            $.ajax({
                url: '{{ route("dashboard.activities") }}',
                method: 'GET',
                success: function(response) {
                    $('#recentActivities').html(response);
                },
                error: function(xhr) {
                    $('#recentActivities').html(`
                        <div class="text-center py-4 text-danger">
                            <i class='bx bx-error-circle' style="font-size: 3rem;"></i>
                            <p class="mt-2">Failed to load activities</p>
                        </div>
                    `);
                }
            });
        }

        function loadLowStockProducts() {
            $.ajax({
                url: '{{ route("dashboard.low-stock") }}',
                method: 'GET',
                success: function(response) {
                    $('#lowStockProducts').html(response);
                },
                error: function(xhr) {
                    $('#lowStockProducts').html(`
                        <div class="text-center py-4 text-danger">
                            <i class='bx bx-error-circle' style="font-size: 3rem;"></i>
                            <p class="mt-2">Failed to load low stock products</p>
                        </div>
                    `);
                }
            });
        }

        function loadRecentSales() {
            $.ajax({
                url: '{{ route("dashboard.recent-sales") }}',
                method: 'GET',
                success: function(response) {
                    $('#recentSalesBody').html(response);
                },
                error: function(xhr) {
                    $('#recentSalesBody').html(`
                        <tr>
                            <td colspan="5" class="text-center py-4 text-danger">
                                <i class='bx bx-error-circle'></i> Failed to load recent sales
                            </td>
                        </tr>
                    `);
                }
            });
        }

        function loadTopProducts() {
            $.ajax({
                url: '{{ route("dashboard.top-products") }}',
                method: 'GET',
                success: function(response) {
                    $('#topProducts').html(response);
                },
                error: function(xhr) {
                    $('#topProducts').html(`
                        <div class="text-center py-4 text-danger">
                            <i class='bx bx-error-circle' style="font-size: 3rem;"></i>
                            <p class="mt-2">Failed to load top products</p>
                        </div>
                    `);
                }
            });
        }

        function showNotification(type, message) {
            // Check if SweetAlert is available
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: type,
                    title: message,
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true
                });
            } else {
                // Fallback to basic alert
                alert(message);
            }
        }
    </script>
@endsection