// POS Printer Management Module
// =========================================================

class POSPrinter {
    static async checkConnection() {
        if (!window.posState.printerSettings?.auto_check_printer) return;
        
        try {
            const response = await fetch('/api/printer/check');
            const data = await response.json();
            
            if (!data.connected) {
                POSUtils.showToast('Printer not connected', 'warning');
            }
        } catch (error) {
            console.error('Printer check error:', error);
        }
    }
    
    static async printTest() {
        try {
            POSUtils.showLoading(true);
            
            const response = await fetch('/api/print/test', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                }
            });
            
            const data = await response.json();
            POSUtils.showLoading(false);
            
            if (data.success) {
                POSUtils.showToast('Test print sent successfully', 'success');
            } else {
                POSUtils.showToast('Test print failed: ' + data.error, 'error');
            }
        } catch (error) {
            POSUtils.showLoading(false);
            console.error('Test print error:', error);
            POSUtils.showToast('Test print failed', 'error');
        }
    }
    
    static async printReceipt(saleId) {
        try {
            const response = await fetch(`/api/print/thermal/${saleId}`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                }
            });
            
            const data = await response.json();
            
            if (data.success) {
                POSUtils.showToast('Receipt sent to printer', 'success');
                return true;
            } else {
                POSUtils.showToast('Print failed: ' + data.error, 'error');
                return false;
            }
        } catch (error) {
            console.error('Print error:', error);
            POSUtils.showToast('Print failed', 'error');
            return false;
        }
    }
    
    static async printInvoice(invoiceId) {
        try {
            const response = await fetch(`/api/print/invoice/${invoiceId}`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                }
            });
            
            const data = await response.json();
            
            if (data.success) {
                POSUtils.showToast('Invoice sent to printer', 'success');
                return true;
            } else {
                POSUtils.showToast('Print failed: ' + data.error, 'error');
                return false;
            }
        } catch (error) {
            console.error('Invoice print error:', error);
            POSUtils.showToast('Invoice print failed', 'error');
            return false;
        }
    }
    
    static async printZReport() {
        if (!confirm('Print Z-Report? This will close the current day.')) {
            return;
        }
        
        try {
            POSUtils.showLoading(true);
            
            const response = await fetch('/api/print/z-report', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                }
            });
            
            const data = await response.json();
            POSUtils.showLoading(false);
            
            if (data.success) {
                POSUtils.showToast('Z-Report printed successfully', 'success');
            } else {
                POSUtils.showToast('Z-Report print failed: ' + data.error, 'error');
            }
        } catch (error) {
            POSUtils.showLoading(false);
            console.error('Z-Report error:', error);
            POSUtils.showToast('Z-Report print failed', 'error');
        }
    }
    
    static async printXReport() {
        try {
            POSUtils.showLoading(true);
            
            const response = await fetch('/api/print/x-report', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                }
            });
            
            const data = await response.json();
            POSUtils.showLoading(false);
            
            if (data.success) {
                POSUtils.showToast('X-Report printed successfully', 'success');
            } else {
                POSUtils.showToast('X-Report print failed: ' + data.error, 'error');
            }
        } catch (error) {
            POSUtils.showLoading(false);
            console.error('X-Report error:', error);
            POSUtils.showToast('X-Report print failed', 'error');
        }
    }
    
    static async configure(settings) {
        try {
            const response = await fetch('/api/printer/configure', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                },
                body: JSON.stringify(settings)
            });
            
            const data = await response.json();
            
            if (data.success) {
                POSUtils.showToast('Printer configured successfully', 'success');
                return true;
            } else {
                POSUtils.showToast('Printer configuration failed: ' + data.error, 'error');
                return false;
            }
        } catch (error) {
            console.error('Printer configuration error:', error);
            POSUtils.showToast('Printer configuration failed', 'error');
            return false;
        }
    }
}

// Export for global access
window.POSPrinter = POSPrinter;