<?php
// database/seeders/TaxSeeder.php
namespace Database\Seeders;

use App\Models\Tax;
use Illuminate\Database\Seeder;

class TaxSeeder extends Seeder
{
    public function run(): void
    {
        $taxes = [
            [
                'name' => 'VAT Standard Rate',
                'code' => 'VAT-16',
                'rate' => 16.00,
                'is_default' => true,
                'is_active' => true,
                'description' => 'Standard VAT rate for most goods and services',
            ],
            [
                'name' => 'Zero Rated',
                'code' => 'ZERO',
                'rate' => 0.00,
                'is_default' => false,
                'is_active' => true,
                'description' => 'Zero-rated VAT for essential items and exports',
            ],
            [
                'name' => 'VAT Exempt',
                'code' => 'EXEMPT',
                'rate' => 0.00,
                'is_default' => false,
                'is_active' => true,
                'description' => 'VAT exempt goods and services (not the same as zero-rated)',
            ],
            [
                'name' => 'VAT Reduced Rate',
                'code' => 'VAT-8',
                'rate' => 8.00,
                'is_default' => false,
                'is_active' => true,
                'description' => 'Reduced VAT rate for specific items',
            ],
        ];

        foreach ($taxes as $tax) {
            Tax::create($tax);
        }
    }
}