<?php

namespace Database\Seeders;

use App\Models\Printer;
use Illuminate\Database\Seeder;

class PrinterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default thermal printer
        Printer::create([
            'name' => 'Main POS Printer',
            'alias' => 'POS-001',
            'description' => 'Primary thermal printer for POS receipts',
            'connection_type' => 'network',
            'ip_address' => '192.168.1.100',
            'port' => 9100,
            'paper_size' => '80mm',
            'chars_per_line' => 42,
            'auto_cut' => true,
            'auto_open_drawer' => true,
            'print_density' => 15,
            'print_speed' => 3,
            'encoding' => 'CP850',
            'supports_graphics' => true,
            'supports_barcode' => true,
            'supports_qr_code' => true,
            'has_cutter' => true,
            'has_drawer_kick' => true,
            'drawer_pin' => '2',
            'drawer_pulse_time' => 100,
            'print_store_logo' => false,
            'print_barcode_on_receipt' => true,
            'print_qr_on_receipt' => true,
            'is_default' => true,
            'is_active' => true,
            'status' => 'online',
            'location' => 'Counter 1',
            'department' => 'Sales',
            'timeout' => 30,
            'retry_count' => 3,
            'max_job_queue' => 10,
            'enable_queue' => true,
            'enable_retry' => true,
            'maintenance_interval' => 30,
            'operational_cost_per_print' => 0.05,
            'capabilities' => [
                'barcode_types' => ['CODE39', 'CODE128', 'EAN13', 'EAN8'],
                'qr_sizes' => [1, 2, 3, 4, 5, 6, 7, 8],
                'fonts' => ['Font A', 'Font B'],
                'character_sets' => ['CP850', 'CP437', 'CP858'],
            ],
        ]);

        // Create backup printer
        Printer::create([
            'name' => 'Backup POS Printer',
            'alias' => 'POS-002',
            'description' => 'Backup thermal printer',
            'connection_type' => 'usb',
            'device_path' => '/dev/usb/lp0',
            'paper_size' => '80mm',
            'chars_per_line' => 42,
            'auto_cut' => true,
            'auto_open_drawer' => false,
            'print_density' => 15,
            'print_speed' => 3,
            'encoding' => 'CP850',
            'supports_graphics' => true,
            'supports_barcode' => true,
            'supports_qr_code' => false,
            'has_cutter' => true,
            'has_drawer_kick' => false,
            'print_store_logo' => false,
            'print_barcode_on_receipt' => true,
            'print_qr_on_receipt' => false,
            'is_default' => false,
            'is_active' => true,
            'status' => 'online',
            'location' => 'Counter 2',
            'department' => 'Sales',
            'timeout' => 30,
            'retry_count' => 3,
            'max_job_queue' => 5,
            'enable_queue' => true,
            'enable_retry' => true,
            'maintenance_interval' => 30,
            'operational_cost_per_print' => 0.05,
        ]);

        // Create report printer (A4)
        Printer::create([
            'name' => 'Report Printer',
            'alias' => 'REP-001',
            'description' => 'Laser printer for reports and documents',
            'connection_type' => 'network',
            'ip_address' => '192.168.1.101',
            'port' => 9100,
            'paper_size' => 'A4',
            'chars_per_line' => 80,
            'auto_cut' => false,
            'auto_open_drawer' => false,
            'print_density' => 10,
            'print_speed' => 2,
            'encoding' => 'UTF-8',
            'supports_graphics' => true,
            'supports_barcode' => false,
            'supports_qr_code' => false,
            'has_cutter' => false,
            'has_drawer_kick' => false,
            'print_store_logo' => true,
            'logo_path' => '/storage/logos/store_logo.png',
            'print_barcode_on_receipt' => false,
            'print_qr_on_receipt' => false,
            'is_default' => false,
            'is_active' => true,
            'status' => 'online',
            'location' => 'Manager Office',
            'department' => 'Administration',
            'timeout' => 60,
            'retry_count' => 2,
            'max_job_queue' => 20,
            'enable_queue' => true,
            'enable_retry' => true,
            'maintenance_interval' => 90,
            'operational_cost_per_print' => 0.15,
        ]);
    }
}