<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PaymentMethod;

class PaymentMethodSeeder extends Seeder
{
    public function run()
    {
        $methods = [
            [
                'name' => 'Cash',
                'code' => 'cash',
                'type' => 'cash',
                'provider' => 'cash',
                'is_active' => true,
                'requires_confirmation' => false,
                'sort_order' => 1,
                'icon' => 'money',
                'description' => 'Cash payment',
                'config' => [],
            ],
            [
                'name' => 'M-Pesa',
                'code' => 'mpesa',
                'type' => 'mobile',
                'provider' => 'mpesa',
                'is_active' => true,
                'requires_confirmation' => true,
                'sort_order' => 2,
                'icon' => 'mobile-alt',
                'description' => 'M-Pesa mobile money',
                'config' => [
                    'business_shortcode' => env('MPESA_BUSINESS_SHORTCODE'),
                    'stk_push_enabled' => true,
                    'manual_entry_enabled' => true,
                ],
            ],
            [
                'name' => 'Card',
                'code' => 'card',
                'type' => 'card',
                'provider' => 'card',
                'is_active' => true,
                'requires_confirmation' => true,
                'sort_order' => 3,
                'icon' => 'credit-card',
                'description' => 'Credit/Debit card',
                'config' => [
                    'supported_types' => ['visa', 'mastercard', 'amex'],
                    'swipe_enabled' => true,
                    'chip_enabled' => true,
                ],
            ],
            [
                'name' => 'Credit Sale',
                'code' => 'credit',
                'type' => 'credit',
                'provider' => 'credit',
                'is_active' => true,
                'requires_confirmation' => true,
                'sort_order' => 4,
                'icon' => 'receipt',
                'description' => 'Credit sale (pay later)',
                'config' => [
                    'default_terms' => 30,
                    'max_terms' => 90,
                    'requires_approval' => true,
                ],
            ],
            [
                'name' => 'Bank Transfer',
                'code' => 'bank',
                'type' => 'bank',
                'provider' => 'bank',
                'is_active' => true,
                'requires_confirmation' => true,
                'sort_order' => 5,
                'icon' => 'bank',
                'description' => 'Bank transfer/EFT',
                'config' => [
                    'supported_banks' => ['equity', 'kcb', 'cooperative', 'family'],
                    'auto_verify' => false,
                ],
            ],
            [
                'name' => 'Cheque',
                'code' => 'cheque',
                'type' => 'bank',
                'provider' => 'cheque',
                'is_active' => true,
                'requires_confirmation' => true,
                'sort_order' => 6,
                'icon' => 'file-text',
                'description' => 'Cheque payment',
                'config' => [
                    'clearing_days' => 3,
                    'require_bank_details' => true,
                ],
            ],
            [
                'name' => 'Airtel Money',
                'code' => 'airtel',
                'type' => 'mobile',
                'provider' => 'airtel',
                'is_active' => false,
                'requires_confirmation' => true,
                'sort_order' => 7,
                'icon' => 'mobile',
                'description' => 'Airtel Money',
                'config' => [],
            ],
        ];

        foreach ($methods as $method) {
            PaymentMethod::updateOrCreate(
                ['code' => $method['code']],
                $method
            );
        }

        $this->command->info('Payment methods seeded successfully.');
    }
}