<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MpesaCredential;
use Illuminate\Support\Facades\Crypt;

class MpesaCredentialSeeder extends Seeder
{
    public function run(): void
    {
        // Check if table exists
        if (!\Schema::hasTable('mpesa_credentials')) {
            $this->command->info('Mpesa credentials table does not exist.');
            return;
        }

        // Check if already seeded
        if (MpesaCredential::count() > 0) {
            $this->command->info('Mpesa credentials already seeded.');
            return;
        }

        // Create sandbox credentials for testing
        MpesaCredential::create([
            'name' => 'Sandbox M-Pesa',
            'business_shortcode' => '174379',
            'consumer_key' => Crypt::encryptString('sandbox_consumer_key'),
            'consumer_secret' => Crypt::encryptString('sandbox_consumer_secret'),
            'passkey' => Crypt::encryptString('bfb279f9aa9bdbcf158e97dd71a467cd2e0c893059b10f78e6b72ada1ed2c919'),
            'initiator_name' => 'testapi',
            'initiator_password' => Crypt::encryptString('Safaricom999!*!'),
            'environment' => 'sandbox',
            'callback_url' => 'https://yourdomain.com/mpesa/callback',
            'is_active' => false, // Set to true when you have real credentials
            'notes' => 'Daraja API sandbox credentials. Replace with live credentials for production.',
        ]);

        $this->command->info('M-Pesa credentials seeded successfully.');
        $this->command->info('⚠️  Remember to update with your real Safaricom credentials for production.');
    }
}