<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use Illuminate\Support\Str;

class FixCategoriesDataSeeder extends Seeder
{
    public function run(): void
    {
        // Fix all categories to have proper data
        Category::withTrashed()->chunk(100, function ($categories) {
            foreach ($categories as $category) {
                $updates = [];
                
                // Ensure slug exists
                if (empty($category->slug)) {
                    $slug = Str::slug($category->name);
                    $originalSlug = $slug;
                    $count = 1;
                    while (Category::where('slug', $slug)->where('id', '!=', $category->id)->exists()) {
                        $slug = $originalSlug . '-' . $count++;
                    }
                    $updates['slug'] = $slug;
                }
                
                // Migrate status to is_active if needed
                if (isset($category->status)) {
                    $updates['is_active'] = $category->status === 'active';
                }
                
                // Set default color if not set
                if (empty($category->color)) {
                    $colors = [
                        '#667eea', '#764ba2', '#f093fb', '#4facfe', '#00f2fe',
                        '#43e97b', '#38f9d7', '#fa709a', '#fee140', '#fa709a',
                        '#ff6b6b', '#4ecdc4', '#45b7d1', '#96ceb4', '#ffeaa7',
                        '#dda0dd', '#98d8c8', '#f7b731', '#eb3b5a', '#26de81'
                    ];
                    
                    $hash = crc32($category->name);
                    $index = abs($hash) % count($colors);
                    $updates['color'] = $colors[$index];
                }
                
                // Update if there are changes
                if (!empty($updates)) {
                    $category->update($updates);
                }
            }
        });
        
        $this->command->info('Categories data fixed successfully.');
    }
}