<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('sales', function (Blueprint $table) {
            // Check if column exists before renaming
            if (Schema::hasColumn('sales', 'change')) {
                $table->renameColumn('change', 'customer_change');
            }
            
            // Also rename in the query
            // Update the PaymentController to use 'customer_change' instead of 'change'
        });
    }

    public function down()
    {
        Schema::table('sales', function (Blueprint $table) {
            if (Schema::hasColumn('sales', 'customer_change')) {
                $table->renameColumn('customer_change', 'change');
            }
        });
    }
};