<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // Ensure consistency between has_vat and tax_id
        DB::statement("
            UPDATE products 
            SET has_vat = 0 
            WHERE tax_id IS NULL AND has_vat = 1
        ");
        
        DB::statement("
            UPDATE products 
            SET has_vat = 1 
            WHERE tax_id IS NOT NULL AND has_vat = 0
        ");
    }

    public function down()
    {
        // No rollback needed
    }
};
