<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('receipt_settings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable()->comment('Receipt setting name');
            $table->string('paper_size')->default('80mm')->comment('80mm, A4, A5, etc');
            $table->integer('chars_per_line')->default(42);
            $table->string('encoding')->default('CP850');
            $table->boolean('auto_cut')->default(true);
            $table->boolean('auto_open_drawer')->default(false);
            $table->boolean('print_store_logo')->default(false);
            $table->string('logo_path')->nullable();
            $table->boolean('print_store_name')->default(true);
            $table->boolean('print_store_address')->default(true);
            $table->boolean('print_store_phone')->default(true);
            $table->boolean('print_vat_number')->default(true);
            $table->boolean('print_branch_code')->default(true);
            $table->boolean('print_cashier_name')->default(true);
            $table->boolean('print_date_time')->default(true);
            $table->boolean('print_transaction_number')->default(true);
            $table->boolean('print_customer_info')->default(false);
            $table->boolean('print_item_barcode')->default(false);
            $table->boolean('print_qr_code')->default(true);
            $table->string('qr_code_type')->default('store_info')->comment('store_info, transaction_id, payment_link');
            $table->boolean('print_tax_breakdown')->default(true);
            $table->boolean('print_discounts')->default(true);
            $table->boolean('print_payment_method')->default(true);
            $table->boolean('print_change_amount')->default(true);
            $table->string('footer_text')->nullable()->default('Thank you for shopping with us!');
            $table->boolean('print_footer')->default(true);
            $table->integer('copies')->default(1);
            $table->boolean('is_default')->default(false);
            $table->boolean('is_active')->default(true);
            $table->json('custom_settings')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('receipt_settings');
    }
};