<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        // 1. Fix purchase_id column type (unsignedBigInt) without DBAL
        DB::statement("ALTER TABLE service_purchase_logs MODIFY purchase_id BIGINT UNSIGNED NOT NULL");

        // 2. Drop any existing foreign key on purchase_id
        // (safe even if none exists, MySQL ignores if not found)
        DB::statement("ALTER TABLE service_purchase_logs DROP FOREIGN KEY IF EXISTS service_purchase_logs_purchase_id_foreign");

        // 3. Add foreign key with unique name
        DB::statement("
            ALTER TABLE service_purchase_logs
            ADD CONSTRAINT fk_service_purchase_logs_purchase
            FOREIGN KEY (purchase_id) REFERENCES purchases(id) ON DELETE CASCADE
        ");

        // 4. Add deleted_at to settings table
        DB::statement("ALTER TABLE settings ADD COLUMN deleted_at TIMESTAMP NULL DEFAULT NULL AFTER updated_at");

        // 5. Fix payment_methods NULL values
        DB::statement("
            UPDATE payment_methods 
            SET 
                code = name,
                type = CASE 
                    WHEN name IN ('cash', 'bank') THEN 'manual'
                    WHEN name = 'mpesa' THEN 'mobile'
                    WHEN name = 'cod' THEN 'cash_on_delivery'
                    WHEN name = 'multiple' THEN 'split'
                    ELSE 'other'
                END,
                provider = CASE 
                    WHEN name = 'mpesa' THEN 'safaricom'
                    WHEN name = 'bank' THEN 'bank_transfer'
                    ELSE NULL
                END
            WHERE code IS NULL
        ");
    }

    public function down(): void
    {
        // Rollback foreign key
        DB::statement("ALTER TABLE service_purchase_logs DROP FOREIGN KEY fk_service_purchase_logs_purchase");

        // Rollback column type (back to signed BIGINT)
        DB::statement("ALTER TABLE service_purchase_logs MODIFY purchase_id BIGINT NOT NULL");

        // Rollback deleted_at column
        DB::statement("ALTER TABLE settings DROP COLUMN deleted_at");

        // Rollback payment_methods fix (reset to NULL)
        DB::statement("
            UPDATE payment_methods 
            SET code = NULL, type = NULL, provider = NULL
            WHERE code = name
        ");
    }
};
