<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('store_information', function (Blueprint $table) {
            // Contact Information
            $table->string('email')->nullable()->after('telephone');
            
            // Location Information
            $table->string('city')->nullable()->after('address');
            $table->string('country')->nullable()->after('city');
            
            // Business Information
            $table->string('currency', 10)->nullable()->after('country');
            $table->string('timezone', 50)->nullable()->after('currency');
            $table->string('vat_number')->nullable()->after('company_pin');
            $table->string('branch_code', 20)->nullable()->after('vat_number');
            
            // Legal/Registration Information
            $table->string('business_registration')->nullable()->after('branch_code');
            $table->string('kra_pin')->nullable()->after('business_registration');
            $table->string('permit_number')->nullable()->after('kra_pin');
            
            // Business Hours (store as JSON)
            $table->json('business_hours')->nullable()->after('permit_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('store_information', function (Blueprint $table) {
            $table->dropColumn([
                'email',
                'city',
                'country',
                'currency',
                'timezone',
                'vat_number',
                'branch_code',
                'business_registration',
                'kra_pin',
                'permit_number',
                'business_hours',
            ]);
        });
    }
};
