<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_information', function (Blueprint $table) {
            $table->id();
            $table->string('store_name', 150);
            $table->string('logo')->nullable(); // path or filename
            $table->string('whatsapp_number', 20)->nullable();
            $table->string('telephone', 20)->nullable();
            $table->string('address', 255)->nullable();
            $table->string('company_pin', 50)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_information');
    }
};
