<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('customers', function (Blueprint $table) {
            // Add VAT status fields
            $table->enum('vat_status', ['vatable', 'exempted', 'zero_rated'])->default('vatable')->after('is_vat_registered');
            $table->string('vat_exemption_number', 100)->nullable()->after('vat_status');
            $table->string('vat_exemption_certificate_no', 100)->nullable()->after('vat_exemption_number');
            $table->text('vat_exemption_reason')->nullable()->after('vat_exemption_certificate_no');
            $table->date('vat_exemption_start_date')->nullable()->after('vat_exemption_reason');
            $table->date('vat_exemption_end_date')->nullable()->after('vat_exemption_start_date');
            $table->string('vat_exemption_approved_by', 255)->nullable()->after('vat_exemption_end_date');
            
            $table->boolean('is_zero_rated')->default(false)->after('vat_exemption_approved_by');
            $table->date('zero_rated_start_date')->nullable()->after('is_zero_rated');
            $table->date('zero_rated_end_date')->nullable()->after('zero_rated_start_date');
            $table->text('zero_rated_reason')->nullable()->after('zero_rated_end_date');
            
            $table->decimal('total_vat_paid', 12, 2)->default(0.00)->after('vat_collected');
        });
    }

    public function down()
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn([
                'vat_status',
                'vat_exemption_number',
                'vat_exemption_certificate_no',
                'vat_exemption_reason',
                'vat_exemption_start_date',
                'vat_exemption_end_date',
                'vat_exemption_approved_by',
                'is_zero_rated',
                'zero_rated_start_date',
                'zero_rated_end_date',
                'zero_rated_reason',
                'total_vat_paid',
            ]);
        });
    }
};