<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->enum('status', ['pending', 'completed', 'failed', 'refunded'])
                  ->default('completed')
                  ->after('id');

            $table->text('notes')->nullable()->after('status');

            $table->foreignId('received_by')
                  ->nullable()
                  ->constrained('users')
                  ->onDelete('set null')
                  ->after('notes');

            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropForeign(['received_by']);
            $table->dropColumn(['status', 'notes', 'received_by']);
        });
    }
};
