<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->boolean('is_vat_registered')->default(false)->after('vat_number');
            $table->decimal('taxable_sales', 12, 2)->default(0)->after('total_spent');
            $table->decimal('vat_collected', 12, 2)->default(0)->after('taxable_sales');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn(['is_vat_registered', 'taxable_sales', 'vat_collected']);
        });
    }
};