<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class FixSalesTableSchema extends Migration
{
    public function up()
    {
        // Check if 'status' column exists, if not add it
        if (!Schema::hasColumn('sales', 'status')) {
            Schema::table('sales', function (Blueprint $table) {
                $table->string('status')->default('pending')->after('grand_total');
                $table->index('status');
            });
        }

        // Rename 'change' column if it exists (reserved keyword)
        if (Schema::hasColumn('sales', 'change')) {
            Schema::table('sales', function (Blueprint $table) {
                $table->renameColumn('change', 'change_amount');
            });
        }

        // Add missing columns if they don't exist
        $columnsToAdd = [
            'cash_received' => 'decimal:10,2',
            'mpesa_received' => 'decimal:10,2',
            'card_received' => 'decimal:10,2',
            'bank_received' => 'decimal:10,2',
            'credit_amount' => 'decimal:10,2',
            'customer_change' => 'decimal:10,2',
            'payment_method' => 'string',
            'transaction_id' => 'string',
            'payment_status' => 'string',
        ];

        foreach ($columnsToAdd as $column => $type) {
            if (!Schema::hasColumn('sales', $column)) {
                Schema::table('sales', function (Blueprint $table) use ($column, $type) {
                    $parts = explode(':', $type);
                    $type = $parts[0];
                    $params = isset($parts[1]) ? explode(',', $parts[1]) : [];
                    
                    if ($type === 'decimal') {
                        $table->decimal($column, $params[0], $params[1])->nullable();
                    } else {
                        $table->{$type}($column)->nullable();
                    }
                });
            }
        }
    }

    public function down()
    {
        // We generally don't roll back schema fixes
    }
}