<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('taxes', function (Blueprint $table) {
            $table->decimal('extra_tax', 5, 2)->default(0)->after('rate');
        });
    }

    public function down(): void {
        Schema::table('taxes', function (Blueprint $table) {
            if (Schema::hasColumn('taxes', 'extra_tax')) {
                $table->dropColumn('extra_tax');
            }
        });
    }
};
