<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // First check if sales table exists
        if (!Schema::hasTable('sales')) {
            return;
        }
        
        // Add eTIMS columns without specifying 'after'
        Schema::table('sales', function (Blueprint $table) {
            if (!Schema::hasColumn('sales', 'etims_invoice_number')) {
                $table->string('etims_invoice_number')->nullable();
            }
            
            if (!Schema::hasColumn('sales', 'etims_qr_code')) {
                $table->text('etims_qr_code')->nullable();
            }
            
            if (!Schema::hasColumn('sales', 'etims_response')) {
                $table->json('etims_response')->nullable();
            }
            
            if (!Schema::hasColumn('sales', 'etims_sent_at')) {
                $table->timestamp('etims_sent_at')->nullable();
            }
            
            if (!Schema::hasColumn('sales', 'etims_status')) {
                $table->enum('etims_status', ['pending', 'sent', 'confirmed', 'failed'])
                    ->default('pending');
            }
        });
    }

    public function down(): void
    {
        // Safe down method - don't drop columns
        // Schema::table('sales', function (Blueprint $table) {
        //     $table->dropColumn([
        //         'etims_invoice_number',
        //         'etims_qr_code',
        //         'etims_response',
        //         'etims_sent_at',
        //         'etims_status'
        //     ]);
        // });
    }
};