<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('mpesa_credentials', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('business_shortcode');
            $table->text('consumer_key'); // Encrypted
            $table->text('consumer_secret'); // Encrypted
            $table->text('passkey'); // Encrypted
            $table->string('initiator_name')->nullable();
            $table->text('initiator_password')->nullable(); // Encrypted
            $table->text('security_credential')->nullable(); // Encrypted
            $table->enum('environment', ['sandbox', 'production'])->default('sandbox');
            $table->string('callback_url')->nullable();
            $table->boolean('is_active')->default(false);
            $table->timestamp('last_success')->nullable();
            $table->timestamp('last_failure')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index('is_active');
            $table->index('environment');
            $table->index('business_shortcode');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mpesa_credentials');
    }
};