<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddCreditFieldsToSuppliersTable extends Migration
{
    public function up()
    {
        Schema::table('suppliers', function (Blueprint $table) {
            if (!Schema::hasColumn('suppliers', 'credit_limit')) {
                $table->decimal('credit_limit', 15, 2)->default(0)->after('notes');
            }
            if (!Schema::hasColumn('suppliers', 'current_balance')) {
                $table->decimal('current_balance', 15, 2)->default(0)->after('credit_limit');
            }
            if (!Schema::hasColumn('suppliers', 'credit_terms')) {
                $table->string('credit_terms', 100)->nullable()->after('current_balance');
            }
        });
    }

    public function down()
    {
        Schema::table('suppliers', function (Blueprint $table) {
            $table->dropColumn(['credit_limit', 'current_balance', 'credit_terms']);
        });
    }
}