<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('price_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            
            // Pricing
            $table->enum('price_type', ['cost_price', 'sale_price', 'wholesale_price'])->default('sale_price');
            $table->decimal('old_price', 12, 2);
            $table->decimal('new_price', 12, 2);
            
            // Change Information
            $table->string('change_reason')->nullable();
            $table->text('notes')->nullable();
            
            // Effective dates
            $table->date('effective_from')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['product_id', 'price_type']);
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('price_histories');
    }
};